/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.util.editor;

import com.kingdee.bos.ctrl.analysis.util.editor.EditorStyleModel;
import com.kingdee.bos.ctrl.analysis.util.editor.Lexer;
import com.kingdee.bos.ctrl.analysis.util.editor.MatchedToken;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class DefaultEditorStyleModel
implements EditorStyleModel {
    public static Font normal_font = new Font("\u5b8b\u4f53", 0, 13);
    public static Font font_larger = new Font(normal_font.getName(), normal_font.getStyle(), normal_font.getSize() + 2);
    private List list = new ArrayList();
    private Map map = new HashMap();
    protected SimpleAttributeSet defaultAttr = null;
    protected SimpleAttributeSet commentAttr = null;
    protected Font font = font_larger;

    public DefaultEditorStyleModel() {
        this.defaultAttr = this.createSimpleAttributeSet(Color.BLACK);
        this.commentAttr = this.createSimpleAttributeSet(new Color(0, 136, 136));
    }

    public void addStyle(MatchedToken mt, SimpleAttributeSet attr) {
        this.list.add(mt);
        this.map.put(mt, attr);
    }

    public void addStyle(String[] keys, SimpleAttributeSet attr) {
        HashSet<String> s = new HashSet<String>();
        int n = keys.length;
        for (int i = 0; i < n; ++i) {
            s.add(keys[i].toLowerCase());
        }
        this.list.add(s);
        this.map.put(s, attr);
    }

    public void removeStyle(MatchedToken mt) {
        this.list.remove(mt);
        this.map.remove(mt);
    }

    public void removeStyle(String[] keys) {
        HashSet<String> r = new HashSet<String>();
        int n = keys.length;
        for (int i = 0; i < n; ++i) {
            r.add(keys[i].toLowerCase());
        }
        Set s = null;
        int i = 0;
        while (i < this.list.size()) {
            Object obj = this.list.get(i);
            if (obj instanceof MatchedToken) {
                ++i;
                continue;
            }
            s = (Set)obj;
            s.removeAll(r);
            if (s.size() == 0) {
                this.list.remove(s);
                this.map.remove(s);
                continue;
            }
            ++i;
        }
    }

    public void clearStyle() {
        this.list.clear();
        this.map.clear();
    }

    @Override
    public SimpleAttributeSet getCommentAttributeSet() {
        return this.commentAttr;
    }

    @Override
    public SimpleAttributeSet getAttributeSet(String token) {
        token = token.toLowerCase();
        Set s = null;
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Object obj = this.list.get(i);
            if (obj instanceof MatchedToken) {
                MatchedToken mt = (MatchedToken)obj;
                if (!mt.match(token)) continue;
                return (SimpleAttributeSet)this.map.get(obj);
            }
            s = (Set)obj;
            if (!s.contains(token)) continue;
            return (SimpleAttributeSet)this.map.get(s);
        }
        return this.getDefaultAttributeSet();
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public String[] getWrapLineKeys() {
        return null;
    }

    protected SimpleAttributeSet getDefaultAttributeSet() {
        return this.defaultAttr;
    }

    public SimpleAttributeSet createSimpleAttributeSet(Color c) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attr, this.getFont().getFamily());
        StyleConstants.setFontSize(attr, this.getFont().getSize());
        StyleConstants.setForeground(attr, c);
        return attr;
    }

    @Override
    public void beforeRun(Lexer lex) {
    }
}

