/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web;

import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.olap.SortRank;
import com.kingdee.bos.ctrl.analysis.web.BIWebComponent;
import com.kingdee.bos.ctrl.analysis.web.WebFrameworkException;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONMap;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.UnitConverter;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BIWebComponentSupport
implements BIWebComponent,
HttpSessionBindingListener {
    private static Logger logger = CommonLogger.getLogger(BIWebComponentSupport.class);
    private static final int DEFAULT_PAGE_ROWS = 15;
    private String id;
    private String caption;
    protected int perPageRows = 15;
    protected int currentPage = 0;
    protected int rowCount;
    protected int pageCount;
    protected int rowStart;
    protected int rowEnd;
    protected static final String TAG_AXIS_ROW = "axis_row";
    protected static final String TAG_AXIS_COL = "axis_col";
    private static final String TAG_MEMBER = "member";
    private static final String ATTR_HIERARCHY_UNIQUENAME = "hierarchy.uniqueName";
    private static final String ATTR_HIERARCHY_CAPTION = "hierarchy.caption";
    private static final String SORTINFO_COLUMN_OPER = "\u0002";
    private static final String SORTINFO_MEMEBER_OPER = "\u0001";
    private static final String SORTINFO_SORT = "sort";
    private static final String SORTINFO_SORT_MODE = "sortMode";
    private static final String SORTINFO_SORT_PARAM = "sortParam";
    private static final String SORTINFO_SORT_POSITION = "sortPosition";
    private static final String SORTINFO_SORT_COLUMN_CAPTION = "sortColumnsCaption";
    private static final String SORTINFO_SORT_COLUMN_VALUE = "sortColumnsValue";

    protected abstract void clearPaginInfo();

    public OlapModel getOlapModel() {
        return null;
    }

    public String getPageInfo() {
        return new StringBuffer().append("{rows:").append(this.rowCount).append(",size:").append(this.perPageRows).append(",count:").append(this.pageCount).append(",current:").append(this.currentPage).append("}").toString();
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getPerPageRows() {
        return this.perPageRows;
    }

    public void setCurrentPage(int page) {
        this.currentPage = page;
    }

    public void setPagePerRows(int perPageRows) {
        if (perPageRows != this.perPageRows) {
            this.clearPaginInfo();
            this.perPageRows = perPageRows;
        }
    }

    protected void initPageInfo(int rowTotal) throws OlapException {
        this.rowCount = rowTotal;
        if (this.perPageRows == 0) {
            this.pageCount = 1;
        } else if (this.perPageRows > 0) {
            this.pageCount = this.rowCount / this.perPageRows;
            if (this.rowCount % this.perPageRows > 0) {
                ++this.pageCount;
            }
        } else {
            this.perPageRows = 15;
            this.pageCount = this.rowCount / this.perPageRows;
            if (this.rowCount % this.perPageRows > 0) {
                ++this.pageCount;
            }
        }
        if (this.currentPage > this.pageCount - 1) {
            this.currentPage = this.pageCount - 1;
        }
        if (this.currentPage < 0) {
            this.currentPage = 0;
        }
        if (this.perPageRows == 0) {
            this.rowStart = 0;
            this.rowEnd = this.rowCount - 1;
        } else {
            this.rowStart = this.currentPage * this.perPageRows;
            this.rowEnd = this.currentPage * this.perPageRows + this.perPageRows;
        }
        if (this.rowEnd > this.rowCount) {
            this.rowEnd = this.rowCount;
        }
    }

    protected int getRowStart() {
        return this.rowStart;
    }

    protected int getRowEnd() {
        return this.rowEnd;
    }

    public BIWebComponentSupport(String id, String caption) {
        this.id = id;
        this.caption = caption;
    }

    @Override
    public void initialize() throws WebFrameworkException {
    }

    @Override
    public void destroy() throws WebFrameworkException {
    }

    public void valueBound(HttpSessionBindingEvent e) {
    }

    public void valueUnbound(HttpSessionBindingEvent ev) {
        try {
            this.destroy();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)this.id, (Throwable)ex);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getCaption() {
        return this.caption;
    }

    protected Element buildHierachyDOM(Document document, Hierarchy[] hierarchys, String tag) {
        Element hierarchy = document.createElement(tag);
        for (int i = 0; i < hierarchys.length; ++i) {
            Hierarchy h = hierarchys[i];
            Element e = document.createElement(TAG_MEMBER);
            e.setAttribute(ATTR_HIERARCHY_UNIQUENAME, h.getUniqueName());
            e.setAttribute(ATTR_HIERARCHY_CAPTION, h.getCaption());
            hierarchy.appendChild(e);
        }
        return hierarchy;
    }

    protected int buildSlicer(KDSSheet sheet, int startRow, Member[] members) throws BIReportException {
        if (members == null || members.length == 0) {
            return startRow;
        }
        int row = startRow;
        String slicerInfo = "";
        for (int ii = 0; ii < members.length; ++ii) {
            slicerInfo = slicerInfo + members[ii].getHierarchy().getCaption() + ": " + members[ii].getCaption() + "    ";
        }
        sheet.setCellValue(row, 0, (Object)slicerInfo);
        sheet.getCellStyleAttributes(row, 0).setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        return ++row;
    }

    protected int buildCaption(KDSSheet sheet, int row, String caption, Font font) {
        int col = 0;
        sheet.setCellValue(row, col, (Object)caption);
        sheet.getCellStyleAttributes(row, col).setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        sheet.getCellStyleAttributes(row, col).setVerticalAlign(Styles.VerticalAlignment.MIDDLE);
        sheet.getCellStyleAttributes(row, col).setFont(font);
        int fontHeight = Toolkit.getDefaultToolkit().getFontMetrics(font).getHeight() + 20;
        sheet.getRows().setRowHeight(row, (float)UnitConverter.px2mm((int)fontHeight));
        return ++row;
    }

    protected void adjustCaptionSclier(KDSSheet sheet, int sheetTotalColumn, int pageContentWidth, boolean showSlicer) {
        int countWidth = 0;
        int conPageColumns = sheetTotalColumn - 1;
        for (int i = 0; i < sheetTotalColumn; ++i) {
            if ((countWidth = (int)((float)countWidth + sheet.getColumnWidth(i))) < pageContentWidth) continue;
            conPageColumns = i;
            break;
        }
        if (conPageColumns == sheetTotalColumn - 1) {
            sheet.setColumnWidth(sheetTotalColumn, (float)(pageContentWidth - countWidth - 10));
            sheet.getMerges().addMerge(0, 0, 0, conPageColumns + 1);
            if (showSlicer) {
                sheet.getMerges().addMerge(1, 0, 1, conPageColumns + 1);
            }
        } else {
            sheet.getMerges().addMerge(0, 0, 0, conPageColumns);
            if (showSlicer) {
                sheet.getMerges().addMerge(1, 0, 1, conPageColumns);
            }
        }
    }

    public void doSort(HttpServletRequest request) throws BIReportException {
        OlapModel olapModel = this.getOlapModel();
        SortRank sortRank = (SortRank)olapModel.getExtension("sortRank");
        Axis leftAxis = null;
        try {
            leftAxis = OlapModelUtil.getLeftAxis(olapModel);
        }
        catch (OlapException e) {
            throw new BIReportException(e);
        }
        sortRank.setAxisToSort(leftAxis.getOrdinal());
        boolean useSort = "true".equalsIgnoreCase(request.getParameter(SORTINFO_SORT));
        sortRank.setSorting(useSort);
        if (useSort) {
            int sortMode = (int)Double.parseDouble(request.getParameter(SORTINFO_SORT_MODE));
            sortRank.setSortMode(sortMode);
            String sortParam = request.getParameter(SORTINFO_SORT_PARAM);
            if (sortMode <= 6) {
                int sortValue = 10;
                try {
                    sortValue = (int)Double.parseDouble(sortParam);
                }
                catch (NumberFormatException e) {
                    throw new BIReportException(e);
                }
                sortRank.setTopBottomCount(sortValue);
            } else {
                double sortValue = 10.0;
                try {
                    sortValue = Double.parseDouble(sortParam);
                }
                catch (NumberFormatException e) {
                    throw new BIReportException(e);
                }
                sortRank.setTopBottomValue(sortValue);
            }
            int sortPosition = (int)Double.parseDouble(request.getParameter(SORTINFO_SORT_POSITION));
            List positions = null;
            try {
                positions = OlapModelUtil.getTopAxis(olapModel).getPositions();
            }
            catch (OlapException e) {
                throw new BIReportException(e);
            }
            sortRank.setSortPosition((Position)positions.get(sortPosition));
        }
        olapModel.postModelChanged();
    }

    public String getSortInfo(HttpServletRequest request) throws BIReportException {
        OlapModel olapModel = this.getOlapModel();
        HashMap<String, Object> mapSortInfo = new HashMap<String, Object>();
        SortRank sortRank = (SortRank)olapModel.getExtension("sortRank");
        mapSortInfo.put(SORTINFO_SORT, new Boolean(sortRank.isSorting()));
        mapSortInfo.put(SORTINFO_SORT_MODE, new Integer(sortRank.getSortMode()));
        if (sortRank.getSortMode() <= 6) {
            mapSortInfo.put(SORTINFO_SORT_PARAM, new Integer(sortRank.getTopBottomCount()));
        } else {
            mapSortInfo.put(SORTINFO_SORT_PARAM, new Double(sortRank.getTopBottomValue()));
        }
        Position curPosition = sortRank.getSortPosition();
        int curPos = -1;
        StringBuffer sbCaption = new StringBuffer();
        StringBuffer sbValue = new StringBuffer();
        Object axis = null;
        try {
            List positions = OlapModelUtil.getTopAxis(olapModel).getPositions();
            Iterator it = positions.iterator();
            boolean first = true;
            int counter = 0;
            while (it.hasNext()) {
                Position pos = (Position)it.next();
                if (this.comparePositions(curPosition, pos)) {
                    curPos = counter;
                }
                ++counter;
                Member[] members = pos.getMembers();
                if (members.length <= 0) continue;
                if (first) {
                    first = false;
                } else {
                    sbCaption.append(SORTINFO_COLUMN_OPER);
                    sbValue.append(SORTINFO_COLUMN_OPER);
                }
                for (int i = 0; i < members.length; ++i) {
                    if (i > 0) {
                        sbCaption.append(SORTINFO_MEMEBER_OPER);
                        sbValue.append(SORTINFO_MEMEBER_OPER);
                    }
                    sbCaption.append(members[i].getLabel());
                    sbValue.append(members[i].getUniqueName());
                }
            }
        }
        catch (OlapException e) {
            throw new BIReportException(e);
        }
        mapSortInfo.put(SORTINFO_SORT_POSITION, new Integer(curPos));
        mapSortInfo.put(SORTINFO_SORT_COLUMN_CAPTION, sbCaption.toString());
        mapSortInfo.put(SORTINFO_SORT_COLUMN_VALUE, sbValue.toString());
        JSONMap jm = new JSONMap(mapSortInfo);
        return jm.toString();
    }

    private boolean comparePositions(Position pos1, Position pos2) {
        if (pos1 == null || pos2 == null) {
            return false;
        }
        List<Member> list1 = Arrays.asList(pos1.getMembers());
        List<Member> list2 = Arrays.asList(pos2.getMembers());
        Iterator<Member> iter = list1.iterator();
        while (iter.hasNext()) {
            if (list2.contains(iter.next())) continue;
            return false;
        }
        return true;
    }
}

