/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ajax;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.BIWebUtilServletHandler;
import com.kingdee.bos.ctrl.analysis.web.ajax.Constants;
import com.kingdee.bos.ctrl.analysis.web.ajax.DataCenterServletHandler;
import com.kingdee.bos.ctrl.analysis.web.ajax.PageManager;
import com.kingdee.bos.ctrl.analysis.web.ajax.PictureUtil;
import com.kingdee.bos.ctrl.analysis.web.ajax.ReportPage;
import com.kingdee.bos.ctrl.analysis.web.ajax.ReportRequestHandler;
import com.kingdee.bos.ctrl.analysis.web.ajax.RequestHandler;
import com.kingdee.bos.ctrl.analysis.web.ajax.ServletHandlerFactory;
import com.kingdee.bos.ctrl.analysis.web.ajax.ServletHelper;
import com.kingdee.bos.ctrl.analysis.web.ajax.UploadHandler;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSON;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONString;
import com.kingdee.bos.ctrl.analysis.web.chart.GetChartServletHandler;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DashboardServletHandler;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DataSource;
import com.kingdee.bos.ctrl.analysis.web.dashboard.authorized.DashBoardAuthorized;
import com.kingdee.bos.ctrl.analysis.web.export.ExportServletHandler;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.handler.ExtServletHandler;
import com.kingdee.bos.ctrl.analysis.web.globalparam.GlobalParamServletHandler;
import com.kingdee.bos.ctrl.analysis.web.homepage.BIFirstPageServletHandler;
import com.kingdee.bos.ctrl.analysis.web.permission.MetaData_EAS;
import com.kingdee.bos.ctrl.analysis.web.portlet.PortletUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.systemconfigure.SystemConfigureServletHandler;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUpload;
import org.apache.log4j.Logger;

public class BIReportServlet0
extends HttpServlet {
    private static final RequestHandler BIREPORT_HANDLER = new ReportRequestHandler();
    private static final RequestHandler UPLOAD_HANDLER = new UploadHandler();
    private static final Logger logger = CommonLogger.getLogger(BIReportServlet0.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        PageManager.startTimeoutThread();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletHelper.adjustRequestResponse(request, response);
        String ret = "";
        String servletType = request.getParameter("servletType");
        if ("export".equalsIgnoreCase(servletType)) {
            ExportServletHandler.handle(request, response);
        } else if ("getPicture".equalsIgnoreCase(servletType)) {
            String path = request.getParameter("repositoryPath");
            try {
                ret = PictureUtil.getPicture(request, path);
            }
            catch (BIReportException e) {
                ret = e.getMessage();
            }
            ServletHelper.writeOut(response, ret);
        } else if ("BIFirstPage".equalsIgnoreCase(servletType)) {
            try {
                JSON retJson = BIFirstPageServletHandler.handle(request, response);
                ServletHelper.writeOut(response, retJson.toString());
            }
            catch (BIReportException e) {
                ServletHelper.writeOut(response, ServletHelper.wrapError(new JSONString(e.getMessage())));
            }
        } else if ("SystemConfigure".equalsIgnoreCase(servletType)) {
            try {
                JSON retJson = SystemConfigureServletHandler.handle(request, response);
                ServletHelper.writeOut(response, retJson.toString());
            }
            catch (BIReportException e) {
                ServletHelper.writeOut(response, ServletHelper.wrapError(new JSONString(e.getMessage())));
            }
        } else if ("GlobalParam".equalsIgnoreCase(servletType)) {
            try {
                JSON retJson = GlobalParamServletHandler.handle(request, response);
                ServletHelper.writeOut(response, retJson.toString());
            }
            catch (BIReportException e) {
                ServletHelper.writeOut(response, ServletHelper.wrapError(new JSONString(e.getMessage())));
            }
        } else if ("BIDashBoard".equalsIgnoreCase(servletType)) {
            try {
                JSON retJson = DashboardServletHandler.handle(request, response);
                ServletHelper.writeOut(response, retJson.toString());
            }
            catch (BIReportException e) {
                ServletHelper.writeOut(response, ServletHelper.wrapError(new JSONString(e.getMessage())));
            }
        } else if ("BIWebUtil".equalsIgnoreCase(servletType)) {
            try {
                JSON retJson = BIWebUtilServletHandler.handle(request, response);
                ServletHelper.writeOut(response, ServletHelper.wrapNormal(retJson));
            }
            catch (BIReportException e) {
                ServletHelper.writeOut(response, ServletHelper.wrapError(new JSONString(e.getMessage())));
            }
        } else if ("getDataCenterList".equalsIgnoreCase(servletType)) {
            try {
                JSON retJson = DataCenterServletHandler.handle(request, response);
                ServletHelper.writeOut(response, retJson.toString());
            }
            catch (BIReportException e) {
                ServletHelper.writeOut(response, ServletHelper.wrapError(new JSONString(e.getMessage())));
            }
        } else if ("GetChart".equalsIgnoreCase(servletType)) {
            GetChartServletHandler.handle(request, response);
        } else if ("report".equalsIgnoreCase(servletType) || "extReport".equalsIgnoreCase(servletType) || "dupontReport".equalsIgnoreCase(servletType) || "bimOlapReport".equalsIgnoreCase(servletType)) {
            try {
                ReportPage page = (ReportPage)PageManager.createPage(servletType, request, response);
                ret = page.init(request);
            }
            catch (BIReportException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                ret = e.getMessage();
            }
            ServletHelper.writeOut(response, ret);
        } else if ("portlet".equalsIgnoreCase(servletType)) {
            this.doPortlet(request, response);
        } else if ("logout".equalsIgnoreCase(servletType)) {
            this.doLogoutBefore(request);
        } else {
            if ("ExtServlet".equals(servletType)) {
                try {
                    ExtServletHandler.handler(request, response);
                }
                catch (BIReportException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                    ServletHelper.writeOut(response, ServletHelper.wrapError(new JSONString(e.getMessage())));
                }
                return;
            }
            if ("bimng".equals(servletType)) {
                try {
                    ServletHandlerFactory.getServletHandler().service(request, response);
                }
                catch (BIReportException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
                catch (ServletException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
            } else {
                String isFromLoader = request.getParameter("fromLoader");
                if (!"true".equals(isFromLoader)) {
                    response.sendRedirect(request.getContextPath() + "/biweb/html/report_loader.htm?servletURL=" + request.getContextPath() + "/" + Constants.SERVLET_URL + "&load=" + request.getRequestURI() + "?" + request.getQueryString() + "&fromLoader=true");
                    return;
                }
                try {
                    ReportPage page = (ReportPage)PageManager.createPage("report", request, response);
                    ret = page.init(request);
                }
                catch (BIReportException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                    ret = e.getMessage();
                }
                ServletHelper.writeOut(response, ret);
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String servletType = request.getParameter("servletType");
        ServletHelper.adjustRequestResponse(request, response);
        if (FileUpload.isMultipartContent((HttpServletRequest)request)) {
            String ret;
            if ("upload".equalsIgnoreCase(request.getParameter("action"))) {
                try {
                    ServletHandlerFactory.getServletHandler().service(request, response);
                }
                catch (BIReportException e) {
                    String ret2 = ServletHelper.wrapError(new JSONString(e.getMessage()));
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
                return;
            }
            try {
                ret = ServletHelper.wrapNormal(UPLOAD_HANDLER.handle(request, response));
            }
            catch (BIReportException e) {
                ret = ServletHelper.wrapError(new JSONString(e.getMessage()));
            }
            ServletHelper.writeOut(response, ret);
        } else if ("portlet".equalsIgnoreCase(servletType)) {
            this.doPortlet(request, response);
        } else if ("logout".equalsIgnoreCase(servletType)) {
            this.doLogoutBefore(request);
        } else if ("HttpProxy".equalsIgnoreCase(servletType)) {
            String data = DataSource.getGridPanelData(request);
            ServletHelper.writeOut(response, data);
        } else {
            boolean isJsonRequest;
            if ("ExtServlet".equals(servletType)) {
                try {
                    ExtServletHandler.handler(request, response);
                }
                catch (BIReportException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                    ServletHelper.writeOut(response, ServletHelper.wrapError(new JSONString(e.getMessage())));
                }
                return;
            }
            boolean bl = isJsonRequest = request.getParameter("json") != null;
            if (isJsonRequest) {
                ServletHelper.handleJSONRPC(request, response, BIREPORT_HANDLER);
            } else {
                String ret = "";
                if ("extReport".equalsIgnoreCase(servletType)) {
                    try {
                        ReportPage page = (ReportPage)PageManager.createPage(servletType, request, response);
                        ret = page.init(request);
                    }
                    catch (BIReportException e) {
                        logger.warn((Object)e.getMessage(), (Throwable)e);
                        ret = e.getMessage();
                    }
                    ServletHelper.writeOut(response, ret);
                }
            }
        }
    }

    private void doPortlet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String permissionId = null;
        String path = null;
        String url = null;
        String portletType = "";
        String tabCaption = "\u4eea\u8868\u677f\u9875\u7b7e";
        if (request.getAttribute("dashboard") != null) {
            portletType = "dashboard";
        } else if (request.getAttribute("olap") != null) {
            portletType = "olap";
        } else if (request.getAttribute("ext") != null) {
            portletType = "ext";
        } else if (request.getAttribute("dupont") != null) {
            portletType = "dupont";
        } else if (request.getAttribute("folder") != null) {
            portletType = "folder";
        } else if (request.getAttribute("bimolap") != null) {
            portletType = "bimolap";
        }
        permissionId = (String)request.getAttribute(portletType);
        request.removeAttribute(portletType);
        if (permissionId.indexOf("@//") != -1) {
            permissionId = permissionId.split("@//")[0];
        }
        try {
            path = MetaData_EAS.getTreePathByID(BISystem.getJdbcConnection(request), permissionId, portletType);
            url = PortletUtil.getURLFromNodePath(request, portletType, path);
        }
        catch (BIReportException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        String outputString = null;
        outputString = "<iframe id='__bi_portlet_iframe' src='" + url + "' style='width:100%;height:600px;border:none' frameborder='0' scrolling='no' noresize='noresize' ></iframe><script> //var initHeight = window.screen.availHeight - 240;//document.getElementById( '__bi_portlet_iframe' ).style.height = initHeight + 'px'; </script>";
        response.getWriter().println(outputString);
    }

    private void doLogoutBefore(HttpServletRequest request) {
        PageManager.close(request);
    }

    public static String getAllUsers(Context ctx) {
        return DashBoardAuthorized.getAllUsers(ctx);
    }

    public static String getAllRoles(Context ctx) {
        return DashBoardAuthorized.getAllRoles(ctx);
    }

    public static String getAllDashBoards(Context ctx, HttpServletRequest request) {
        return DashBoardAuthorized.getAllDashBoards(ctx, request);
    }

    public static String getFirsTreeLevel() {
        return DashBoardAuthorized.getFirsLevelDiretory();
    }

    public static String getDiretoryByDiretoryID(Context ctx, String DiretoryID) {
        return DashBoardAuthorized.getDashboardDiretoryByDiretoryID(ctx, DiretoryID);
    }

    public static String getDashBoardByDirectoryID(Context ctx, String DiretoryID, HttpServletRequest request) {
        return DashBoardAuthorized.getDashBoardsByDiretoryID(ctx, DiretoryID, request);
    }

    public static String getFirsOrgLevel(Context ctx) {
        return DashBoardAuthorized.getFirsOrgLevel(ctx);
    }

    public static String getOrgByOrgID(Context ctx, String orgId) {
        return DashBoardAuthorized.getOrgByOrgID(ctx, orgId);
    }

    public static String getUserPermissions_dg(Context ctx, HttpServletRequest request, String userIds, String dashboardIds, String orgId) {
        return DashBoardAuthorized.getUserPermissions_dg(ctx, request, userIds, dashboardIds, orgId);
    }

    public static String saveUserAuthorized(String allParams, Context ctx) {
        return DashBoardAuthorized.saveUserAuthorized(allParams, ctx);
    }

    public static String saveRoleAuthorized(String allParams, Context ctx) {
        return DashBoardAuthorized.saveRoleAuthorized(allParams, ctx);
    }

    public static String saveRightsManagement(String userPermissionDatas, String rolePermissionDatas, Context ctx) {
        return DashBoardAuthorized.saveRightsManagement(userPermissionDatas, rolePermissionDatas, ctx);
    }

    public static String getRolePermissions_dg(Context ctx, HttpServletRequest request, String roleIds, String dashboardIds) {
        return DashBoardAuthorized.getRolePermissions_dg(ctx, request, roleIds, dashboardIds);
    }
}

