/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ajax;

import com.kingdee.bos.ctrl.analysis.common.dbcenter.DBCenterException;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.service.DBCenterManager;
import com.kingdee.bos.ctrl.analysis.olap.ModelFactory;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.util.bitemptable.BITempTableDBSManager;
import com.kingdee.bos.ctrl.analysis.web.piece.DynamicPiece;
import com.kingdee.bos.ctrl.analysis.web.solution.AbstractVarProvider;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReport;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReportFactory;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReportVarProvider;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.MacroVariant;
import com.kingdee.bos.ctrl.analysis.web.solution.ScriptSQL;
import com.kingdee.bos.ctrl.analysis.web.solution.def.DataSourceDef;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.FilterValue;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.PieceFilterValue;
import com.kingdee.bos.ctrl.analysis.web.solution.impl.DataProviderImpl;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.olap.Driver;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.sql.KSqlUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OlapModelManager {
    private static final Logger logger = CommonLogger.getLogger(OlapModelManager.class);
    private HashMap olapModelMap = new HashMap();
    private HashMap connectionMap = new HashMap();
    private HashMap shareConnectionMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOlapModel(String name, DynamicPiece piece, HttpServletRequest request) throws BIReportException {
        List macroList;
        long lStart = System.currentTimeMillis();
        logger.debug((Object)("createOlapModel " + name + " start! "));
        com.kingdee.bos.olap.Connection con = null;
        BIReport report = BIReportFactory.buildBIReport(piece.getSubjectName(), piece.getReportPath(), piece.getDatacenter());
        String reportUUID = report.getSubjectPath() + report.getPath();
        String varFileName = report.getSubject().getRuntimeVarFilename();
        String varClassName = report.getSubject().getRuntimeVarClassname();
        BIReportVarProvider varProvider = new BIReportVarProvider(BISystem.getContext(request), !BISystem.isEAS(), varFileName, varClassName, piece.getDatacenter());
        PieceFilterValue fv = null;
        if (piece.getFilterParams() != null) {
            fv = new PieceFilterValue(report, piece.getFilterParams());
        }
        HashMap hashMap = this.shareConnectionMap;
        synchronized (hashMap) {
            ConnectionShared conShare;
            if (this.shareConnectionMap.containsKey(reportUUID)) {
                conShare = (ConnectionShared)this.shareConnectionMap.get(reportUUID);
                conShare.addRef();
                this.connectionMap.put(name, conShare);
                con = conShare.getConnection();
                logger.debug((Object)("getOlapConnection " + piece.getName() + " from connectionMap! "));
            } else {
                con = this.getOlapConnection(piece, request, varProvider);
                conShare = new ConnectionShared(con, reportUUID);
                this.shareConnectionMap.put(reportUUID, conShare);
                this.connectionMap.put(name, conShare);
            }
        }
        String newMDX = piece.getMDX();
        if (piece.getFilterParams() != null && null != fv && (macroList = fv.getMacroList()) != null && !macroList.isEmpty()) {
            newMDX = MacroVariant.handleStatement(macroList, piece.getMDX());
            varProvider.putMacroList(macroList);
        }
        newMDX = new ScriptSQL().transSql(newMDX, (AbstractVarProvider)varProvider, Arrays.asList("[V$All]"), Arrays.asList("[V&All]"));
        try {
            logger.debug((Object)("[MDX] " + newMDX));
            OlapModel olapModel = ModelFactory.makeKDOlapModel(con, newMDX);
            HashMap hashMap2 = this.olapModelMap;
            synchronized (hashMap2) {
                this.olapModelMap.put(name, olapModel);
            }
        }
        catch (OlapException e) {
            logger.error((Object)("makeKDOlapModel failed! caused:" + e.getMessage()));
            throw new BIReportException(e);
        }
        logger.debug((Object)("createOlapModel " + name + " end! cost " + (System.currentTimeMillis() - lStart)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapModel getOlapModel(String name) {
        HashMap hashMap = this.olapModelMap;
        synchronized (hashMap) {
            return (OlapModel)this.olapModelMap.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(String name) {
        OlapModel olapModel = this.getOlapModel(name);
        logger.debug((Object)("destroy olapModel " + name));
        olapModel.destroy();
        HashMap hashMap = this.shareConnectionMap;
        synchronized (hashMap) {
            ConnectionShared con = (ConnectionShared)this.connectionMap.get(name);
            if (con.release()) {
                this.shareConnectionMap.remove(con.getUuid());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized com.kingdee.bos.olap.Connection getOlapConnection(HttpServletRequest request, BIReport report, BIReportVarProvider varProvider, FilterValue fv) throws BIReportException {
        isMolap = report.isMolap();
        dsf = new DataSourceDef(report.getDataSourceStream());
        dataProvider = new DataProviderImpl(dsf, varProvider.getDatacenter());
        dsf.close();
        params = dataProvider.getAllDataSource(varProvider, fv);
        ctx = BISystem.getContext(request);
        dbcenter = varProvider.getDatacenter();
        dataSource = BISystem.getDataSource(request, dbcenter);
        params.put("JdbcDataSource", dataSource);
        if (dbcenter != null) {
            try {
                dbcenterId = DBCenterManager.getDBCenterId(ctx, dbcenter);
                ttm = BITempTableDBSManager.getTampTableManager(ctx, dbcenterId);
                if (ttm == null) ** GOTO lbl25
                params.put("ITempTableManager.ID", ttm);
            }
            catch (DBCenterException e) {
                throw new BIReportException(e);
            }
        } else {
            ttm = BISystem.getTempTableManager(request);
            if (ttm != null) {
                params.put("ITempTableManager.ID", ttm);
            }
        }
lbl25:
        // 5 sources

        isKsql = true;
        con = null;
        try {
            con = dataSource.getConnection();
            KSqlUtil.getDbType((Connection)con);
        }
        catch (SQLException e) {
            isKsql = false;
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    OlapModelManager.logger.error((Object)("connection close failed:" + e.getMessage()));
                }
            }
        }
        if (isKsql) {
            params.put("OLAP_KEY_KSQL", Boolean.TRUE);
        }
        is = null;
        try {
            is = report.getCubeStream();
            if (fv != null && (macroList = fv.getMacroList()) != null && !macroList.isEmpty()) {
                is = MacroVariant.handleStatement(macroList, is);
            }
            is = new ScriptSQL().transSql(is, (AbstractVarProvider)varProvider, Arrays.asList(new String[]{"[V$All]"}), Arrays.asList(new String[]{"[V&All]"}));
            if (ctx != null) {
                locale = ctx.getLocale();
                if ("l1".equals(locale.getLanguage())) {
                    locale = Locale.US;
                } else if ("l2".equals(locale.getLanguage())) {
                    locale = Locale.CHINA;
                } else if ("l3".equals(locale.getLanguage())) {
                    locale = Locale.TAIWAN;
                }
                if (locale == null) {
                    locale = Locale.CHINA;
                }
                params.put("Locale", locale);
            }
            locale = Driver.openConnection((InputStream)is, (Map)params, (boolean)(isMolap == false));
        }
        catch (IOException e) {
            try {
                throw new BIReportException("\u65e0\u6cd5\u6253\u5f00Cube\u6587\u4ef6.", e);
                catch (OLAPException e) {
                    throw new BIReportException("\u65e0\u6cd5\u5efa\u7acbOLAP\u8fde\u63a5.", e);
                }
            }
            catch (Throwable var16_24) {
                CloseUtil.close((Closeable[])new Closeable[]{is});
                throw var16_24;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{is});
        return locale;
    }

    private synchronized com.kingdee.bos.olap.Connection getOlapConnection(DynamicPiece dPiece, HttpServletRequest request, BIReportVarProvider varProvider) throws BIReportException {
        BIReport report = BIReportFactory.buildBIReport(dPiece.getSubjectName(), dPiece.getReportPath(), dPiece.getDatacenter());
        PieceFilterValue fv = null;
        if (dPiece.getFilterParams() != null) {
            fv = new PieceFilterValue(report, dPiece.getFilterParams());
        }
        return OlapModelManager.getOlapConnection(request, report, varProvider, fv);
    }

    class ConnectionShared {
        private com.kingdee.bos.olap.Connection con;
        private String uuid;
        private int used = 0;

        public ConnectionShared(com.kingdee.bos.olap.Connection con, String uuid) {
            this.con = con;
            this.uuid = uuid;
            this.addRef();
        }

        public String getUuid() {
            return this.uuid;
        }

        public com.kingdee.bos.olap.Connection getConnection() {
            return this.con;
        }

        public synchronized void addRef() {
            ++this.used;
        }

        public synchronized boolean release() {
            --this.used;
            if (this.used == 0) {
                try {
                    logger.debug((Object)("close connection " + this.uuid));
                    this.con.close();
                }
                catch (OLAPException e) {
                    e.printStackTrace();
                }
            }
            return this.used == 0;
        }
    }
}

