/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ajax;

import com.kingdee.bos.ctrl.analysis.web.ajax.ReportPage;
import com.kingdee.bos.ctrl.analysis.web.ajax.UIOManager;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReport;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReportComponent;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReportScheme;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilter;
import java.util.List;

public class SchemeUI {
    private BIReport report;
    private UIOManager uioManager;

    public SchemeUI(BIReport report, UIOManager uioManager) {
        this.report = report;
        this.uioManager = uioManager;
    }

    public String generateUI() throws BIReportException {
        StringBuffer sb = new StringBuffer();
        BIReportFilter filter = this.report.getFilter(null);
        if (filter != null) {
            sb.append("filter:");
            ReportPage.createUIOInfo(this.uioManager.createFilterUIO(filter), sb);
            sb.append("~~");
        }
        List schemeList = this.report.getSchemeList();
        int len = schemeList.size();
        for (int i = 0; i < len; ++i) {
            BIReportScheme scheme = (BIReportScheme)schemeList.get(i);
            String schemeName = scheme.getName();
            String schemeCaption = scheme.getCaption();
            String schemeTitle = scheme.getTitle();
            String schemeMemoHead = scheme.getMemoHead();
            String schemeMemoTail = scheme.getMemoTail();
            String schemeChartLayout = scheme.getChartLayout();
            int perPageRows = scheme.getPerPageRows();
            sb.append(schemeChartLayout + "&&");
            sb.append(schemeCaption + "::");
            sb.append(schemeTitle + "::");
            sb.append(schemeMemoHead + "::");
            sb.append(schemeMemoTail + "::");
            sb.append(schemeName + "::");
            List coms = this.report.getComponents(schemeName);
            for (BIReportComponent birc : coms) {
                if (birc.getType().equals("worksheet")) {
                    ReportPage.createUIOInfo(this.uioManager.createWorksheetUIO(birc, schemeName, perPageRows), sb);
                } else if (birc.getType().equals("chart")) {
                    ReportPage.createUIOInfo(this.uioManager.createChartUIO(birc, schemeName, perPageRows), sb);
                }
                sb.append("||");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            sb.append("~~");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

