/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ajax.threadscheduler;

import com.kingdee.bos.ctrl.analysis.web.ajax.threadscheduler.PatternNode;

public class PatternNodeImpl
implements PatternNode {
    private String value;
    private PatternNode leftNode;
    private PatternNode rightNode;

    PatternNodeImpl(String pattern) {
        this.compile(pattern);
    }

    private void compile(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("\u7f16\u7ec4\u8303\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pattern.matches("\\w+")) {
            this.value = pattern;
        } else if (!"".equals(pattern)) {
            int scope = 0;
            int low = Integer.MAX_VALUE;
            char[] cs = pattern.toCharArray();
            for (int i = 0; i < cs.length; ++i) {
                char c = cs[i];
                if (low > scope) {
                    low = scope;
                }
                if (c == '(') {
                    ++scope;
                    continue;
                }
                if (c == ')') {
                    --scope;
                    continue;
                }
                if (scope == 0 && (c == ',' || c == ';')) {
                    this.value = "" + c;
                    this.leftNode = new PatternNodeImpl(pattern.substring(0, i));
                    this.rightNode = new PatternNodeImpl(pattern.substring(i + 1));
                    break;
                }
                if ((c + "").matches("\\w|\\,|\\;")) continue;
                throw new IllegalArgumentException("\u7f16\u7ec4\u8303\u5f0f\u4e2d\u9047\u5230\u65e0\u6548\u5b57\u7b26:" + c);
            }
            if (low > 0) {
                while (low-- > 0) {
                    pattern = pattern.substring(0, pattern.length() - 1);
                }
                this.compile(pattern);
            }
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public PatternNode getLeftNode() {
        return this.leftNode;
    }

    @Override
    public PatternNode getRightNode() {
        return this.rightNode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(NodeValue='").append(this.value).append("',LeftNode=").append(this.leftNode).append(",RightNode=").append(this.rightNode).append(")");
        return sb.toString();
    }
}

