/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ajax.threadscheduler;

import com.kingdee.bos.ctrl.analysis.web.ajax.threadscheduler.DefaultThreadGenerator;
import com.kingdee.bos.ctrl.analysis.web.ajax.threadscheduler.PatternNode;
import com.kingdee.bos.ctrl.analysis.web.ajax.threadscheduler.PatternNodeImpl;
import com.kingdee.bos.ctrl.analysis.web.ajax.threadscheduler.ThreadGenerator;
import com.kingdee.bos.ctrl.analysis.web.ajax.threadscheduler.ThreadScheduler;
import com.kingdee.bos.ctrl.analysis.web.ajax.threadscheduler.ThreadSchedulerConfig;

public class ThreadSchedulerImpl
implements ThreadScheduler {
    private ThreadSchedulerConfig config;
    private ThreadGenerator threadGenerator;
    private volatile int semaphore;
    private Object locker = new byte[0];

    public ThreadSchedulerImpl(ThreadSchedulerConfig config) {
        this(config, new DefaultThreadGenerator());
    }

    public ThreadSchedulerImpl(ThreadSchedulerConfig config, ThreadGenerator threadGenerator) {
        this.config = config;
        this.threadGenerator = threadGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PatternNodeImpl root = new PatternNodeImpl("," + this.config.getPattern());
        if (this.config.isAsynchronous()) {
            this.createThread(root);
        } else {
            this.semaphore = this.config.getSemaphore();
            Object object = this.locker;
            synchronized (object) {
                this.createThread(root);
                try {
                    while (this.semaphore > 0) {
                        this.locker.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private void createThread(final PatternNode node) {
        this.threadGenerator.generate(new Runnable(){

            @Override
            public void run() {
                ThreadSchedulerImpl.this.executeThread(node);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeThread(PatternNode node) {
        String value = node.getValue();
        if (value == null) {
            return;
        }
        if (value.matches("\\w+")) {
            this.config.done(value);
            if (!this.config.isAsynchronous()) {
                Object object = this.locker;
                synchronized (object) {
                    --this.semaphore;
                    this.locker.notifyAll();
                }
            }
        } else if (";".equals(value)) {
            this.createThread(node.getRightNode());
            this.executeThread(node.getLeftNode());
        } else if (",".equals(value)) {
            this.executeThread(node.getLeftNode());
            this.executeThread(node.getRightNode());
        }
    }
}

