/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.chart;

import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.util.Escape;
import com.kingdee.bos.ctrl.analysis.web.chart.ChartModel;
import com.kingdee.bos.ctrl.freechart.chart.urls.StandardCategoryURLGenerator;
import com.kingdee.bos.ctrl.freechart.data.category.CategoryDataset;
import com.kingdee.bos.ctrl.freechart.data.category.CategoryToCategoryDataset;
import com.kingdee.bos.ctrl.freechart.data.category.ReverseCategoryDataset;
import com.kingdee.bos.ctrl.freechart.data.category.SubCategoryDataset;
import java.util.Arrays;
import java.util.List;

public class MyCategoryURLGenerator
extends StandardCategoryURLGenerator {
    private static final long serialVersionUID = 5454036286308484353L;
    private ChartModel chartModel;
    private String compId;

    public MyCategoryURLGenerator(ChartModel chartModel, String compId) {
        this.chartModel = chartModel;
        this.compId = compId;
    }

    public String generateURL(CategoryDataset data, int series, int category) {
        String key_series;
        String key_category;
        if (data instanceof CategoryToCategoryDataset) {
            key_category = data.getColumnKey(category).toString();
            key_series = data.getRowKey(series).toString();
            if (!((data = ((CategoryToCategoryDataset)data).getUnderlyingDataset()) instanceof ReverseCategoryDataset)) {
                series = data.getRowIndex((Comparable)((Object)key_series));
                category = data.getColumnIndex((Comparable)((Object)key_category));
            }
        } else if (data instanceof SubCategoryDataset) {
            key_category = data.getColumnKey(category).toString();
            key_series = data.getRowKey(series).toString();
            data = ((SubCategoryDataset)data).getUnderlyingDataset();
            series = data.getRowIndex((Comparable)((Object)key_series));
            category = data.getColumnIndex((Comparable)((Object)key_category));
        }
        try {
            List<Member> slicerList = Arrays.asList(this.chartModel.getSlicerMembers());
            Member[] ms = this.chartModel.getMemberContext(series, category);
            StringBuffer sb = new StringBuffer();
            StringBuffer captions = new StringBuffer();
            boolean first = true;
            for (int i = 0; i < ms.length; ++i) {
                if (slicerList.contains(ms[i]) || ms[i].isMeasure()) continue;
                if (!first) {
                    sb.append("||");
                    captions.append("||");
                }
                first = false;
                sb.append(Escape.escape(ms[i].getUniqueName())).append(ms[i].isLeaf() ? "1" : "0").append(ms[i].getDepth() == 0 ? "1" : "0");
                captions.append(Escape.escape(ms[i].getCaption()));
            }
            String url = "uilayout.doDrillThrough('" + this.compId + "','" + sb.toString() + "','" + captions.toString() + "',event||window.event);";
            return url;
        }
        catch (Exception e) {
            return null;
        }
    }
}

