/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.chart;

import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSON;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONLike;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONMap;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;

public class RadarChartConfig
implements JSONLike,
Serializable {
    private static final long serialVersionUID = -5623500898866564847L;
    private boolean enable = false;
    private int radarTargetColumnIndex = 0;
    private int radarMinColumnIndex = 1;
    private boolean isDisplayName = true;
    private boolean isDisplayValue = true;
    private boolean isFillBackground = true;
    private List validIndexList;
    private String[] radarTargetSelfDefValues;
    private String[] radarMinSelfDefValues;

    public RadarChartConfig() {
    }

    public RadarChartConfig(String jsonString) throws BIReportException {
        Context ctx = Context.enter();
        try {
            Scriptable scope = ctx.initStandardObjects(null);
            Scriptable json = (Scriptable)ctx.evaluateString(scope, "(" + jsonString + ")", "JSON", 1, null);
            this.radarTargetColumnIndex = Integer.parseInt((String)json.get("target", scope));
            this.radarMinColumnIndex = Integer.parseInt((String)json.get("min", scope));
            this.isDisplayName = Boolean.valueOf((String)json.get("dispName", scope));
            this.isDisplayValue = Boolean.valueOf((String)json.get("dispValue", scope));
            this.isFillBackground = Boolean.valueOf((String)json.get("fillbg", scope));
            this.validIndexList = this.createListFromJSON(json.get("validList", scope), scope);
            List targetValues = this.createListFromJSON(json.get("targetValues", scope), scope);
            this.radarTargetSelfDefValues = targetValues != null ? targetValues.toArray(new String[0]) : null;
            List minValues = this.createListFromJSON(json.get("minValues", scope), scope);
            this.radarMinSelfDefValues = minValues != null ? minValues.toArray(new String[0]) : null;
        }
        catch (JavaScriptException e) {
            throw new BIReportException("\u53cd\u5e8f\u5217\u5316JSON\u6784\u9020\u96f7\u8fbe\u56fe\u5931\u8d25", e);
        }
        finally {
            Context.exit();
        }
    }

    private List createListFromJSON(Object json, Scriptable scope) {
        if (json != null && !Context.getUndefinedValue().equals(json) && !Scriptable.NOT_FOUND.equals(json)) {
            Scriptable s = (Scriptable)json;
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (s.has(i, scope)) {
                list.add(s.get(i, scope) + "");
                ++i;
            }
            return list.size() > 0 ? list : null;
        }
        return null;
    }

    public void reset() {
        this.enable = false;
        this.radarTargetColumnIndex = 0;
        this.radarMinColumnIndex = 1;
        this.validIndexList = null;
        this.radarTargetSelfDefValues = null;
        this.radarMinSelfDefValues = null;
    }

    @Override
    public JSON toJSON() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("target", this.radarTargetColumnIndex + "");
        map.put("min", this.radarMinColumnIndex + "");
        map.put("dispName", this.isDisplayName + "");
        map.put("dispValue", this.isDisplayValue + "");
        map.put("fillbg", this.isFillBackground + "");
        map.put("validList", this.validIndexList);
        if (this.radarTargetSelfDefValues == null) {
            map.put("targetValues", null);
        } else {
            map.put("targetValues", new ArrayList<String>(Arrays.asList(this.radarTargetSelfDefValues)));
        }
        if (this.radarMinSelfDefValues == null) {
            map.put("minValues", null);
        } else {
            map.put("minValues", new ArrayList<String>(Arrays.asList(this.radarMinSelfDefValues)));
        }
        return new JSONMap(map);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public int getRadarTargetColumnIndex() {
        return this.radarTargetColumnIndex;
    }

    public void setRadarTargetColumnIndex(int radarTargetColumnIndex) {
        this.radarTargetColumnIndex = radarTargetColumnIndex;
    }

    public int getRadarMinColumnIndex() {
        return this.radarMinColumnIndex;
    }

    public void setRadarMinColumnIndex(int radarMinColumnIndex) {
        this.radarMinColumnIndex = radarMinColumnIndex;
    }

    public boolean isDisplayName() {
        return this.isDisplayName;
    }

    public void setDisplayName(boolean isDisplayName) {
        this.isDisplayName = isDisplayName;
    }

    public boolean isDisplayValue() {
        return this.isDisplayValue;
    }

    public void setDisplayValue(boolean isDisplayValue) {
        this.isDisplayValue = isDisplayValue;
    }

    public boolean isFillBackground() {
        return this.isFillBackground;
    }

    public void setFillBackground(boolean isFillBackground) {
        this.isFillBackground = isFillBackground;
    }

    public List getValidIndexList() {
        return this.validIndexList;
    }

    public void setValidIndexList(List validIndexList) {
        this.validIndexList = validIndexList;
    }

    public String[] getRadarTargetSelfDefValues() {
        return this.radarTargetSelfDefValues;
    }

    public void setRadarTargetSelfDefValues(String[] radarTargetSelfDefValues) {
        this.radarTargetSelfDefValues = radarTargetSelfDefValues;
    }

    public String[] getRadarMinSelfDefValues() {
        return this.radarMinSelfDefValues;
    }

    public void setRadarMinSelfDefValues(String[] radarMinSelfDefValues) {
        this.radarMinSelfDefValues = radarMinSelfDefValues;
    }
}

