/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.dashboard.dial;

import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSON;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONMap;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DashBoardException;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DataSource;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.Dial;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class KPIChartDial
implements Dial {
    private final String id;
    private final DataSource ds;
    private final String title;
    private final boolean isShowTitle;
    private final String name;
    private HashMap mapParams = new HashMap();

    public KPIChartDial(String id, String title, boolean isShowTitle, DataSource ds, String name, HashMap map) {
        this.id = id;
        this.title = title;
        this.isShowTitle = isShowTitle;
        this.ds = ds;
        this.name = name;
        this.mapParams = map;
    }

    public HashMap getMapParams() {
        return this.mapParams;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getType() {
        return "kpi";
    }

    @Override
    public boolean isShowTitle() {
        return this.isShowTitle;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public JSON init(HttpServletRequest req) throws BIReportException {
        return this.toJSON(req);
    }

    public JSON refresh(HttpServletRequest req) throws BIReportException {
        return this.toJSON(req);
    }

    @Override
    public JSON toJSON(HttpServletRequest req) throws BIReportException {
        String[] filter = req.getParameterValues("filter");
        List<String> filterList = filter != null ? Arrays.asList(filter) : null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.getId());
        map.put("type", this.getType());
        map.put("isShowTitle", new Boolean(this.isShowTitle));
        map.put("title", this.title);
        map.put("name", this.name);
        if (this.ds == null) {
            throw new DashBoardException("\u627e\u4e0d\u5230KPI\u7ed1\u5b9a\u7684\u6570\u636e\u6e90\u3002\u53ef\u80fdKPI\u5c1a\u672a\u7ed1\u5b9a\u6570\u636e\u6e90\u6216\u8005\u8be5\u6570\u636e\u6e90\u5df2\u7ecf\u88ab\u5220\u9664");
        }
        if (req != null) {
            map.put("data", this.ds.getPreviewKPI(req, this.mapParams, filterList));
        }
        return new JSONMap(map);
    }

    @Override
    public String getScript() {
        return "";
    }

    @Override
    public void setScript(String script) {
    }
}

