/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.dashboard.dial;

import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSON;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONMap;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONString;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.Dial;
import com.kingdee.bos.ctrl.analysis.web.kpimonitor.IKPIMonitor;
import com.kingdee.bos.ctrl.analysis.web.kpimonitor.KPIMonitorFactory;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class KPIMonitorDial
implements Dial {
    private String id;
    private String name;
    private String title;
    private boolean showTitle;
    private String uiid;
    private String pageId;
    private String kpiMonitorId;
    private IKPIMonitor kpiMonitor = null;
    private Map baseInfo = null;

    public KPIMonitorDial(String id, Map baseInfo) {
        this.baseInfo = baseInfo;
        this.id = (String)baseInfo.get("id");
        this.name = (String)baseInfo.get("name");
        this.title = (String)baseInfo.get("title");
        this.showTitle = "true".equals(baseInfo.get("showTitle"));
        this.uiid = (String)baseInfo.get("uiid");
        this.pageId = (String)baseInfo.get("pageId");
        this.kpiMonitorId = (String)baseInfo.get("kpiMonitorId");
    }

    public JSON refresh(HttpServletRequest request) throws BIReportException {
        if (request.getParameterValues("filter") != null) {
            return this.changeDimensionMember(request);
        }
        return this.toJSON(request);
    }

    public JSON changeDimensionMember(HttpServletRequest request) throws BIReportException {
        this.kpiMonitor.service(request, "changeDimensionMember", null);
        return this.init(request);
    }

    public JSON getDimensionChildren(HttpServletRequest request) throws BIReportException {
        return new JSONString(this.kpiMonitor.service(request, "getDimensionChildren", null));
    }

    public JSON drillDown(HttpServletRequest request) throws BIReportException {
        return new JSONString(this.kpiMonitor.service(request, "drillDown", null));
    }

    public void createKPIMonitorInstance(HttpServletRequest request) throws BIReportException {
        if (this.kpiMonitor == null) {
            this.kpiMonitor = KPIMonitorFactory.newKPIMonitorInstance(request, this.kpiMonitorId, this.baseInfo);
        }
    }

    public JSON init(HttpServletRequest request) throws BIReportException {
        this.createKPIMonitorInstance(request);
        return this.toJSON(request);
    }

    @Override
    public JSON toJSON(HttpServletRequest request) throws BIReportException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.getId());
        map.put("type", this.getType());
        map.put("pageId", this.getPageId());
        map.put("urlSeparator", "\u0001");
        map.put("content", this.kpiMonitor.getContent(request));
        map.put("condition", this.wrapJson(this.kpiMonitor.getConditions(), this.uiid));
        map.put("isShowTitle", new Boolean(this.showTitle));
        map.put("title", this.title);
        map.put("name", this.name);
        return new JSONMap(map);
    }

    private String wrapJson(List lstConditions, String uiid) {
        StringBuffer sb = new StringBuffer();
        for (Map map : lstConditions) {
            sb.append("json{");
            sb.append("uiid:" + uiid + ",");
            sb.append("title:'" + map.get("title") + "',");
            sb.append("dimension:'" + map.get("dimension") + "',");
            sb.append("type:'" + map.get("type") + "',");
            sb.append("canChange:'" + map.get("canChange") + "',");
            sb.append("canDisplay:'" + map.get("canDisplay") + "',");
            sb.append("defaultValue:'" + map.get("defaultValue") + "',");
            sb.append("defaultCaption:'" + map.get("defaultCaption") + "'");
            sb.append("}json:end");
            sb.append(" ");
        }
        sb.append(" ");
        return sb.toString();
    }

    public void close(HttpServletRequest request) throws BIReportException {
        this.kpiMonitor.close(request);
    }

    public IKPIMonitor getKpiMonitor() {
        return this.kpiMonitor;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public String getPageId() {
        return this.pageId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getType() {
        return "kpiMonitor";
    }

    @Override
    public boolean isShowTitle() {
        return this.showTitle;
    }

    @Override
    public String getScript() {
        return "";
    }

    @Override
    public void setScript(String script) {
    }
}

