/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ext;

import com.kingdee.bos.ctrl.analysis.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.ajax.ReportPage;
import com.kingdee.bos.ctrl.analysis.web.ext.ExtReportPage;
import com.kingdee.bos.ctrl.analysis.web.ext.util.FilterSchemeTransferUtil;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryException;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilter;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.FilterScheme;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.ShareStrategy;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.rpts.tobi.ExtReportImpl;
import com.kingdee.eas.rpts.web.man.ReportImpl;
import com.kingdee.util.Uuid;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;

public class ExtFilterHandler {
    public static void delFilter(HttpServletRequest request, ExtReportPage extPage) throws BIReportException {
        String caption = request.getParameter("filterName");
        Connection conn = null;
        Statement pstat = null;
        ResultSet rs = null;
        boolean autoCommit = false;
        try {
            conn = BISystem.getJdbcConnection(request);
            try {
                ExtFilterHandler.findExtId(extPage, conn);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String extId = extPage.getExtID();
            if (extId == null) {
                extId = extPage.getReportID();
            }
            String sql = "select FUserID from T_EXT_FilterScheme where fname=? and fextid=?";
            conn.setAutoCommit(autoCommit);
            autoCommit = conn.getAutoCommit();
            pstat = conn.prepareStatement(sql);
            pstat.setString(1, caption);
            pstat.setString(2, extId);
            rs = pstat.executeQuery();
            String creator = null;
            if (null != rs && rs.next()) {
                creator = rs.getString(1);
            }
            if (creator != null && !creator.equals(BISystem.getCurrentUser(request))) {
                throw new RepositoryException("\u60a8\u4e0d\u662f\u8be5\u65b9\u6848\u7684\u521b\u5efa\u8005\u6216\u8005\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u5220\u9664\u8be5\u8fc7\u6ee4\u65b9\u6848");
            }
            rs.close();
            pstat.close();
            sql = "delete from t_ext_filterscheme where fextid=? and fname=?";
            pstat = conn.prepareStatement(sql);
            pstat.setString(1, extId);
            pstat.setString(2, caption);
            pstat.execute();
            conn.commit();
            conn.setAutoCommit(autoCommit);
        }
        catch (Exception e) {
            if (conn != null) {
                try {
                    conn.rollback();
                    conn.setAutoCommit(autoCommit);
                }
                catch (SQLException e1) {
                    throw new BIReportException(e.getMessage() + e1.getMessage());
                }
            }
            throw new BIReportException(e.getMessage());
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                    if (null != pstat) {
                        pstat.close();
                    }
                    if (null != conn) {
                        conn.close();
                    }
                }
                catch (SQLException e) {
                    throw new BIReportException(e.getMessage());
                }
            }
        }
    }

    public static FilterScheme[] getFilterSchemes(HttpServletRequest request, String shareStrategy, ExtReportPage extPage, BIReportFilter filter) throws BIReportException {
        Connection conn = null;
        FilterScheme[] schemes = null;
        Statement pstat = null;
        ResultSet rs = null;
        String orgID = BISystem.getCurrentOrgUnitID(request);
        String userID = BISystem.getCurrentUser(request);
        try {
            conn = BISystem.getJdbcConnection(request);
            try {
                ExtFilterHandler.findExtId(extPage, conn);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String extId = extPage.getExtID();
            if (extId == null) {
                extId = extPage.getReportID();
            }
            FilterSchemeTransferUtil.oldSchemeTableToNewSchemeTable(conn, extId);
            String sql = "select FNAME_l2,FIsDefault,FUserID,FOrgID,FWhereValue from T_CTR_CTRLQUERYSOLUTION where FReportFlag=? and FShareType=?";
            if ("0".equals(shareStrategy)) {
                sql = sql + " and FOrgID = ? and FUserID = ? and (FSolutionType = ? or FSolutionType = ?)";
                pstat = conn.prepareStatement(sql);
                pstat.setString(3, orgID);
                pstat.setString(4, userID);
                pstat.setInt(5, 1);
                pstat.setInt(6, 2);
            } else if ("1".equals(shareStrategy)) {
                sql = sql + "and FUserID = ?";
                pstat = conn.prepareStatement(sql);
                pstat.setString(3, userID);
            } else if ("2".equals(shareStrategy)) {
                sql = sql + "and FOrgID = ?";
                pstat = conn.prepareStatement(sql);
                pstat.setString(3, orgID);
            } else {
                throw new BIReportException("ShareStrategy Code Error");
            }
            pstat.setString(1, extId);
            pstat.setInt(2, Integer.parseInt(shareStrategy) + 1);
            rs = pstat.executeQuery();
            ArrayList<FilterScheme> list = new ArrayList<FilterScheme>();
            Calendar createTime = null;
            Calendar lastUpdateTime = null;
            if (null != rs) {
                while (rs.next()) {
                    String caption = rs.getString("FNAME_l2");
                    String creator = rs.getString("FUserID");
                    String orgId = rs.getString("FOrgID");
                    String content = rs.getString("FWhereValue");
                    createTime = Calendar.getInstance();
                    lastUpdateTime = Calendar.getInstance();
                    ShareStrategy ss = new ShareStrategy(creator, orgId, createTime, lastUpdateTime, shareStrategy);
                    FilterScheme scheme = FilterScheme.fromNewXML(caption, ss, content, filter, null);
                    if (rs.getInt("FIsDefault") == 1) {
                        scheme.setDefault(true);
                    }
                    list.add(scheme);
                }
            }
            schemes = new FilterScheme[list.size()];
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                schemes[i] = (FilterScheme)list.get(i);
            }
        }
        catch (Exception e) {
            throw new BIReportException(e.getMessage());
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                    if (null != pstat) {
                        pstat.close();
                        if (null != conn) {
                            conn.close();
                        }
                    }
                }
                catch (SQLException e) {
                    throw new BIReportException(e.getMessage());
                }
            }
        }
        return schemes;
    }

    private static void findExtId(ExtReportPage extPage, Connection conn) throws BIReportException {
        String extId = extPage.getExtID();
        if (extId == null) {
            throw new BIReportException("\u6269\u5c55\u62a5\u8868ID\u4e0d\u80fd\u70ba\u7a7a");
        }
        if (extId.indexOf("\u0001") != -1) {
            StringBuffer sql = new StringBuffer();
            String[] list = extId.split("\u0001");
            sql.append("select fid from T_BAS_DefineReport where forgid='").append("qUvvbL4yQsyQYFIDSlvngID2+FI=").append("' and fsystemid='").append(list[1]).append("' and (fname_l1='").append(list[0]).append("' or fname_l2='").append(list[0]).append("'or fname_l3='").append(list[0]).append("')");
            Statement stat = null;
            ResultSet rs = null;
            try {
                stat = conn.createStatement();
                rs = stat.executeQuery(sql.toString());
                if (rs.next()) {
                    extId = rs.getString(1);
                    extPage.setExtID(extId);
                }
            }
            catch (SQLException e) {
                throw new BIReportException(e.getMessage());
            }
            finally {
                if (null != rs) {
                    try {
                        rs.close();
                        if (null != stat) {
                            stat.close();
                        }
                    }
                    catch (SQLException e) {
                        throw new BIReportException(e.getMessage());
                    }
                }
            }
        }
    }

    public static String saveFilter(String currentUser, boolean isSuperUser, ReportPage page, HttpServletRequest request) throws BIReportException {
        String caption = request.getParameter("filterName");
        BIReportFilter filter = page.getReport().getFilter(request);
        String repPath = page.getReport().getRepositoryPath();
        int count = filter.getItemCount();
        Object[] valueParams = new Object[count];
        Object[] captionParams = new Object[count];
        for (int i = 0; i < count; ++i) {
            String[] strValue = request.getParameterValues("V" + (i + 1));
            if (strValue != null) {
                valueParams[i] = Arrays.asList(strValue);
            }
            if ((strValue = request.getParameterValues("C" + (i + 1))) == null) continue;
            captionParams[i] = Arrays.asList(strValue);
        }
        ShareStrategy ss = new ShareStrategy(request, null);
        FilterScheme fs = null;
        try {
            fs = FilterScheme.createFilterScheme(caption, valueParams, captionParams, ss, repPath);
        }
        catch (BIReportException e) {
            return e.getMessage();
        }
        String name = fs.getCaption();
        ExtReportPage extPage = (ExtReportPage)page;
        String sql = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        boolean autoCommit = false;
        try {
            conn = BISystem.getJdbcConnection(request);
            autoCommit = conn.getAutoCommit();
            try {
                ExtFilterHandler.findExtId(extPage, conn);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String extId = extPage.getExtID();
            if (extId == null) {
                extId = extPage.getReportID();
            }
            sql = "select FUserID from T_EXT_FilterScheme where fname=? and fextid=?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, name);
            pstmt.setString(2, extId);
            rs = pstmt.executeQuery();
            String creator = null;
            if (null != rs && rs.next()) {
                creator = rs.getString(0);
            }
            if (creator != null && !isSuperUser && !currentUser.equals(creator)) {
                throw new RepositoryException("\u6307\u5b9a\u540d\u79f0\u7684\u8fc7\u6ee4\u65b9\u6848\u5df2\u7ecf\u5b58\u5728\uff0c\u800c\u60a8\u4e0d\u662f\u5176\u521b\u5efa\u8005\uff0c\u56e0\u6b64\u4e0d\u80fd\u8986\u76d6\u8be5\u8fc7\u6ee4\u65b9\u6848\u3002\u60a8\u53ef\u4ee5\u9009\u62e9\u5c06\u5176\u4fdd\u5b58\u4e3a\u4e00\u4e2a\u65b0\u7684\u8fc7\u6ee4\u65b9\u6848");
            }
            rs.close();
            pstmt.close();
            sql = "insert into T_EXT_FilterScheme(fid,fname,fextid,fuserid,forgid,fcreatetime,fmodifieddate,fsharestrategy,fcontent,fisdefault) values(?,?,?,?,?,?,?,?,?,?)";
            PreparedStatement pstat = conn.prepareStatement(sql);
            conn.setAutoCommit(false);
            pstat.setString(1, Uuid.create().toString());
            pstat.setString(2, name);
            pstat.setString(3, extId);
            pstat.setString(4, fs.getShareStrategy().getCreatorID());
            pstat.setString(5, fs.getShareStrategy().getCreatorOrgUnitID());
            pstat.setDate(6, new Date(fs.getShareStrategy().getCreateTime().getTimeInMillis()));
            pstat.setDate(7, new Date(fs.getShareStrategy().getLastUpdateTime().getTimeInMillis()));
            pstat.setInt(8, Integer.parseInt(fs.getShareStrategy().getShareStrategy()));
            Document doc = fs.toDocument();
            StringWriter sw = new StringWriter();
            XmlUtil.print(doc, sw);
            pstat.setString(9, sw.toString());
            pstat.setInt(10, -1);
            pstat.execute();
            conn.commit();
            conn.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            try {
                conn.setAutoCommit(autoCommit);
            }
            catch (SQLException e1) {
                throw new BIReportException(e.getMessage() + e1.getMessage());
            }
            throw new BIReportException(e.getMessage());
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                    if (null != pstmt) {
                        pstmt.close();
                        if (null != conn) {
                            conn.close();
                        }
                    }
                }
                catch (SQLException e) {
                    throw new BIReportException(e.getMessage());
                }
            }
        }
        return caption;
    }

    private static String oldSchemeTableToNewSchemeTable(String doc, ArrayList<Map<String, String>> paramNameArray) {
        return null;
    }

    public static void saveScheme(String currentUser, boolean isSuperUser, ReportPage page, HttpServletRequest request, FilterScheme fs, boolean isDefaultScheme) throws BIReportException {
        String name = fs.getCaption();
        ExtReportPage extPage = (ExtReportPage)page;
        ExtReportImpl extReportImpl = (ExtReportImpl)extPage.getExtReport();
        ReportImpl reportImpl = extReportImpl.getReport();
        String orgID = BISystem.getCurrentOrgUnitID(request);
        List allUnionParam = reportImpl.getAllUnionParam();
        ShareStrategy shareStrategy = fs.getShareStrategy();
        String shareType = shareStrategy.getShareStrategy();
        String sql = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String fid = "";
        int solutionType = 0;
        int isDefaultNow = -1;
        boolean autoCommit = false;
        try {
            conn = BISystem.getJdbcConnection(request);
            autoCommit = conn.getAutoCommit();
            try {
                ExtFilterHandler.findExtId(extPage, conn);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String extId = extPage.getExtID();
            if (extId == null) {
                extId = extPage.getReportID();
            }
            sql = "select FUserID,fid,FSolutionType,FIsDefault from T_CTR_CTRLQUERYSOLUTION where FNAME_l2=? and FReportFlag=? and FShareType = ?";
            if ("0".equals(shareType)) {
                sql = sql + " and FOrgID = ? and FUserID = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(4, orgID);
                pstmt.setString(5, currentUser);
            } else if ("1".equals(shareType)) {
                sql = sql + " and FUserID = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(4, currentUser);
            } else if ("2".equals(shareType)) {
                sql = sql + " and FOrgID = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(4, orgID);
            }
            pstmt.setString(1, name);
            pstmt.setString(2, extId);
            pstmt.setInt(3, Integer.parseInt(shareType) + 1);
            rs = pstmt.executeQuery();
            String creator = null;
            if (null != rs && rs.next()) {
                creator = rs.getString(1);
                fid = rs.getString(2);
                solutionType = rs.getInt(3);
                isDefaultNow = rs.getInt(4);
            }
            rs.close();
            pstmt.close();
            if (creator != null && !isSuperUser && !currentUser.equals(creator)) {
                throw new RepositoryException("\u6307\u5b9a\u540d\u79f0\u7684\u8fc7\u6ee4\u65b9\u6848\u5df2\u7ecf\u5b58\u5728\uff0c\u800c\u60a8\u4e0d\u662f\u5176\u521b\u5efa\u8005\uff0c\u56e0\u6b64\u4e0d\u80fd\u8986\u76d6\u8be5\u8fc7\u6ee4\u65b9\u6848\u3002\u60a8\u53ef\u4ee5\u9009\u62e9\u5c06\u5176\u4fdd\u5b58\u4e3a\u4e00\u4e2a\u65b0\u7684\u8fc7\u6ee4\u65b9\u6848");
            }
            if (solutionType == 2) {
                throw new RepositoryException("\u4e0d\u80fd\u4fdd\u5b58\u9ed8\u8ba4\u8fc7\u6ee4\u65b9\u6848");
            }
            if (creator != null && !isSuperUser && currentUser.equals(creator)) {
                sql = "update T_CTR_CTRLQUERYSOLUTION set FWhereValue=? where fid=?";
                PreparedStatement pstat = null;
                conn.setAutoCommit(false);
                if ("0".equals(shareType)) {
                    sql = sql + " and FOrgID = ? and FUserID = ?";
                    pstat = conn.prepareStatement(sql);
                    pstat.setString(3, orgID);
                    pstat.setString(4, currentUser);
                } else if ("1".equals(shareType)) {
                    sql = sql + " and FUserID = ?";
                    pstat = conn.prepareStatement(sql);
                    pstat.setString(3, currentUser);
                } else if ("2".equals(shareType)) {
                    sql = sql + " and FOrgID = ?";
                    pstat = conn.prepareStatement(sql);
                    pstat.setString(3, orgID);
                }
                Document doc = fs.toDocument();
                ArrayList<Map<String, String>> paramNameArray = FilterSchemeTransferUtil.getParamNameFromAllUnionParam(fs, allUnionParam);
                StringWriter sw = new StringWriter();
                XmlUtil.print(doc, sw);
                if (null != pstat) {
                    String newXmlString = FilterSchemeTransferUtil.oldSchemeXMLToNewSchemeXML(sw.toString(), paramNameArray);
                    pstat.setString(1, newXmlString);
                    pstat.setString(2, fid);
                    pstat.execute();
                }
                conn.commit();
                conn.setAutoCommit(autoCommit);
            } else {
                sql = "insert into T_CTR_CTRLQUERYSOLUTION(fid,FNAME_l2,FUserID,FShareType,FSolutionType,FOrgID,FIsDefault,FWhereValue,FReportFlag) values(?,?,?,?,?,?,?,?,?)";
                PreparedStatement pstat = conn.prepareStatement(sql);
                conn.setAutoCommit(false);
                Document doc = fs.toDocument();
                ArrayList<Map<String, String>> paramNameArray = FilterSchemeTransferUtil.getParamNameFromAllUnionParam(fs, allUnionParam);
                StringWriter sw = new StringWriter();
                XmlUtil.print(doc, sw);
                String newXmlString = FilterSchemeTransferUtil.oldSchemeXMLToNewSchemeXML(sw.toString(), paramNameArray);
                pstat.setString(1, BOSUuid.create((String)"708CB5F0").toString());
                pstat.setString(2, name);
                pstat.setString(3, fs.getShareStrategy().getCreatorID());
                pstat.setInt(4, Integer.parseInt(fs.getShareStrategy().getShareStrategy()) + 1);
                if (isDefaultScheme) {
                    pstat.setInt(5, 2);
                } else {
                    pstat.setInt(5, 1);
                }
                pstat.setString(6, fs.getShareStrategy().getCreatorOrgUnitID());
                pstat.setInt(7, 0);
                pstat.setString(8, newXmlString);
                pstat.setString(9, extId);
                pstat.execute();
                HashMap<String, String> mapName = new HashMap<String, String>();
                mapName.put("l2", name);
                conn.commit();
                conn.setAutoCommit(autoCommit);
            }
        }
        catch (SQLException e) {
            try {
                conn.setAutoCommit(autoCommit);
            }
            catch (SQLException e1) {
                throw new BIReportException(e.getMessage() + e1.getMessage());
            }
            throw new BIReportException(e.getMessage());
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                    if (null != pstmt) {
                        pstmt.close();
                        if (null != conn) {
                            conn.close();
                        }
                    }
                }
                catch (SQLException e) {
                    throw new BIReportException(e.getMessage());
                }
            }
        }
    }

    public static void changeSchemeDefaultStatus(ReportPage page, HttpServletRequest request, String name) throws BIReportException {
        ExtReportPage extPage = (ExtReportPage)page;
        String sql = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String fid = "";
        String orgID = BISystem.getCurrentOrgUnitID(request);
        String userID = BISystem.getCurrentUser(request);
        boolean autoCommit = false;
        int isDefaultNow = 1;
        try {
            conn = BISystem.getJdbcConnection(request);
            autoCommit = conn.getAutoCommit();
            try {
                ExtFilterHandler.findExtId(extPage, conn);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String extId = extPage.getExtID();
            if (extId == null) {
                extId = extPage.getReportID();
            }
            sql = "select FIsDefault ,fid from T_CTR_CTRLQUERYSOLUTION where FNAME_l2=? and FReportFlag=? and FOrgID = ? and FUserID = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, name);
            pstmt.setString(2, extId);
            pstmt.setString(3, orgID);
            pstmt.setString(4, userID);
            rs = pstmt.executeQuery();
            if (null != rs && rs.next()) {
                isDefaultNow = rs.getInt(1);
                fid = rs.getString(2);
            }
            rs.close();
            if (null != fid && !fid.isEmpty()) {
                sql = "update T_CTR_CTRLQUERYSOLUTION set FIsDefault=? where FReportFlag=? and FOrgID = ? and FUserID = ?";
                conn.setAutoCommit(false);
                pstmt = conn.prepareStatement(sql);
                pstmt.setInt(1, 0);
                pstmt.setString(2, extId);
                pstmt.setString(3, orgID);
                pstmt.setString(4, userID);
                pstmt.execute();
                conn.commit();
                int isDefault = (isDefaultNow - 1) * (isDefaultNow - 1);
                if (isDefault != 0) {
                    sql = "update T_CTR_CTRLQUERYSOLUTION set FIsDefault=? where  fid=? and FOrgID = ? and FUserID = ?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setInt(1, isDefault);
                    pstmt.setString(2, fid);
                    pstmt.setString(3, orgID);
                    pstmt.setString(4, userID);
                    pstmt.execute();
                    conn.commit();
                }
                pstmt.close();
                conn.setAutoCommit(autoCommit);
            }
        }
        catch (SQLException e) {
            try {
                if (null != conn) {
                    conn.setAutoCommit(autoCommit);
                }
            }
            catch (SQLException e1) {
                throw new BIReportException(e.getMessage() + e1.getMessage());
            }
            throw new BIReportException(e.getMessage());
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                    if (null != pstmt) {
                        pstmt.close();
                        if (null != conn) {
                            conn.close();
                        }
                    }
                }
                catch (SQLException e) {
                    throw new BIReportException(e.getMessage());
                }
            }
        }
    }

    public static void delScheme(String caption, HttpServletRequest request, ExtReportPage extPage, String shareStrategy) throws BIReportException {
        Connection conn = null;
        Statement pstat = null;
        ResultSet rs = null;
        String orgID = BISystem.getCurrentOrgUnitID(request);
        String userID = BISystem.getCurrentUser(request);
        String fid = "";
        boolean autoCommit = false;
        try {
            conn = BISystem.getJdbcConnection(request);
            try {
                ExtFilterHandler.findExtId(extPage, conn);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String extId = extPage.getExtID();
            if (extId == null) {
                extId = extPage.getReportID();
            }
            String sql = "select FUserID,fid from T_CTR_CTRLQUERYSOLUTION where FNAME_l2=? and FReportFlag=? and FShareType = ?";
            autoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            if ("0".equals(shareStrategy)) {
                sql = sql + "and FOrgID = ? and FUserID = ?";
                pstat = conn.prepareStatement(sql);
                pstat.setString(4, orgID);
                pstat.setString(5, userID);
            } else if ("1".equals(shareStrategy)) {
                sql = sql + "and FUserID = ?";
                pstat = conn.prepareStatement(sql);
                pstat.setString(4, userID);
            } else if ("2".equals(shareStrategy)) {
                sql = sql + "and FOrgID = ?";
                pstat = conn.prepareStatement(sql);
                pstat.setString(4, orgID);
            } else {
                throw new BIReportException("ShareStrategy Code Error");
            }
            pstat.setString(1, caption);
            pstat.setString(2, extId);
            pstat.setInt(3, Integer.parseInt(shareStrategy) + 1);
            rs = pstat.executeQuery();
            String creator = null;
            if (null != rs && rs.next()) {
                creator = rs.getString(1);
                fid = rs.getString(2);
            }
            if (creator != null && !creator.equals(BISystem.getCurrentUser(request))) {
                throw new RepositoryException("\u60a8\u4e0d\u662f\u8be5\u65b9\u6848\u7684\u521b\u5efa\u8005\u6216\u8005\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u5220\u9664\u8be5\u8fc7\u6ee4\u65b9\u6848");
            }
            rs.close();
            pstat.close();
            sql = "delete from T_CTR_CTRLQUERYSOLUTION where FReportFlag=? and fid=?";
            if ("0".equals(shareStrategy)) {
                sql = sql + "and FOrgID = ? and FUserID = ?";
                pstat = conn.prepareStatement(sql);
                pstat.setString(3, orgID);
                pstat.setString(4, userID);
            } else if ("1".equals(shareStrategy)) {
                sql = sql + "and FUserID = ?";
                pstat = conn.prepareStatement(sql);
                pstat.setString(3, userID);
            } else if ("2".equals(shareStrategy)) {
                sql = sql + "and FOrgID = ?";
                pstat = conn.prepareStatement(sql);
                pstat.setString(3, orgID);
            } else {
                throw new BIReportException("ShareStrategy Code Error");
            }
            pstat.setString(1, extId);
            pstat.setString(2, fid);
            pstat.execute();
            conn.commit();
            conn.setAutoCommit(autoCommit);
        }
        catch (Exception e) {
            if (conn != null) {
                try {
                    conn.rollback();
                    conn.setAutoCommit(autoCommit);
                }
                catch (SQLException e1) {
                    throw new BIReportException(e.getMessage() + e1.getMessage());
                }
            }
            throw new BIReportException(e.getMessage());
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                    if (null != pstat) {
                        pstat.close();
                    }
                    if (null != conn) {
                        conn.close();
                    }
                }
                catch (SQLException e) {
                    throw new BIReportException(e.getMessage());
                }
            }
        }
    }
}

