/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ext.mp.lic;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.lic.ExtLicenseException;
import com.kingdee.bos.ctrl.analysis.web.ext.util.JDBCUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class EXTLicenseAgent {
    private String _module;
    private Context _ctx;
    private Logger _log = CommonLogger.getLogger(EXTLicenseAgent.class);

    public EXTLicenseAgent(String module, Context ctx) {
        this._module = module;
        this._ctx = ctx;
    }

    public void releaseLicense(String reportID) throws ExtLicenseException {
        try {
            if (!StringUtil.isEmptyString((String)reportID)) {
                this._module = this.retrieveModuleName(reportID);
            }
            try {
                if (StringUtil.isEmptyString((String)this._module)) {
                    return;
                }
                Class<?> licenseCls = Class.forName("com.kingdee.eas.rpts.base.license.ReportCenterLicenseSrvChecker");
                Object licenseObj = licenseCls.getConstructor(String.class, Context.class).newInstance(this._module, this._ctx);
                Method releaseLicenseMethod = licenseCls.getMethod("releaseLicense", null);
                releaseLicenseMethod.invoke(licenseObj, null);
            }
            catch (ClassNotFoundException e) {
                this._log.error((Object)"\u83b7\u53d6\u6269\u5c55\u62a5\u8868License\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            }
            catch (SecurityException e) {
                this._log.error((Object)"\u83b7\u53d6\u6269\u5c55\u62a5\u8868License\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            }
            catch (InstantiationException e) {
                this._log.error((Object)"\u83b7\u53d6\u6269\u5c55\u62a5\u8868License\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                this._log.error((Object)"\u83b7\u53d6\u6269\u5c55\u62a5\u8868License\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            }
        }
        catch (InvocationTargetException te) {
            throw new ExtLicenseException(te);
        }
        catch (IllegalAccessException ae) {
            throw new ExtLicenseException("\u91ca\u653eLicense\u5931\u8d25", ae);
        }
        catch (IllegalArgumentException iae) {
            throw new ExtLicenseException("\u91ca\u653eLicense\u5931\u8d25", iae);
        }
    }

    private String retrieveModuleName(String reportID) throws ExtLicenseException {
        String string;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = BISystem.getJdbcConnection(this._ctx);
            StringBuffer sqlBuf = new StringBuffer("SELECT FMENUUI AS ModuleName,FLicenseStrategy as strategy FROM T_BAS_DEFINEREPORT WHERE FID = ?");
            stmt = conn.prepareStatement(sqlBuf.toString());
            stmt.setString(1, reportID);
            rs = stmt.executeQuery();
            String moduleName = null;
            int licenseStrategy = -1;
            while (rs.next()) {
                moduleName = rs.getString("ModuleName");
                licenseStrategy = rs.getInt("strategy");
            }
            if (licenseStrategy == 2) {
                moduleName = "com.kingdee.eas.rpts.ctrlreport.client.ReportRunTimeUI";
            }
            string = moduleName;
        }
        catch (SQLException e) {
            try {
                throw new ExtLicenseException("\u83b7\u53d6\u62a5\u8868\u7684License\u6a21\u5757\u540d\u79f0\u5931\u8d25", e);
            }
            catch (Throwable throwable) {
                JDBCUtil.close(rs, stmt, conn);
                throw throwable;
            }
        }
        JDBCUtil.close(rs, stmt, conn);
        return string;
    }
}

