/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ext.mp.service;

import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONList;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.dao.ExtReportDAO;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.dao.ReportOfMyFolderDAO;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.vo.ExtReportVO;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.vo.ReportOfMyFolderVO;
import com.kingdee.bos.ctrl.analysis.web.ext.util.JDBCUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ExtReportService {
    private Logger logger = CommonLogger.getLogger(ExtReportService.class);
    private static ExtReportDAO extReportDAO = new ExtReportDAO();
    private static ReportOfMyFolderDAO reportOfMyFolderDAO = new ReportOfMyFolderDAO();

    public String queryReportsByOrgAndCreator(HttpServletRequest request) throws BIReportException {
        String string;
        block5: {
            Connection conn = null;
            try {
                String systemId = request.getParameter("SystemId");
                systemId = systemId.substring(6).trim();
                String local = BISystem.getContext(request).getLocale().toString();
                ExtReportVO qvo = new ExtReportVO();
                qvo.setCreator(BISystem.getCurrentUser(request));
                qvo.setCreatorOrg(BISystem.getCurrentOrgUnitID(request));
                conn = BISystem.getJdbcConnection(request);
                ArrayList lst = extReportDAO.queryByOrgAUser(conn, qvo, systemId, local);
                String json = new JSONList(lst).toString();
                string = json = "{root:" + json + "}";
                if (null == conn) break block5;
            }
            catch (SQLException e) {
                try {
                    this.logger.warn((Object)"\u83b7\u5f97\u62a5\u8868\u5217\u8868\u5931\u8d25", (Throwable)e);
                    throw new BIReportException(e);
                }
                catch (Throwable throwable) {
                    if (null != conn) {
                        JDBCUtil.close(conn);
                    }
                    throw throwable;
                }
            }
            JDBCUtil.close(conn);
        }
        return string;
    }

    public String queryReportsNamesFromSSM(HttpServletRequest request) throws BIReportException {
        String string;
        block6: {
            Connection conn = null;
            try {
                String systemId = request.getParameter("SystemId");
                systemId = systemId.substring(6).trim();
                ExtReportVO qvo = new ExtReportVO();
                qvo.setReportName(request.getParameter("query"));
                qvo.setPortalPath(systemId);
                qvo.setCreator(BISystem.getCurrentUser(request));
                qvo.setCreatorOrg(BISystem.getCurrentOrgUnitID(request));
                conn = BISystem.getJdbcConnection(request);
                ArrayList lst = extReportDAO.queryReportName(conn, qvo);
                StringBuffer nameBuf = new StringBuffer();
                nameBuf.append('[');
                int size = lst.size();
                for (int i = 0; i < size; ++i) {
                    nameBuf.append("{reportName:'");
                    nameBuf.append((String)lst.get(i));
                    nameBuf.append("'},");
                }
                nameBuf.deleteCharAt(nameBuf.length() - 1);
                nameBuf.append(']');
                String json = nameBuf.toString();
                string = json = "{data:" + json + "}";
                if (null == conn) break block6;
            }
            catch (SQLException e) {
                try {
                    this.logger.warn((Object)"\u83b7\u5f97\u62a5\u8868\u5217\u8868\u5931\u8d25", (Throwable)e);
                    throw new BIReportException(e);
                }
                catch (Throwable throwable) {
                    if (null != conn) {
                        JDBCUtil.close(conn);
                    }
                    throw throwable;
                }
            }
            JDBCUtil.close(conn);
        }
        return string;
    }

    public String queryReportsNameFromMFD(HttpServletRequest request) throws BIReportException {
        String string;
        block6: {
            Connection conn = null;
            try {
                ReportOfMyFolderVO qvo = new ReportOfMyFolderVO();
                qvo.setCreatorId(BISystem.getCurrentUser(request));
                qvo.setOrgId(BISystem.getCurrentOrgUnitID(request));
                qvo.setFolderNodeId(request.getParameter("SystemId"));
                conn = BISystem.getJdbcConnection(request);
                String partName = request.getParameter("query");
                ArrayList lst = reportOfMyFolderDAO.queryMyFolderReportName(conn, qvo, partName);
                StringBuffer nameBuf = new StringBuffer();
                nameBuf.append('[');
                int size = lst.size();
                for (int i = 0; i < size; ++i) {
                    nameBuf.append("{reportName:'");
                    nameBuf.append((String)lst.get(i));
                    nameBuf.append("'},");
                }
                nameBuf.deleteCharAt(nameBuf.length() - 1);
                nameBuf.append(']');
                String json = nameBuf.toString();
                string = json = "{data:" + json + "}";
                if (null == conn) break block6;
            }
            catch (SQLException e) {
                try {
                    this.logger.warn((Object)"\u83b7\u5f97\u62a5\u8868\u5217\u8868\u5931\u8d25", (Throwable)e);
                    throw new BIReportException(e);
                }
                catch (Throwable throwable) {
                    if (null != conn) {
                        JDBCUtil.close(conn);
                    }
                    throw throwable;
                }
            }
            JDBCUtil.close(conn);
        }
        return string;
    }

    public String queryReportsByMyFolderID(HttpServletRequest request) throws BIReportException {
        String string;
        block5: {
            Connection conn = null;
            try {
                ReportOfMyFolderVO qvo = new ReportOfMyFolderVO();
                qvo.setCreatorId(BISystem.getCurrentUser(request));
                qvo.setOrgId(BISystem.getCurrentOrgUnitID(request));
                qvo.setFolderNodeId(request.getParameter("SystemId"));
                conn = BISystem.getJdbcConnection(request);
                String local = BISystem.getContext(request).getLocale().toString();
                ArrayList lst = reportOfMyFolderDAO.getMyFolderReportList(conn, qvo, local);
                String json = new JSONList(lst).toString();
                string = json = "{root:" + json + "}";
                if (null == conn) break block5;
            }
            catch (SQLException e) {
                try {
                    this.logger.warn((Object)"\u83b7\u5f97\u62a5\u8868\u5217\u8868\u5931\u8d25", (Throwable)e);
                    throw new BIReportException(e);
                }
                catch (Throwable throwable) {
                    if (null != conn) {
                        JDBCUtil.close(conn);
                    }
                    throw throwable;
                }
            }
            JDBCUtil.close(conn);
        }
        return string;
    }
}

