/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.link;

import com.kingdee.bos.ctrl.analysis.olap.Dimension;
import com.kingdee.bos.ctrl.analysis.olap.Level;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.web.ajax.BIReportPage;
import com.kingdee.bos.ctrl.analysis.web.link.DimensionLink;
import com.kingdee.bos.ctrl.analysis.web.link.Linkage;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReport;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReportScheme;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;

public class DimensionLinkManager {
    private HashMap mapDimLinks = new HashMap();
    private static final String ATTR_DIMENSIONLINK = "dimensionLink";
    private static final String SEP_DIMLINK = "||";
    private static final String SEP_DIM_LEVEL = "@";

    public DimensionLinkManager(BIReportPage page) {
        BIReport report = page.getBIReport();
        List schemeList = report.getSchemeList();
        for (BIReportScheme scheme : schemeList) {
            this.mapDimLinks.put(scheme.getName(), report.getLinks(scheme.getName()));
        }
    }

    public Map getDimLinks() {
        return this.mapDimLinks;
    }

    public void addDimensionLink(Document document, String scheme, OlapModel olapModel) {
        StringBuffer sb = new StringBuffer();
        Map mapDimLinks = this.getDimLinks();
        List lstLinks = (List)mapDimLinks.get(scheme);
        boolean isFirst = true;
        if (lstLinks != null) {
            for (Linkage link : lstLinks) {
                String dim = ((DimensionLink)link).getDimension();
                int nLevel = ((DimensionLink)link).getLevel();
                if (nLevel == -1) {
                    Dimension dimension = olapModel.lookupDimension(dim);
                    if (dim == null) continue;
                    String levelname = ((DimensionLink)link).getLevelname();
                    Level level = olapModel.lookupLevel("[" + dim + "].[" + levelname + "]");
                    if (level == null) continue;
                    nLevel = dimension.isParentChildren() ? 0 : level.getDepth() + 1;
                }
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(SEP_DIMLINK);
                }
                sb.append(dim);
                sb.append(SEP_DIM_LEVEL);
                sb.append(nLevel);
            }
        }
        document.getDocumentElement().setAttribute(ATTR_DIMENSIONLINK, sb.toString());
    }

    public DimensionLink findDimensionLink(String dimension, String schemename, Level level) {
        int nLevel = level.getDepth() + 1;
        String levelname = level.getName();
        if (level.getHierarchy().getDimension().isParentChildren()) {
            Level level1 = level.getHierarchy().getLevels()[0];
            levelname = level1.isAll() ? level1.getchildLevel().getName() : level1.getName();
        }
        List lstLinks = (List)this.mapDimLinks.get(schemename);
        for (DimensionLink dl : lstLinks) {
            if (!dl.getDimension().equalsIgnoreCase(dimension) || dl.getLevel() != 0 && dl.getLevel() != nLevel && !levelname.equalsIgnoreCase(dl.getLevelname())) continue;
            return dl;
        }
        return null;
    }
}

