/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.pagesetup;

import com.kingdee.bos.ctrl.analysis.web.pagesetup.PageSetup;
import com.kingdee.bos.ctrl.analysis.web.pagesetup.PageSetupBasic;
import com.kingdee.bos.ctrl.analysis.web.pagesetup.PageSetupException;
import com.kingdee.bos.ctrl.analysis.web.pagesetup.PageSetupUtil;
import java.awt.Dimension;
import javax.servlet.http.HttpServletRequest;

public class PageSetupFactory {
    public static PageSetup buildPageSetup(HttpServletRequest request) throws PageSetupException {
        String paperSize;
        String showSlicer;
        PageSetupBasic pageSetup = new PageSetupBasic();
        String caption = request.getParameter("caption");
        if (caption != null && !caption.equals("")) {
            pageSetup.setCaption(caption);
        }
        if ("true".equalsIgnoreCase(showSlicer = request.getParameter("showSlicer"))) {
            pageSetup.setShowSlicer(true);
        }
        if ((paperSize = request.getParameter("paperSize")) != null && !paperSize.equals("")) {
            PageSetupFactory.setPaperSize(paperSize, pageSetup, request);
            pageSetup.setPaperSize(paperSize);
        }
        PageSetupFactory.setPaperMagin(pageSetup, request);
        if (pageSetup.getPaperMaginLeft() + pageSetup.getPaperMaginRight() >= pageSetup.getPaperSizeWidth()) {
            throw new PageSetupException("\u7eb8\u5f20\u6a2a\u5411\u8fb9\u8ddd\u5927\u4e8e\u9875\u5bbd\uff0c\u8bf7\u8c03\u6574\u9875\u8fb9\u8ddd!");
        }
        if (pageSetup.getPaperMaginTop() + pageSetup.getPaperMaginBottom() >= pageSetup.getPaperSizeHeight()) {
            throw new PageSetupException("\u7eb8\u5f20\u7eb5\u5411\u8fb9\u8ddd\u5927\u4e8e\u9875\u9ad8\uff0c\u8bf7\u8c03\u6574\u9875\u8fb9\u8ddd!");
        }
        String paperOrientation = request.getParameter("IsLandScape");
        if ("true".equalsIgnoreCase(paperOrientation)) {
            pageSetup.setPaperOrientation(Boolean.valueOf(paperOrientation));
            pageSetup.setLandScape();
        }
        return pageSetup;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setPaperSize(String paperSize, PageSetupBasic pageSetup, HttpServletRequest request) throws PageSetupException {
        Dimension dimPaper = null;
        if (paperSize.equalsIgnoreCase("custom")) {
            String width = request.getParameter("paperWidth");
            String height = request.getParameter("paperHeight");
            if (width == null || height == null) throw new PageSetupException("\u7f3a\u5c11\u81ea\u5b9a\u4e49\u7eb8\u5f20\u7684\u5bbd\u9ad8\u5b9a\u4e49!");
            try {
                int nWidth = (int)Float.parseFloat(width);
                int nHeight = Integer.parseInt(height);
                if (nWidth <= 0 || nHeight <= 0) {
                    throw new PageSetupException("\u81ea\u5b9a\u4e49\u7eb8\u5f20\u7684\u957f\u5bbd\u5b9a\u4e49\u5fc5\u987b\u5927\u4e8e0!");
                }
                dimPaper = new Dimension(nWidth, nHeight);
            }
            catch (NumberFormatException e) {
                throw new PageSetupException("\u7eb8\u5f20\u7684\u957f\u5bbd\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5fc5\u987b\u4e3a\u6570\u503c!");
            }
        } else {
            dimPaper = PageSetupUtil.getPaperSize(paperSize);
            if (dimPaper == null) {
                throw new PageSetupException("unsupport paperSize name " + paperSize + "!");
            }
        }
        if (dimPaper == null) return;
        pageSetup.setPaperSizeWidth((int)dimPaper.getWidth());
        pageSetup.setPaperSizeHeight((int)dimPaper.getHeight());
    }

    private static int parseMagin(String strMagin, String maginType) throws PageSetupException {
        int ret = 0;
        try {
            ret = (int)Float.parseFloat(strMagin);
        }
        catch (NumberFormatException e) {
            throw new PageSetupException("\u7eb8\u5f20\u7684" + maginType + "\u8fb9\u8ddd\u5b9a\u4e49\u683c\u5f0f\u4e0d\u5bf9\uff0c\u5fc5\u987b\u4e3a\u6570\u503c!");
        }
        if (ret < 0) {
            throw new PageSetupException("\u7eb8\u5f20\u7684" + maginType + "\u8fb9\u8ddd\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u8d1f\u6570!");
        }
        return ret;
    }

    private static void setPaperMagin(PageSetupBasic pageSetup, HttpServletRequest request) throws PageSetupException {
        String paperMaginBottom;
        String paperMaginRight;
        String paperMaginTop;
        String paperMaginLeft = request.getParameter("paperMaginLeft");
        if (paperMaginLeft != null && !paperMaginLeft.equals("")) {
            pageSetup.setPaperMaginLeft(PageSetupFactory.parseMagin(paperMaginLeft, "\u5de6"));
        }
        if ((paperMaginTop = request.getParameter("paperMaginTop")) != null && !paperMaginTop.equals("")) {
            pageSetup.setPaperMaginTop(PageSetupFactory.parseMagin(paperMaginTop, "\u4e0a"));
        }
        if ((paperMaginRight = request.getParameter("paperMaginRight")) != null && !paperMaginRight.equals("")) {
            pageSetup.setPaperMaginRight(PageSetupFactory.parseMagin(paperMaginRight, "\u53f3"));
        }
        if ((paperMaginBottom = request.getParameter("paperMaginBottom")) != null && !paperMaginBottom.equals("")) {
            pageSetup.setPaperMaginBottom(PageSetupFactory.parseMagin(paperMaginBottom, "\u4e0b"));
        }
    }
}

