/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.print.handler;

import com.kingdee.bos.ctrl.analysis.web.export.ExportType;
import com.kingdee.bos.ctrl.analysis.web.print.util.PrintUtil;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PrintServletHandler {
    private static Pattern filePattern = Pattern.compile("[\\\\/:*?\"<>|]");

    public static void handle(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String exportType = request.getParameter("exportType");
        if (exportType == null) {
            throw new ServletException("Parameter 'filename' must be supplied");
        }
        String filename = request.getParameter("filename");
        if (filename == null) {
            throw new ServletException("Parameter 'filename' must be supplied");
        }
        Matcher matcher = filePattern.matcher(filename);
        if (matcher.find()) {
            matcher.replaceAll("");
        }
        File file = PrintUtil.getTempFile(filename);
        String mimeType = "";
        try {
            mimeType = ExportType.findMimeType(exportType);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        PrintServletHandler.sendTempFile(file, response, mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendTempFile(File file, HttpServletResponse response, String mimeType) throws IOException, FileNotFoundException {
        BufferedOutputStream bos;
        BufferedInputStream bis;
        block6: {
            block5: {
                if (!file.exists()) break block5;
                bis = null;
                bos = null;
                try {
                    bis = new BufferedInputStream(new FileInputStream(file));
                    if (mimeType != null) {
                        response.setHeader("Content-Disposition", "inline;filename=\"" + URLEncoder.encode(file.getName(), "UTF-8") + "\"");
                        response.setHeader("Content-Type", mimeType);
                    }
                    response.setHeader("Content-Length", String.valueOf(file.length()));
                    SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
                    response.setHeader("Last-Modified", sdf.format(new Date(file.lastModified())));
                    bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
                    byte[] input = new byte[1024];
                    boolean eof = false;
                    while (!eof) {
                        int length = bis.read(input);
                        if (length == -1) {
                            eof = true;
                            continue;
                        }
                        bos.write(input, 0, length);
                    }
                    bos.flush();
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{bis, bos});
                    throw throwable;
                }
                break block6;
            }
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        CloseUtil.close((Closeable[])new Closeable[]{bis, bos});
    }
}

