/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.session;

import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class UserSessionHelper {
    public static final String LAST_REPORT_SET = "lastReportSet";
    public static final String LAST_DASHBOARD_SET = "lastDashboardSet";
    public static final String LAST_USER = "lastUser";
    public static final String LAST_ORG = "lastOrg";

    public static HttpSession getUserSession(final HttpServletRequest request) {
        final HttpSession session = request.getSession(true);
        return (HttpSession)Proxy.newProxyInstance(HttpSession.class.getClassLoader(), new Class[]{HttpSession.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String key;
                String name = method.getName();
                if ("getAttribute".equals(name) && (UserSessionHelper.LAST_REPORT_SET.equals(key = (String)args[0]) || UserSessionHelper.LAST_DASHBOARD_SET.equals(key))) {
                    String currentUser = BISystem.getCurrentUser(request) + "";
                    String currentOrg = BISystem.getCurrentOrgUnitID(request) + "";
                    Object lastUser = session.getAttribute(UserSessionHelper.LAST_USER);
                    Object lastOrg = session.getAttribute(UserSessionHelper.LAST_ORG);
                    Object set = session.getAttribute(key);
                    if (!currentUser.equals(lastUser) || !currentOrg.equals(lastOrg) || set == null) {
                        session.setAttribute(key, new TreeSet());
                    }
                    session.setAttribute(UserSessionHelper.LAST_USER, (Object)currentUser);
                    session.setAttribute(UserSessionHelper.LAST_ORG, (Object)currentOrg);
                }
                return method.invoke((Object)session, args);
            }
        });
    }
}

