/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.config;

import com.kingdee.bos.ctrl.analysis.web.solution.BIReport;
import com.kingdee.bos.ctrl.analysis.web.solution.BISubject;
import com.kingdee.bos.ctrl.analysis.web.solution.def.BIReportDef;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.util.BISolutionCaptionUtil;
import java.io.File;

public class BIReportConfig {
    private String reportBasePath = "";
    private String subjectPath = "";

    public BIReportConfig(String subjectPath) throws BIReportException {
        this.subjectPath = subjectPath;
        this.reportBasePath = subjectPath + File.separator + "report";
    }

    public BIReport lookupReport(String path, BISubject subject) throws BIReportException {
        String fullPath = this.reportBasePath;
        fullPath = path.startsWith("/") || path.startsWith("\\") ? fullPath + File.separator + path.substring(1) : fullPath + File.separator + path;
        return this.createReport(fullPath, subject);
    }

    private BIReport createReport(String fullPath, BISubject subject) throws BIReportException {
        BIReport report = null;
        File f = new File(fullPath);
        if (!f.exists() || !f.getName().endsWith("olaprpt")) {
            throw new BIReportException("\u6307\u5b9a\u62a5\u8868" + fullPath + "\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u914d\u7f6e\u4e3b\u9898!");
        }
        String filename = f.getName();
        String pathname = f.getAbsolutePath();
        String rptPath = pathname.substring(this.reportBasePath.length());
        rptPath = rptPath.replace('\\', '/');
        String metaFilename = f.getParent() + File.separator + ".meta";
        String caption = "";
        caption = BISolutionCaptionUtil.getCaption(metaFilename, filename, filename);
        BIReportDef def = new BIReportDef(this.subjectPath, filename, caption, rptPath, subject);
        report = def.createReport();
        return report;
    }
}

