/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.tree;

import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryException;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.BITreeNode;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

class DashboardTreeNode
extends DefaultKingdeeTreeNode
implements Comparable,
BITreeNode {
    private static final long serialVersionUID = 7562318597291298915L;
    private static final Logger logger = CommonLogger.getLogger(DashboardTreeNode.class);
    private String path;
    private String name;
    private Repository rep;
    private String ws;
    private List tmpChildNodeList = null;

    public static DashboardTreeNode fromID(String ID, Repository rep) throws BIReportException {
        DashboardTreeNode node = new DashboardTreeNode(rep, ID);
        return node;
    }

    @Override
    public String getID() {
        return this.path;
    }

    public DashboardTreeNode(Repository rep, String path) {
        super(null, null);
        try {
            this.path = path;
            this.rep = rep;
            this.ws = "DBD";
            this.name = rep.getNodeNameByPath(this.ws, path);
            this.setUserObject(this.name);
        }
        catch (RepositoryException e) {
            logger.error((Object)e);
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getFullPath() {
        if (!this.isLeaf()) {
            return "";
        }
        try {
            return this.rep.getNodePropertyByPath(this.ws, this.path, "reportPath");
        }
        catch (RepositoryException e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public String getPropertyValue(String propertyName) {
        try {
            return this.rep.getNodePropertyByPath2(this.ws, this.path, propertyName);
        }
        catch (RepositoryException e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public int getChildCount() {
        try {
            return this.rep.getNodeChildCount(this.ws, this.path);
        }
        catch (RepositoryException e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public TreeNode getChildAt(int index) {
        int childCount = this.getChildCount();
        if (index < 0 || index >= childCount) {
            return null;
        }
        if (this.tmpChildNodeList != null) {
            return (TreeNode)this.tmpChildNodeList.get(index);
        }
        try {
            List res_child = this.rep.getNodeChildrenPaths(this.ws, this.path);
            Iterator it = res_child.iterator();
            this.tmpChildNodeList = new ArrayList();
            while (it.hasNext()) {
                this.tmpChildNodeList.add(new DashboardTreeNode(this.rep, (String)it.next()));
            }
        }
        catch (RepositoryException e) {
            logger.error((Object)e);
        }
        Collections.sort(this.tmpChildNodeList);
        return (TreeNode)this.tmpChildNodeList.get(index);
    }

    public int compareTo(Object o) {
        if (!(o instanceof DashboardTreeNode)) {
            return 1;
        }
        DashboardTreeNode objTo = (DashboardTreeNode)o;
        if (this.isLeaf()) {
            if (objTo.isLeaf()) {
                return this.getName().compareTo(objTo.getName());
            }
            return 1;
        }
        if (objTo.isLeaf()) {
            return -1;
        }
        return this.getName().compareTo(objTo.getName());
    }

    @Override
    public boolean isLeaf() {
        return this.rep.nodeIsFile(this.ws, this.path);
    }

    @Override
    public Calendar getLastModified() {
        try {
            return this.rep.getNodeLastModified(this.ws, this.path);
        }
        catch (RepositoryException e) {
            logger.error((Object)e);
            return null;
        }
    }
}

