/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.tree;

import com.kingdee.bos.ctrl.analysis.web.easkpi.KPIUtil;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.KPITreeNode;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.ThemeReportTreeModel;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class KPITreeModel
implements TreeModel,
Serializable {
    private static final long serialVersionUID = -1548973151509462922L;
    private static Logger logger = CommonLogger.getLogger(ThemeReportTreeModel.class);
    private String ou;
    private String cu;
    KPITreeNode root;
    List lstBSCData = null;
    protected EventListenerList listenerList = new EventListenerList();

    public KPITreeModel(Repository rep, HttpServletRequest req) throws BIReportException {
        if (BISystem.isEAS()) {
            this.ou = BISystem.getCurrentOrgUnitID(req);
            this.cu = BISystem.getCurrentCU(req);
        }
        this.root = new KPITreeNode(null);
        this.root.setCaption("BSC(BSC)");
        this.root.setFolder();
        KPIUtil.judgeCanUseKPI(rep);
        this.lstBSCData = KPIUtil.calculateAllKPI(rep, this.ou, this.cu);
        KPIUtil.createKPITree(this.root, this.lstBSCData);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((KPITreeNode)parent).getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((KPITreeNode)parent).getChildCount();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int n = this.getChildCount(parent);
        for (int i = 0; i < n; ++i) {
            if (!this.getChild(parent, i).equals(child)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((KPITreeNode)node).isLeaf();
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }
}

