/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.tree;

import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryException;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.BITreeNode;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

class RepositoryTreeNode
extends DefaultKingdeeTreeNode
implements Comparable,
BITreeNode {
    private static final long serialVersionUID = 1176417583247961268L;
    private static Logger logger = CommonLogger.getLogger((String)RepositoryTreeNode.class.getName());
    private Repository rep;
    private String ws;
    private String path;
    private String name;
    private List tmpChildNodeList = null;
    private int tmpCount = -1;
    private String rootPath;
    private static final String IDSeperator = "\u0001";

    public static RepositoryTreeNode fromID(String ID, Repository rep) throws BIReportException {
        String wsName = "";
        String path = "";
        String rootPath = "";
        String[] str = ID.split(IDSeperator);
        if (str != null && str.length > 1) {
            wsName = str[0];
            rootPath = str[1];
            path = str[2];
        }
        RepositoryTreeNode node = new RepositoryTreeNode(rep, path, wsName, rootPath);
        return node;
    }

    public String getRelativePath() {
        return this.path.substring(this.rootPath.length() + 1);
    }

    @Override
    public String getFullPath() {
        return this.path;
    }

    @Override
    public String getID() {
        String ID = null;
        ID = this.ws + IDSeperator + this.rootPath + IDSeperator + this.path;
        return ID;
    }

    public RepositoryTreeNode(Repository rep, String path, String wsName, String rootPath) {
        super(null, null);
        this.rep = rep;
        this.path = path;
        this.ws = wsName;
        try {
            this.name = rep.getNodeNameByPath(this.ws, path);
            this.setUserObject(this.getName());
        }
        catch (RepositoryException e) {
            logger.error((Object)e);
        }
        this.rootPath = rootPath;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getChildCount() {
        if (this.tmpCount != -1) {
            return this.tmpCount;
        }
        try {
            return this.rep.getNodeChildCount(this.ws, this.path);
        }
        catch (RepositoryException e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public TreeNode getChildAt(int index) {
        int childCount = this.getChildCount();
        if (index < 0 || index >= childCount) {
            return null;
        }
        if (this.tmpChildNodeList != null) {
            return (TreeNode)this.tmpChildNodeList.get(index);
        }
        try {
            List res_child = this.rep.getNodeChildrenPaths(this.ws, this.path);
            Iterator it = res_child.iterator();
            this.tmpChildNodeList = new ArrayList();
            while (it.hasNext()) {
                this.tmpChildNodeList.add(new RepositoryTreeNode(this.rep, (String)it.next(), this.ws, this.rootPath));
            }
            this.tmpCount = childCount;
        }
        catch (RepositoryException e) {
            logger.error((Object)"\u83b7\u53d6\u6240\u6709\u5b50\u7ed3\u70b9\u5931\u8d25!", (Throwable)e);
        }
        Collections.sort(this.tmpChildNodeList);
        return (TreeNode)this.tmpChildNodeList.get(index);
    }

    public int compareTo(Object o) {
        if (!(o instanceof RepositoryTreeNode)) {
            return 1;
        }
        RepositoryTreeNode objTo = (RepositoryTreeNode)o;
        if (this.isLeaf()) {
            if (objTo.isLeaf()) {
                return this.getName().compareTo(objTo.getName());
            }
            return 1;
        }
        if (objTo.isLeaf()) {
            return -1;
        }
        return this.getName().compareTo(objTo.getName());
    }

    @Override
    public boolean isLeaf() {
        String isReport = null;
        try {
            isReport = this.rep.getThemeReportFlag(this.ws, this.path);
        }
        catch (RepositoryException e) {
            logger.error((Object)e);
        }
        if (isReport != null) {
            return "true".equalsIgnoreCase(isReport);
        }
        return this.rep.nodeIsFile(this.ws, this.path);
    }

    @Override
    public String getPropertyValue(String propertyName) {
        try {
            return this.rep.getNodePropertyByPath2(this.ws, this.path, propertyName);
        }
        catch (RepositoryException e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public Calendar getLastModified() {
        try {
            return this.rep.getNodeLastModified(this.ws, this.path);
        }
        catch (RepositoryException e) {
            logger.error((Object)e);
            return null;
        }
    }
}

