/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.worklist;

import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Member;
import com.kingdee.bos.ctrl.analysis.web.ajax.BIReportPage;
import com.kingdee.bos.ctrl.analysis.web.ajax.Constants;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONMap;
import com.kingdee.bos.ctrl.analysis.web.export.ExportUtil;
import com.kingdee.bos.ctrl.analysis.web.link.DimensionLink;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReportVarProvider;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.worklist.Filter;
import com.kingdee.bos.ctrl.analysis.web.worklist.WorklistMeta;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.Span;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.UnitConverter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.olap.Member;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class WorklistComponent {
    private static Logger logger = CommonLogger.getLogger(WorklistComponent.class);
    private String id;
    private WorklistMeta wm;
    private String currentSql;
    private static final String ORDER_BY_ASC = "1";
    private static final String PARAM_SORT_COLUMN = "column";
    private static final String PARAM_SORT_BY_ASC = "asc";
    private static final String PARAM_PAGE_TO = "page";
    private static final String PARAM_EXPORT_TYPE = "exportType";
    private static final String PARAM_PERPAGE_ROWS = "perPageRows";
    private static final String KEY_LIST_TITLE = "title";
    private static final String KEY_LIST_HEAD = "pageHead";
    private static final String KEY_LIST_HEADTAG = "head";
    private static final String KEY_LIST_DATATAG = "data";
    private static final String KEY_LIST_TAIL = "pageTail";
    private static final String KEY_SORT_COLUMN = "sortColumn";
    private static final String KEY_SORT_ASC = "sortASC";
    private static final String KEY_CURRENT_PAGE = "currentPage";
    private static final String KEY_TOTAL_PAGE = "totalPage";
    private static final String KEY_LIST_UUID = "listUUID";
    private static final String KEY_LIST_WIDTH = "width";
    private static final String KEY_LIST_PAGEPERROWS = "perPageRows";
    private static final String VIEW_TEMP_NAME = "t_stone_temp";
    private static final String VIEW_TEMP_NAME2 = "t_stone_temp2";
    private static final String VIEW_TEMP_NAME_FILTER = "t_stone_temp_filter";
    private static final int NO_PAGINATION = 0;

    public WorklistComponent(String id, WorklistMeta wm) {
        this.id = id;
        this.wm = wm;
    }

    public void close(HttpServletRequest request) {
    }

    public String render(HttpServletRequest request, Span span, DimensionLink dl, BIReportPage page) throws BIReportException {
        String param = this.getMemberProperty(((KDOLAP_Member)span.getMember()).getKDMember(), dl.getParamColumn()).toString();
        this.wm.setParam(param);
        int currentPage = 1;
        return this.makeListData(currentPage, request, page);
    }

    public String render(HttpServletRequest request, BIReportPage page) throws BIReportException {
        int currentPage = 1;
        Map map = this.makeListMap(currentPage, request, page);
        JSONMap jsRet = new JSONMap(map);
        return jsRet.toString();
    }

    public String sort(HttpServletRequest request, BIReportPage page) throws BIReportException {
        String sortColumn = request.getParameter(PARAM_SORT_COLUMN);
        String asc = request.getParameter(PARAM_SORT_BY_ASC);
        this.wm.setSortColumn(sortColumn);
        this.wm.setSortOrder(ORDER_BY_ASC.equalsIgnoreCase(asc));
        int currentPage = 1;
        return this.makeListData(currentPage, request, page);
    }

    public String sort2(HttpServletRequest request, BIReportPage page) throws BIReportException {
        String sortColumnsInfo = request.getParameter("sortColumnInfos");
        ArrayList sortColumns = new ArrayList();
        ArrayList sortOrders = new ArrayList();
        this.parseSortingInfo(sortColumnsInfo, sortColumns, sortOrders);
        this.wm.setSortColumns(sortColumns);
        this.wm.setSortOrders(sortOrders);
        int currentPage = 1;
        return this.makeListData(currentPage, request, page);
    }

    public String filterList(HttpServletRequest request, BIReportPage page) throws BIReportException {
        String column = request.getParameter(PARAM_SORT_COLUMN);
        String filterMethod = request.getParameter("filterMethod");
        String filterType = request.getParameter("filterType");
        String filterValue = request.getParameter("filterValue");
        this.wm.addFilter(column, filterMethod, "true".equalsIgnoreCase(filterType), filterValue);
        int currentPage = 1;
        return this.makeListData(currentPage, request, page);
    }

    public String createColumnSql(String sql, boolean distinct, String column, List sortColumns, List sortAscs) {
        int index;
        String columnSql = sql.toLowerCase();
        columnSql = columnSql.indexOf("order by") != -1 ? sql.substring(0, columnSql.indexOf("order by")) : sql;
        columnSql = distinct ? "select top 1000 * from ( select distinct(" + column + ") from (" + columnSql + ") " + VIEW_TEMP_NAME + ") " + VIEW_TEMP_NAME2 : "select top 1000 " + column + " from (" + columnSql + ") " + VIEW_TEMP_NAME;
        if (sortColumns != null && sortAscs != null && (index = sortColumns.indexOf(column)) != -1) {
            columnSql = columnSql + " order by " + column + " " + ((Boolean)sortAscs.get(index) != false ? PARAM_SORT_BY_ASC : "desc");
        }
        return columnSql;
    }

    public String getColumnValues(HttpServletRequest request, BIReportPage page, boolean distinct) throws BIReportException {
        String column = request.getParameter(PARAM_SORT_COLUMN);
        Object param = this.wm.getParam();
        String ds = this.wm.getDs();
        List sortColumns = this.wm.getSortColumns();
        List sortAscs = this.wm.getSortOrders();
        BIReportVarProvider varProvider = new BIReportVarProvider(BISystem.getContext(request), !BISystem.isEAS(), page.getSubject().getRuntimeVarFilename(), page.getSubject().getRuntimeVarClassname(), page.getBIReport().getDatacenter());
        String sql = null;
        sql = !this.wm.isDataDrill() ? page.getDataSourceManager().getDataProvider().getSql(ds) : this.wm.getDataDrillSql();
        sql = page.transStringByVarAndMacro(sql, varProvider);
        StringBuffer sbCurrent = new StringBuffer();
        String columnSql = this.createColumnSql(this.currentSql, distinct, column, sortColumns, sortAscs);
        this.getSqlResult(request, page, columnSql, sbCurrent, param);
        String allSql = this.createColumnSql(sql, distinct, column, sortColumns, sortAscs);
        StringBuffer sb = new StringBuffer();
        this.getSqlResult(request, page, allSql, sb, param);
        sb.append("\u0003");
        sb.append(sbCurrent.toString());
        return sb.toString();
    }

    private void getSqlResult(HttpServletRequest request, BIReportPage page, String sql, StringBuffer sb, Object param) throws BIReportException {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = BISystem.getJdbcConnection(BISystem.getContext(request), page.getBIReport().getDatacenter());
            ps = con.prepareStatement(sql);
            if (!this.wm.isDataDrill()) {
                ps.setObject(1, param);
            }
            rs = ps.executeQuery();
            boolean first = true;
            while (rs.next()) {
                if (first) {
                    first = false;
                } else {
                    sb.append("\u0001");
                }
                sb.append(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                throw new BIReportException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
    }

    private void parseSortingInfo(String sortColumnsInfo, List sortColumns, List sortOrders) {
        String[] str = sortColumnsInfo.split("\u0002");
        for (int i = 0; i < str.length; ++i) {
            String[] str2 = str[i].split("\u0001");
            if (str2.length < 2 || "0".equalsIgnoreCase(str2[1])) continue;
            sortColumns.add(str2[0]);
            sortOrders.add(new Boolean(str2[1].equalsIgnoreCase(ORDER_BY_ASC)));
        }
    }

    public String changePage(HttpServletRequest request, BIReportPage page) throws BIReportException {
        String sPage = request.getParameter(PARAM_PAGE_TO);
        int nPage = 1;
        try {
            nPage = Integer.parseInt(sPage);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.makeListData(nPage, request, page);
    }

    public String changePerPageRows(HttpServletRequest request, BIReportPage page) throws BIReportException {
        String pagePerRows = request.getParameter("perPageRows");
        int nPagePerRows = 15;
        int nPage = 1;
        try {
            nPagePerRows = Integer.parseInt(pagePerRows);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.wm.setPageRows(nPagePerRows);
        return this.makeListData(nPage, request, page);
    }

    public String export(HttpServletRequest request, BIReportPage page) throws BIReportException {
        String exportType = request.getParameter(PARAM_EXPORT_TYPE);
        Map data = this.makeListMap(0, request, page);
        try {
            return WorklistComponent.export(request, exportType, data);
        }
        catch (Exception e) {
            throw new BIReportException(e);
        }
    }

    private static String export(HttpServletRequest request, String exportType, Map data) throws Exception {
        KDSBook book = new KDSBook("bi_book");
        KDSSheet sheet = new KDSSheet(book, data.get(KEY_LIST_TITLE).toString());
        HashMap<Integer, Integer> mapColumnWidth = new HashMap<Integer, Integer>();
        int row = 0;
        int col = 0;
        int calcWidth = 0;
        String head = data.get(KEY_LIST_HEAD).toString();
        sheet.setCellValue(row, col, (Object)head);
        ++row;
        List lstHead = (List)data.get(KEY_LIST_HEADTAG);
        List lstData = (List)data.get(KEY_LIST_DATATAG);
        int cols = lstHead.size();
        int rows = lstData.size() + 1;
        for (int rr = 0; rr < rows; ++rr) {
            Iterator it = null;
            it = rr == 0 ? lstHead.iterator() : ((List)lstData.get(rr - 1)).iterator();
            for (int cc = 0; cc < cols; ++cc) {
                Object cellValue = it.next();
                KDSCell cell = sheet.setCellValue(row, col, cellValue);
                if (cellValue instanceof Number || cellValue instanceof Timestamp) {
                    sheet.getCellStyleAttributes(row, col).setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                } else {
                    sheet.getCellStyleAttributes(row, col).setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
                }
                calcWidth = cellValue == null || cell == null ? 0 : ExportUtil.calcWidth(cell, cellValue.toString());
                Integer colWidth = (Integer)mapColumnWidth.get(new Integer(col));
                if (colWidth == null || colWidth.compareTo(new Integer(calcWidth)) < 0) {
                    mapColumnWidth.put(new Integer(col), new Integer(calcWidth));
                    sheet.getColumns().setColumnWidth(col, (float)UnitConverter.px2mm((int)calcWidth));
                }
                ++col;
            }
            col = 0;
            ++row;
        }
        String tail = data.get(KEY_LIST_TAIL).toString();
        sheet.setCellValue(row, col, (Object)tail);
        ExportUtil.addMergeWithBorder(sheet, 0, 0, 1, cols);
        sheet.getCellStyleAttributes(0, 0).setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        ExportUtil.addMergeWithBorder(sheet, row, 0, 1, cols);
        sheet.getCellStyleAttributes(row, 0).setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        book.addSheet(null, sheet);
        String fileName = ExportUtil.exportFile(book, exportType, null);
        return request.getContextPath() + "/" + Constants.SERVLET_URL + "?" + "servletType" + "=" + "export" + "&" + PARAM_EXPORT_TYPE + "=" + exportType + "&" + "filename" + "=" + fileName;
    }

    private String createFilterSql(String sql) {
        String filterSql = sql.toLowerCase();
        String orderContition = "";
        int findOrderBy = filterSql.indexOf("order by");
        if (findOrderBy != -1) {
            filterSql = sql.substring(0, findOrderBy);
            orderContition = sql.substring(findOrderBy);
        } else {
            filterSql = sql;
        }
        Map mapFilter = this.wm.getFilters();
        Iterator itColumn = mapFilter.keySet().iterator();
        StringBuffer sbCondition = new StringBuffer();
        boolean filterFirst = true;
        while (itColumn.hasNext()) {
            if (filterFirst) {
                filterFirst = false;
            } else {
                sbCondition.append(" and ");
            }
            String column = (String)itColumn.next();
            Filter filter = (Filter)mapFilter.get(column);
            sbCondition.append(filter.toSql());
        }
        if (mapFilter.size() > 0) {
            filterSql = "select * from (" + filterSql + ") " + VIEW_TEMP_NAME_FILTER;
            filterSql = filterSql + " where " + sbCondition.toString();
        }
        filterSql = filterSql + " " + orderContition;
        return filterSql;
    }

    private String createSortSql(String sql) {
        String sortColumn = this.wm.getSortColumn();
        List sortColumns = this.wm.getSortColumns();
        boolean isASC = this.wm.isASC();
        List sortAscs = this.wm.getSortOrders();
        if (StringUtils.isEmpty((String)sortColumn) && (sortColumns == null || sortColumns.size() == 0)) {
            return sql;
        }
        String sortSql = sql.toLowerCase();
        sortSql = sortSql.indexOf("order by") != -1 ? sql.substring(0, sortSql.indexOf("order by")) : sql;
        if (sortColumns != null && sortColumns.size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(sortSql);
            sb.append(" order by ");
            Iterator itColumns = sortColumns.iterator();
            Iterator itAscs = sortAscs.iterator();
            boolean isFirst = true;
            while (itColumns.hasNext()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(",");
                }
                String col = (String)itColumns.next();
                Boolean isAsc = (Boolean)itAscs.next();
                sb.append(col + " " + (isAsc != false ? PARAM_SORT_BY_ASC : "desc"));
            }
            return sb.toString();
        }
        return sortSql + " order by " + sortColumn + " " + (isASC ? PARAM_SORT_BY_ASC : "desc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTotalRows(Connection con, String sql, Object param) throws SQLException {
        int n;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String totalSql = sql.toLowerCase();
        totalSql = totalSql.indexOf("order by") != -1 ? sql.substring(0, totalSql.indexOf("order by")) : sql;
        try {
            ps = con.prepareStatement("select count(1) from (" + totalSql + ") " + VIEW_TEMP_NAME);
            if (!this.wm.isDataDrill()) {
                ps.setObject(1, param);
            }
            rs = ps.executeQuery();
            rs.next();
            n = rs.getInt(1);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, ps);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        return n;
    }

    private Map makeListMap(int currentPage, HttpServletRequest request, BIReportPage page) throws BIReportException {
        Object param = this.wm.getParam();
        String ds = this.wm.getDs();
        String sortColumn = this.wm.getSortColumn();
        List sortColumns = this.wm.getSortColumns();
        boolean isASC = this.wm.isASC();
        int pageRows = this.wm.getPageRows();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<String, Object> mapRet = new HashMap<String, Object>();
        BIReportVarProvider varProvider = new BIReportVarProvider(BISystem.getContext(request), !BISystem.isEAS(), page.getSubject().getRuntimeVarFilename(), page.getSubject().getRuntimeVarClassname(), page.getBIReport().getDatacenter());
        String sql = null;
        sql = this.wm.isDataDrill() ? this.wm.getDataDrillSql() : page.getDataSourceManager().getDataProvider().getSql(ds);
        sql = page.transStringByVarAndMacro(sql, varProvider);
        mapRet.put("perPageRows", new Integer(pageRows));
        mapRet.put(KEY_CURRENT_PAGE, new Integer(currentPage));
        mapRet.put(KEY_LIST_UUID, this.id);
        mapRet.put(KEY_LIST_TITLE, page.transStringByVarAndMacro(this.transByParam(this.wm.getCaption()), varProvider));
        mapRet.put(KEY_LIST_HEAD, page.transStringByVarAndMacro(this.transByParam(this.wm.getHead()), varProvider));
        mapRet.put(KEY_LIST_TAIL, page.transStringByVarAndMacro(this.transByParam(this.wm.getTail()), varProvider));
        mapRet.put(KEY_LIST_WIDTH, new Integer(this.wm.getWidth()));
        try {
            String filterSql;
            con = BISystem.getJdbcConnection(BISystem.getContext(request), page.getBIReport().getDatacenter());
            this.currentSql = filterSql = this.createFilterSql(sql);
            int totalrow = this.getTotalRows(con, filterSql, param);
            String sortSql = this.createSortSql(filterSql);
            ps = con.prepareStatement(sortSql, 1004, 1007);
            if (!this.wm.isDataDrill()) {
                ps.setObject(1, param);
            }
            rs = ps.executeQuery();
            ResultSetMetaData rmd = rs.getMetaData();
            int rowBegin = 1;
            if (currentPage > 0) {
                rowBegin = (currentPage - 1) * pageRows + 1;
            }
            int rowEnd = totalrow;
            int totalPage = 1;
            if (pageRows > 0 && currentPage > 0) {
                rowEnd = currentPage * pageRows;
                if (rowEnd > totalrow) {
                    rowEnd = totalrow;
                }
                totalPage = (totalrow - 1) / pageRows + 1;
            }
            if (!StringUtils.isEmpty((String)sortColumn)) {
                mapRet.put(KEY_SORT_COLUMN, sortColumn);
                mapRet.put(KEY_SORT_ASC, new Boolean(isASC));
            }
            mapRet.put(KEY_TOTAL_PAGE, new Integer(totalPage));
            List<String> lstHead = new ArrayList();
            ArrayList lstData = new ArrayList();
            HashMap<String, String> mapColumnType = new HashMap<String, String>();
            int columns = rmd.getColumnCount();
            for (int i = 0; i < columns; ++i) {
                String columnName = rmd.getColumnName(i + 1);
                String type = this.parseSqlType(rmd.getColumnType(i + 1));
                mapColumnType.put(columnName, type);
                lstHead.add(columnName);
            }
            if (rowBegin - 1 > 0) {
                rs.absolute(rowBegin - 1);
            }
            lstHead = this.sortHeadByOrder(lstHead, sortColumns);
            for (int counter = rowEnd - rowBegin + 1; rs.next() && counter > 0; --counter) {
                ArrayList<Object> lstDataRow = new ArrayList<Object>();
                Iterator it = lstHead.iterator();
                for (int i = 0; i < columns; ++i) {
                    Format df;
                    String field = (String)it.next();
                    Object o = rs.getObject(field);
                    Map format = this.wm.getFormat();
                    String strFormat = null;
                    if (format != null) {
                        strFormat = (String)format.get(field.toLowerCase());
                    }
                    if (o == null) {
                        o = "";
                    }
                    if (o instanceof String) {
                        o = ((String)o).replaceAll("\\n", "<br/>").replaceAll("\\r", "");
                    } else if (o instanceof Number) {
                        try {
                            if (!StringUtils.isEmpty((String)strFormat)) {
                                df = new DecimalFormat(strFormat);
                                o = df.format(o);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            logger.error((Object)("\u6570\u503c\u683c\u5f0f\u5316\u51fa\u9519,\u9519\u8bef\u7684\u683c\u5f0f\u5316\u4e32" + strFormat), (Throwable)e);
                        }
                    } else if (o instanceof Date || o instanceof Timestamp || o instanceof Time) {
                        try {
                            if (!StringUtils.isEmpty((String)strFormat)) {
                                df = new SimpleDateFormat(strFormat);
                                o = df.format(o);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            logger.error((Object)("\u65e5\u671f/\u65f6\u95f4\u683c\u5f0f\u5316\u51fa\u9519,\u9519\u8bef\u7684\u683c\u5f0f\u5316\u4e32" + strFormat), (Throwable)e);
                        }
                    }
                    lstDataRow.add(o);
                }
                lstData.add(lstDataRow);
            }
            mapRet.put("type", mapColumnType);
            mapRet.put(KEY_LIST_HEADTAG, lstHead);
            mapRet.put(KEY_LIST_DATATAG, lstData);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"\u7a7f\u900f\u6570\u636e\u6e90\u6267\u884c\u5931\u8d25!", (Throwable)e);
                throw new BIReportException("\u7a7f\u900f\u6570\u636e\u6e90\u6267\u884c\u5931\u8d25!" + e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return mapRet;
    }

    private String getMemberProperty(Member member, String prop) {
        if ("name".equalsIgnoreCase(prop)) {
            return member.getName();
        }
        if ("caption".equalsIgnoreCase(prop)) {
            return member.getCaption();
        }
        Object ret = member.getProperty(prop);
        if (ret != null) {
            return ret.toString();
        }
        return "";
    }

    private String makeListData(int currentPage, HttpServletRequest request, BIReportPage page) throws BIReportException {
        Map map = this.makeListMap(currentPage, request, page);
        JSONMap jsRet = new JSONMap(map);
        return jsRet.toString();
    }

    private String transByParam(String str) {
        if (!StringUtils.isEmpty((String)str) && this.wm.getParam() != null) {
            return StringUtils.replace((String)str, (String)"&[]&", (String)this.wm.getParam().toString());
        }
        return str;
    }

    private List sortHeadByOrder(List lstHead, List sortColumns) {
        if (sortColumns == null || sortColumns.size() == 0) {
            return lstHead;
        }
        if (lstHead == null || lstHead.size() == 0) {
            return lstHead;
        }
        ArrayList<String> tempList = new ArrayList<String>();
        for (String col : sortColumns) {
            if (!lstHead.contains(col)) continue;
            tempList.add(col);
            lstHead.remove(col);
        }
        tempList.addAll(lstHead);
        return tempList;
    }

    private String parseSqlType(int type) {
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                return "number";
            }
            case 1: 
            case 12: {
                return "string";
            }
            case 91: 
            case 92: 
            case 93: {
                return "date";
            }
        }
        return "string";
    }
}

