/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.worksheet;

import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.web.worksheet.AxisBuilderSupport;
import com.kingdee.bos.ctrl.analysis.web.worksheet.ColumnAxisBuilder;
import com.kingdee.bos.ctrl.analysis.web.worksheet.SpanBuilderImpl;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.Span;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import java.util.Map;
import org.w3c.dom.Element;

public class ColumnAxisBuilderImpl
extends AxisBuilderSupport
implements ColumnAxisBuilder {
    public ColumnAxisBuilderImpl() {
        super(new SpanBuilderImpl("column-heading", "column-heading-heading"));
        this.setMemberIndent(false);
        this.setShowParentMembers(false);
        this.setHierarchyHeader(1);
        this.setMemberSpan(3);
        this.setHeaderSpan(3);
    }

    @Override
    public void buildRow(KDSSheet sheet, int rowIndex, int startRow, int startCol, Map mapColumnWidth) {
        int N = this.spanCalc.getPositionCount();
        for (int i = 0; i < N; ++i) {
            boolean even = i % 2 == 0;
            Span span = this.spanCalc.getSpan(i, rowIndex);
            if (!span.isSignificant()) continue;
            int colspan = span.getPositionSpan();
            int rowspan = span.getHierarchySpan();
            this.buildHeading(sheet, startRow, startCol + i, span, rowspan, colspan, even, mapColumnWidth);
        }
    }

    @Override
    public void buildRow(Element parent, int rowIndex, boolean first) {
        int N = this.spanCalc.getPositionCount();
        for (int i = 0; i < N; ++i) {
            boolean even = i % 2 == 0;
            Span span = this.spanCalc.getSpan(i, rowIndex);
            if (!first && !span.isSignificant()) continue;
            int colspan = span.getPositionSpan();
            int rowspan = span.getHierarchySpan();
            this.buildHeading(parent, span, rowspan, colspan, even);
        }
    }

    @Override
    public int getColumnCount() {
        return this.getAxis().getPositions().size();
    }

    @Override
    public int getRowCount() {
        return this.spanCalc.getHierarchyCount();
    }

    @Override
    protected Axis getAxis() {
        return this.worksheet.getColumnAxis();
    }
}

