/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.worksheet.navi;

import com.kingdee.bos.ctrl.analysis.modelcore.ModelChangeEvent;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelChangeListener;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.util.DomUtil;
import com.kingdee.bos.ctrl.analysis.web.WebFrameworkException;
import com.kingdee.bos.ctrl.analysis.web.worksheet.ColumnAxisBuilder;
import com.kingdee.bos.ctrl.analysis.web.worksheet.RowAxisBuilder;
import com.kingdee.bos.ctrl.analysis.web.worksheet.SpanBuilder;
import com.kingdee.bos.ctrl.analysis.web.worksheet.SpanBuilderDecorator;
import com.kingdee.bos.ctrl.analysis.web.worksheet.WorksheetComponent;
import com.kingdee.bos.ctrl.analysis.web.worksheet.WorksheetComponentExtensionSupport;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.Span;
import java.util.HashMap;
import org.w3c.dom.Element;

public abstract class DrillExpandUI
extends WorksheetComponentExtensionSupport
implements ModelChangeListener {
    boolean available;
    boolean renderActions;
    boolean initialized = false;
    protected HashMap spanMap = new HashMap();

    @Override
    public void initialize(WorksheetComponent worksheet) throws WebFrameworkException {
        ColumnAxisBuilder cab;
        super.initialize(worksheet);
        worksheet.getOlapModel().removeModelChangeListener(this);
        worksheet.getOlapModel().addModelChangeListener(this);
        this.available = this.initializeExtension();
        RowAxisBuilder rab = worksheet.getRowAxisBuilder();
        if (!(rab.getSpanBuilder() instanceof DomDecorator)) {
            DomDecorator rhr = new DomDecorator(rab.getSpanBuilder());
            rab.setSpanBuilder(rhr);
        }
        if (!((cab = worksheet.getColumnAxisBuilder()).getSpanBuilder() instanceof DomDecorator)) {
            DomDecorator chr = new DomDecorator(cab.getSpanBuilder());
            cab.setSpanBuilder(chr);
        }
        this.spanMap.clear();
    }

    protected abstract boolean initializeExtension();

    protected abstract boolean canExpand(Span var1);

    protected abstract void expand(Span var1);

    protected abstract boolean canCollapse(Span var1);

    protected abstract void collapse(Span var1);

    protected abstract String getExpandImage();

    protected abstract String getCollapseImage();

    public boolean isAvailable() {
        return this.available;
    }

    static int indexOf(Object[] array, Object obj) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != obj) continue;
            return i;
        }
        return -1;
    }

    static boolean positionContainsMember(Span s) {
        if (!s.isMember()) {
            return false;
        }
        Member m = (Member)s.getMember().getRootDecoree();
        Position p = (Position)s.getPosition().getRootDecoree();
        return DrillExpandUI.indexOf(p.getMembers(), m) >= 0;
    }

    @Override
    public void modelChanged(ModelChangeEvent e) {
        this.initializeExtension();
    }

    public void structureChanged(ModelChangeEvent e) {
        this.available = this.initializeExtension();
    }

    public void doExpandCollapse(String id) {
        Span span = (Span)this.spanMap.get(id);
        if (this.canExpand(span)) {
            this.expand(span);
        } else {
            this.collapse(span);
        }
    }

    public String getSpanInfo(String id) {
        Span span = (Span)this.spanMap.get(id);
        Position position = span.getPosition();
        Member member = span.getMember();
        StringBuffer sb = new StringBuffer();
        Member[] ms = position.getMembers();
        int index = -1;
        for (int i = 0; i < ms.length; ++i) {
            sb.append(ms[i].getName()).append("\u0001");
            sb.append(ms[i].getUniqueName()).append("\u0001");
            sb.append(ms[i].getCaption()).append("\u0001");
            sb.append(ms[i].isLeaf() ? "1" : "0").append("\u0001");
            sb.append(ms[i].getDepth() == 0 ? "1" : "0").append("\u0001");
            if (ms[i] != member) continue;
            index = i;
        }
        sb.append(index);
        return sb.toString();
    }

    class DomDecorator
    extends SpanBuilderDecorator {
        DomDecorator(SpanBuilder delegate) {
            super(delegate);
        }

        @Override
        public Element build(Span span, boolean even) {
            Element parent = super.build(span, even);
            if (!DrillExpandUI.this.enabled || !DrillExpandUI.this.available) {
                return parent;
            }
            String id = DomUtil.randomId();
            parent.setAttribute("spanId", id);
            DrillExpandUI.this.spanMap.put(id, span);
            if (DrillExpandUI.this.canExpand(span)) {
                Element elem = DrillExpandUI.this.worksheet.insert("drill-expand", parent);
                elem.setAttribute("id", id);
                elem.setAttribute("img", DrillExpandUI.this.getExpandImage());
            } else if (DrillExpandUI.this.canCollapse(span)) {
                Element elem = DrillExpandUI.this.worksheet.insert("drill-collapse", parent);
                elem.setAttribute("id", id);
                elem.setAttribute("img", DrillExpandUI.this.getCollapseImage());
            }
            return parent;
        }
    }
}

