/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.filter;

import com.kingdee.bos.ctrl.bibench.platform.model.nodes.datasource.RDdsAbstractNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.datasource.XDataSource;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.datasource.XFieldNode;
import com.kingdee.bos.ctrl.bibench.platform.ui.PaltformWorkBenchContext;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.dsprovider.RDTableForCubeModelProvider;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.dsprovider.RDTableSelectDlg;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.DSValue;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.FaceUtil;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.MsgBox;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DSPanel
extends KDPanel {
    private KDWorkButton btnEdit = new KDWorkButton("...");
    private KDTextField txtValue = new KDTextField("");
    private EditDialog dlg = null;
    private DSValue value;
    private RDTableForCubeModelProvider provider;
    private PaltformWorkBenchContext ctx;

    public DSPanel(RDTableForCubeModelProvider provider, PaltformWorkBenchContext ctx) {
        this.provider = provider;
        this.ctx = ctx;
        this.setLayout(new BorderLayout());
        this.add((Component)this.txtValue, "Center");
        this.add((Component)this.btnEdit, "East");
        this.txtValue.setEditable(false);
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DSPanel.this.showEditorDialog();
            }
        });
    }

    private void showEditorDialog() {
        if (this.dlg == null) {
            Window w = SwingUtilities.getWindowAncestor((Component)((Object)this));
            this.dlg = w instanceof Frame ? new EditDialog((Frame)w) : (w instanceof Dialog ? new EditDialog((Dialog)w) : new EditDialog());
        }
        this.dlg.pb.setSelector((KDPromptSelector)new RDTableSelectDlg((Dialog)((Object)this.dlg), this.provider));
        this.dlg.setInitValue(this.value);
        this.dlg.show(true);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value instanceof DSValue ? (DSValue)value : null;
        this.txtValue.setText(value == null ? "" : String.valueOf(value));
    }

    class EditDialog
    extends KDDialog {
        private KDPromptBox pb;
        private KDButton btnOK;
        private KDButton btnCanel;
        private KDPanel contentPanel;
        private boolean modified;
        private KDPanel cp;
        private KDTable tbl;
        private KDCheckBox cbSelfUI;
        private KDComboBox cbReturn;
        private KDComboBox cbDisplay;
        private KDTextField txtUIClass;

        public EditDialog(Frame f) {
            super(f, true);
            this.pb = new KDPromptBox();
            this.btnOK = new KDButton("\u786e\u5b9a");
            this.btnCanel = new KDButton("\u53d6\u6d88");
            this.contentPanel = new KDPanel();
            this.modified = false;
            this.cp = new KDPanel();
            this.tbl = new KDTable();
            this.cbSelfUI = new KDCheckBox("\u81ea\u5b9a\u4e49\u9009\u62e9\u754c\u9762");
            this.cbReturn = new KDComboBox();
            this.cbDisplay = new KDComboBox();
            this.txtUIClass = new KDTextField();
            this.initUI();
        }

        public EditDialog(Dialog f) {
            super(f, true);
            this.pb = new KDPromptBox();
            this.btnOK = new KDButton("\u786e\u5b9a");
            this.btnCanel = new KDButton("\u53d6\u6d88");
            this.contentPanel = new KDPanel();
            this.modified = false;
            this.cp = new KDPanel();
            this.tbl = new KDTable();
            this.cbSelfUI = new KDCheckBox("\u81ea\u5b9a\u4e49\u9009\u62e9\u754c\u9762");
            this.cbReturn = new KDComboBox();
            this.cbDisplay = new KDComboBox();
            this.txtUIClass = new KDTextField();
            this.initUI();
        }

        public EditDialog() {
            this.pb = new KDPromptBox();
            this.btnOK = new KDButton("\u786e\u5b9a");
            this.btnCanel = new KDButton("\u53d6\u6d88");
            this.contentPanel = new KDPanel();
            this.modified = false;
            this.cp = new KDPanel();
            this.tbl = new KDTable();
            this.cbSelfUI = new KDCheckBox("\u81ea\u5b9a\u4e49\u9009\u62e9\u754c\u9762");
            this.cbReturn = new KDComboBox();
            this.cbDisplay = new KDComboBox();
            this.txtUIClass = new KDTextField();
            this.initUI();
        }

        private void initUI() {
            this.setTitle("\u521d\u59cb\u503c-\u6570\u636e\u6e90");
            this.getContentPane().setLayout(new BorderLayout());
            this.pb.setEditable(false);
            this.pb.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    EditDialog.this.modified = true;
                    Object obj = eventObj.getNewValue();
                    EditDialog.this.fillDSField((RDdsAbstractNode)obj);
                }
            });
            this.getContentPane().add((Component)this.contentPanel, "Center");
            this.contentPanel.setLayout((LayoutManager)new CardLayout());
            KDPanel pn = new KDPanel();
            this.getContentPane().add((Component)pn, "South");
            pn.add((Component)this.btnOK);
            pn.add((Component)this.btnCanel);
            this.btnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditDialog.this.ok();
                }
            });
            this.btnCanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditDialog.this.cancel();
                }
            });
            this.setSize(500, 350);
            FaceUtil.center((Window)((Object)this));
            TableLayout layout = TableLayout.split((int)6, (int)1);
            this.cp.setLayout((LayoutManager)layout);
            for (int i = 0; i < 5; ++i) {
                layout.cell(i, 0).style().setMargin(10, 3, 10, 0);
            }
            Table t = null;
            t = layout.cell(0, 0).splitCol(2);
            this.cp.add((Component)new KDLabel("\u6570\u636e\u6e90: "), (Object)t.cell(0));
            this.cp.add((Component)this.pb, (Object)t.cell(1));
            t.cell(1).style().setPriX(1);
            KDContainer c = FaceUtil.createContainer("\u5b57\u6bb5", (Component)this.tbl);
            KDWorkButton btnUp = new KDWorkButton("\u2191");
            KDWorkButton btnDown = new KDWorkButton("\u2193");
            btnUp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditDialog.this.moveUp();
                }
            });
            btnDown.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditDialog.this.moveDown();
                }
            });
            c.addButton((JButton)btnUp);
            c.addButton((JButton)btnDown);
            this.cp.add((Component)c, (Object)layout.cell(1, 0));
            layout.cell(1, 0).style().setPriY(1);
            t = layout.cell(2, 0).splitCol(2);
            this.cp.add((Component)new KDLabel("\u8fd4\u56de\u503c: "), (Object)t.cell(0));
            this.cp.add((Component)this.cbReturn, (Object)t.cell(1));
            t.cell(1).style().setPriX(1);
            t = layout.cell(3, 0).splitCol(2);
            this.cp.add((Component)new KDLabel("\u663e\u793a\u503c: "), (Object)t.cell(0));
            this.cp.add((Component)this.cbDisplay, (Object)t.cell(1));
            t.cell(1).style().setPriX(1);
            this.contentPanel.add((Component)this.cp, (Object)"");
            this.tbl.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
            this.tbl.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
            this.tbl.getEditManager().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

                public void editValueChanged(KDTEditEvent e) {
                    EditDialog.this.modified = true;
                    EditDialog.this.onValueChanged(e.getRowIndex(), e.getColIndex(), e.getValue());
                }
            });
            this.txtUIClass.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    EditDialog.this.modified = true;
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                }
            });
            this.cbReturn.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    EditDialog.this.modified = true;
                }
            });
            this.cbDisplay.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    EditDialog.this.modified = true;
                }
            });
            this.txtUIClass.setToolTipText(KDPromptSelector.class.getName());
        }

        private void onValueChanged(int r, int col, Object newValue) {
            Boolean b;
            if ((col == 4 || col == 5) && (b = (Boolean)newValue).booleanValue()) {
                for (int i = 0; i < this.tbl.getRowCount(); ++i) {
                    if (i == r) continue;
                    this.tbl.getCell(i, col).setValue((Object)Boolean.FALSE);
                }
            }
        }

        private void moveUp() {
            this.moveRow(-1);
        }

        private void moveDown() {
            this.moveRow(1);
        }

        private void moveRow(int step) {
            KDTSelectBlock b = this.tbl.getSelectManager().get();
            if (b != null) {
                int from = b.getTop();
                int to = from + step;
                if (to >= 0 && to < this.tbl.getRowCount()) {
                    if (from > to) {
                        this.tbl.moveRow(from, to);
                    } else {
                        this.tbl.moveRow(to, from);
                    }
                    this.tbl.getSelectManager().select(to, 0);
                }
                this.modified = true;
            }
        }

        private void fillDSField(RDdsAbstractNode item) {
            this.cbReturn.removeAllItems();
            this.cbDisplay.removeAllItems();
            this.tbl.removeColumns();
            if (item == null) {
                return;
            }
            XDataSource ds = item.getDataSourceConfig();
            XFieldNode[] fs = ds.getFields();
            this.tbl.addColumn().getStyleAttributes().setLocked(true);
            this.tbl.addColumn().getStyleAttributes().setLocked(true);
            IColumn col = this.tbl.addColumn();
            col.getStyleAttributes().setLocked(true);
            col.setWidth(60);
            IRow row = this.tbl.addHeadRow();
            row.getCell(0).setValue((Object)"\u6807\u9898");
            row.getCell(1).setValue((Object)"\u540d\u79f0");
            row.getCell(2).setValue((Object)"\u7c7b\u578b");
            int n = fs.length;
            for (int i = 0; i < n; ++i) {
                row = this.tbl.addRow();
                row.getCell(0).setValue((Object)fs[i].getLabel());
                row.getCell(1).setValue((Object)fs[i].getName());
                row.getCell(2).setValue((Object)fs[i].getType());
                this.cbReturn.addItem((Object)fs[i].getName());
                this.cbDisplay.addItem((Object)fs[i].getName());
            }
            this.tbl.reLayoutAndPaint();
        }

        private void setInitValue(DSValue ds) {
            if (ds != null) {
                RDdsAbstractNode node = (RDdsAbstractNode)DSPanel.this.ctx.getTree().searchItemById(ds.getDsId());
                this.pb.setValue((Object)node);
                int to = 0;
                int n = ds.fieldSize();
                block0: for (int i = 0; i < n; ++i) {
                    String f = ds.getField(i);
                    for (int j = to; j < this.tbl.getRowCount(); ++j) {
                        String ff = (String)this.tbl.getCell(j, 1).getValue();
                        if (!ff.equals(f)) continue;
                        if (j != to) {
                            this.tbl.moveRow(j, to);
                        }
                        j = ++to + 1;
                        continue block0;
                    }
                }
                this.cbReturn.setSelectedItem((Object)ds.getReturnField());
                this.cbDisplay.setSelectedItem((Object)ds.getDisplayField());
            }
            this.modified = false;
        }

        private void ok() {
            if (this.modified) {
                DSValue v = new DSValue();
                RDdsAbstractNode item = (RDdsAbstractNode)this.pb.getValue();
                if (item == null) {
                    this.pb.requestFocus();
                    MsgBox.warn(this.getTitle(), "\u8bf7\u9009\u62e9\u6570\u636e\u6e90\u3002", (Component)((Object)this));
                    return;
                }
                v.setDsTitle(item.getName());
                v.setDsId(item.getId());
                v.setReturnField((String)this.cbReturn.getSelectedItem());
                v.setDisplayField((String)this.cbDisplay.getSelectedItem());
                DSValue oldValue = DSPanel.this.value;
                DSPanel.this.value = v;
                DSPanel.this.firePropertyChange("valueChanged", oldValue, DSPanel.this.value);
                this.modified = false;
            }
            this.close();
        }

        private void cancel() {
            this.close();
        }

        private void close() {
            this.hide();
        }
    }
}

