/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.dsfields;

import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Cube;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Dimension;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Fact;
import com.kingdee.bos.ctrl.analysis.xmlutil.XMLException;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.RDBaseNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.cubemodel.RDCubeModelNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.datasource.RDdsAbstractNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.datasource.XDataSource;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.datasource.XFieldNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.report.IReportNode;
import com.kingdee.bos.ctrl.bibench.platform.ui.PaltformWorkBenchContext;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.dsfields.DSEntity;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.dsfields.DSEntityField;
import java.util.ArrayList;

public class DSFieldsHelper {
    public static DSEntity[] buildDSEntity(IReportNode item, PaltformWorkBenchContext ctx) throws XMLException {
        int i;
        RDBaseNode normalNode = ctx.getTree().searchItemById(item.getReportConfig().getDsId());
        if (normalNode instanceof RDdsAbstractNode) {
            RDdsAbstractNode ds = (RDdsAbstractNode)normalNode;
            XFieldNode[] fs = ds.getDataSourceConfig().getFields();
            DSEntity de = new DSEntity();
            de.setName(ds.getName());
            de.setTitle(ds.getName());
            de.setTableId(ds.getId());
            for (int j = 0; j < fs.length; ++j) {
                DSEntityField f = DSFieldsHelper.toDSEntityField(fs[j]);
                de.addField(f);
            }
            return new DSEntity[]{de};
        }
        RDCubeModelNode mnode = (RDCubeModelNode)normalNode;
        if (mnode == null || mnode.getCubeModelConfig() == null || mnode.getCubeModelConfig().getCubeModel() == null) {
            return new DSEntity[0];
        }
        CubeModel_Cube cc = mnode.getCubeModelConfig().getCubeModel().getCubes()[0];
        CubeModel_Dimension[] dims = cc.getDimensions();
        ArrayList<DSEntity> dsList = new ArrayList<DSEntity>();
        CubeModel_Fact fact = cc.getFact();
        DSEntity ds = new DSEntity();
        ds.setName(fact.getName());
        ds.setTitle(fact.getAlias());
        ds.setTableId(fact.getTableRef().getName());
        dsList.add(ds);
        for (i = 0; i < dims.length; ++i) {
            ds = new DSEntity();
            ds.setName(dims[i].getName());
            ds.setTitle(dims[i].getAlias());
            ds.setTableId(dims[i].getTableRefs()[0].getName());
            dsList.add(ds);
        }
        int n = dsList.size();
        for (i = 0; i < n; ++i) {
            ds = (DSEntity)dsList.get(i);
            RDdsAbstractNode node = (RDdsAbstractNode)ctx.getTree().searchItemById(ds.getTableId());
            XDataSource xc = node.getDataSourceConfig();
            XFieldNode[] xfs = xc.getFields();
            for (int j = 0; j < xfs.length; ++j) {
                DSEntityField f = DSFieldsHelper.toDSEntityField(xfs[j]);
                ds.addField(f);
            }
        }
        return dsList.toArray(new DSEntity[0]);
    }

    private static DSEntityField toDSEntityField(XFieldNode field) {
        DSEntityField f = new DSEntityField();
        f.setName(field.getName());
        f.setTitle(field.getLabel());
        f.setType(field.getType());
        return f;
    }
}

