/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.fs.datasource;

import com.kingdee.bos.ctrl.analysis.mdxw.panelet.SplitUtil;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.RDBaseNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.datasource.XFieldNode;
import com.kingdee.bos.ctrl.bibench.platform.services.IPlatformFacade;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.fs.RDBaseInternalFrame;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.fs.datasource.SQLMessageDialog;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.objtree.EnvVarTreeHelper;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.FaceUtil;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.KDTableUtil;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.MsgBox;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.ui.editor.DefaultEditorStyleModel;
import com.kingdee.bos.ctrl.common.ui.editor.EditorRowHeader;
import com.kingdee.bos.ctrl.common.ui.editor.StyledEditor;
import com.kingdee.bos.ctrl.common.ui.editor.styled.ScriptQLStyledEditor;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class DSAbstractInnerFrame
extends RDBaseInternalFrame {
    private static final int UI_STATUS_NORMAL = 0;
    private static final int UI_STATUS_TEXT = 1;
    private static final int UI_STATUS_TABLE = 2;
    private int uiStatus = 0;
    protected StyledEditor editor;
    protected KDTable tblMap = new KDTable(3, 1, 0);
    private boolean mapModified = false;
    private KDContainer queryContainer = null;
    private KDScrollPane editorComp = null;
    private EditorRowHeader rh = new EditorRowHeader();
    private KDSplitPane querySp = new KDSplitPane(0);
    private KDTextArea txtMsg = new KDTextArea();
    private KDScrollPane txtMsgScrollPane = new KDScrollPane((Component)this.txtMsg);
    private KDTable tblResult = new KDTable();
    private KDWorkButton btnMapNew = new KDWorkButton("\u589e\u52a0");
    private KDWorkButton btnMapDel = new KDWorkButton("\u5220\u9664");
    private KDWorkButton btnGetMap = new KDWorkButton("\u4ece\u67e5\u8be2\u8bed\u53e5\u4e2d\u83b7\u53d6");
    private Set langFieldSet = new HashSet();

    public DSAbstractInnerFrame(RDBaseNode item) {
        super(item);
        this.editor = this.createDSEditor();
        this.editor.getInputMap().put(KeyStroke.getKeyStroke("F5"), "F5");
        this.editor.getActionMap().put("F5", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DSAbstractInnerFrame.this.executeQuery();
            }
        });
        this.editor.getInputMap().put(KeyStroke.getKeyStroke("F9"), "F9");
        this.editor.getActionMap().put("F9", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SQLMessageDialog.showSQL(DSAbstractInnerFrame.this.getSql(), "\u9884\u89c8SQL", (Component)DSAbstractInnerFrame.this.editor);
            }
        });
    }

    public StyledEditor createDSEditor() {
        return new ScriptQLStyledEditor();
    }

    @Override
    public void onLoad() throws Exception {
        KDSplitPane sp = new KDSplitPane(1);
        new SplitUtil().layout(sp, 0.35f);
        sp.setDividerLocation(200);
        KDPanel leftPanel = new KDPanel();
        leftPanel.setLayout((LayoutManager)new BorderLayout());
        KDContainer c = FaceUtil.createContainer("\u8f93\u51fa\u5b57\u6bb5", (Component)this.tblMap);
        c.addButton((JButton)this.btnGetMap);
        c.setPreferredSize(new Dimension(200, 100));
        this.tblMap.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        this.tblMap.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        this.tblMap.getColumn(0).getStyleAttributes().setLocked(true);
        this.tblMap.getColumn(2).getStyleAttributes().setLocked(true);
        this.tblResult.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        this.tblResult.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        this.btnMapNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DSAbstractInnerFrame.this.onNewRowMap();
            }
        });
        this.btnMapDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DSAbstractInnerFrame.this.onDelRowMap();
            }
        });
        this.btnGetMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DSAbstractInnerFrame.this.getMapFromQuery();
            }
        });
        KDPanel leftMainPanel = new KDPanel((LayoutManager)new BorderLayout());
        leftMainPanel.add((Component)c, (Object)"Center");
        Component propertyPart = this.getPropertyPartView();
        if (propertyPart != null) {
            KDSplitPane vsp = new KDSplitPane(0);
            vsp.add(propertyPart, (Object)"top");
            vsp.add((Component)leftMainPanel, (Object)"bottom");
            new SplitUtil().layout(vsp, 0.5f);
            vsp.setDividerLocation(300);
            leftPanel.add((Component)vsp, (Object)"Center");
        } else {
            leftPanel.add((Component)leftMainPanel, (Object)"Center");
        }
        sp.add((Component)leftPanel, (Object)"left");
        this.editorComp = new KDScrollPane((Component)this.editor);
        this.editorComp.setRowHeaderView((Component)this.rh);
        this.rh.setFont(this.editor.getFont());
        this.editor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DSAbstractInnerFrame.this.rh.showMaxRowNumber(DSAbstractInnerFrame.this.editor.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DSAbstractInnerFrame.this.rh.showMaxRowNumber(DSAbstractInnerFrame.this.editor.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.rh.setBackground(c.getBackground());
        this.rh.setForeground(Color.BLACK);
        this.queryContainer = FaceUtil.createContainer("\u67e5\u8be2\u8bed\u53e5", (Component)this.editorComp);
        KDWorkButton btnQuery = new KDWorkButton("    \u67e5\u8be2   ");
        btnQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DSAbstractInnerFrame.this.executeQuery();
            }
        });
        btnQuery.setToolTipText("F5");
        this.queryContainer.addButton((JButton)btnQuery);
        KDWorkButton btnViewSql = new KDWorkButton("\u9884\u89c8SQL");
        btnViewSql.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLMessageDialog.showSQL(DSAbstractInnerFrame.this.getSql(), "\u9884\u89c8SQL", (Component)DSAbstractInnerFrame.this.editor);
            }
        });
        btnViewSql.setToolTipText("F9");
        this.queryContainer.addButton((JButton)btnViewSql);
        sp.add((Component)this.queryContainer, (Object)"right");
        this.add((Component)sp, "Center");
        this.querySp.setDividerLocation(200);
        this.txtMsg.setEditable(false);
        this.tblResult.setEditable(false);
        IRow row = this.tblMap.getHeadRow(0);
        row.getCell(0).setValue((Object)"\u540d\u79f0");
        row.getCell(1).setValue((Object)"\u6807\u9898");
        row.getCell(2).setValue((Object)"\u7c7b\u578b");
        this.tblMap.getColumn(0).setWidth(60);
        this.tblMap.getColumn(1).setWidth(60);
        this.tblMap.getColumn(2).setWidth(60);
        this.tblMap.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                DSAbstractInnerFrame.this.mapModified = true;
            }
        });
        if (this.editor.getStyleModel() instanceof DefaultEditorStyleModel) {
            DefaultEditorStyleModel cs = (DefaultEditorStyleModel)this.editor.getStyleModel();
            cs.addStyle(this.ctx.getUserEnv().keySet(), cs.createSimpleAttributeSet(Color.PINK.darker()));
        }
    }

    protected String getLang() {
        return (String)this.ctx.getUserEnv().get("lang");
    }

    protected String getSql() {
        return this.editor.getText().trim();
    }

    private RDRowSet executeQuery() {
        this.clearLangField();
        String sql = this.getSql();
        if (sql == null) {
            return null;
        }
        RDRowSet rs = null;
        if (sql.length() > 0) {
            IPlatformFacade bc = this.ctx.getPlatformFacade();
            try {
                rs = bc.executeQuery(sql, 0, 100);
                this.showResult(rs);
            }
            catch (Exception e) {
                e.printStackTrace();
                MsgBox.error("\u67e5\u8be2\u8bed\u53e5\u9519\u8bef", e, (Component)((Object)this));
            }
            this.queryContainer.revalidate();
        } else {
            this.showNormal();
        }
        return rs;
    }

    private void showNormal() {
        switch (this.uiStatus) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                this.queryContainer.getContentPane().remove((Component)this.querySp);
                this.querySp.setDividerLocation(200);
                this.queryContainer.getContentPane().add((Component)this.editorComp, "Center");
                this.queryContainer.revalidate();
            }
        }
        this.uiStatus = 0;
    }

    private void showResult(RDRowSet rs) {
        switch (this.uiStatus) {
            case 0: {
                this.queryContainer.getContentPane().remove((Component)this.editorComp);
                this.querySp.add((Component)this.editorComp, (Object)"top");
                this.querySp.add((Component)this.tblResult, (Object)"bottom");
                this.queryContainer.getContentPane().add((Component)this.querySp, "Center");
                break;
            }
            case 1: {
                this.querySp.remove((Component)this.txtMsgScrollPane);
                this.querySp.add((Component)this.tblResult, (Object)"bottom");
                break;
            }
        }
        this.uiStatus = 2;
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        String lang = this.getLang();
        int n = this.tblMap.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object k = this.tblMap.getRow(i).getCell(0).getValue();
            Object v = this.tblMap.getRow(i).getCell(1).getValue();
            map.put(k, v);
            if (!this.langFieldSet.contains(((String)k).toLowerCase())) continue;
            map.put(k + "_" + lang, v);
        }
        KDTableUtil.setTableData(rs, map, this.tblResult);
    }

    public void setFieldMap(XFieldNode[] fs) {
        this.tblMap.setRefresh(false);
        this.tblMap.removeRows();
        for (int i = 0; i < fs.length; ++i) {
            XFieldNode f = fs[i];
            IRow r = this.tblMap.addRow();
            r.getCell(0).setValue((Object)f.getName());
            r.getCell(1).setValue((Object)f.getLabel());
            r.getCell(2).setValue((Object)f.getType());
        }
        this.tblMap.setRefresh(true);
        this.tblMap.reLayoutAndPaint();
    }

    public XFieldNode[] getFieldMap() {
        ArrayList<XFieldNode> fieldList = new ArrayList<XFieldNode>();
        int r = this.tblMap.getRowCount();
        for (int i = 0; i < r; ++i) {
            String name = (String)this.tblMap.getCell(i, 0).getValue();
            String value = (String)this.tblMap.getCell(i, 1).getValue();
            String type = (String)this.tblMap.getCell(i, 2).getValue();
            if (name == null || name.length() == 0) {
                name = "unnamed";
            }
            if (value == null || type == null) continue;
            XFieldNode fs = new XFieldNode(name, value, type);
            fieldList.add(fs);
        }
        return fieldList.toArray(new XFieldNode[0]);
    }

    protected void onNewRowMap() {
        this.mapModified = true;
        IRow row = this.tblMap.addRow();
        row.getCell(0).setValue((Object)"");
        row.getCell(1).setValue((Object)"");
        row.getCell(2).setValue((Object)"");
    }

    protected void onDelRowMap() {
        int i;
        KDTSelectManager sm = this.tblMap.getSelectManager();
        ArrayList<Integer> rList = new ArrayList<Integer>();
        for (i = this.tblMap.getRowCount() - 1; i >= 0; --i) {
            if (!sm.isCellSelected(i, 0) && !sm.isCellSelected(i, 1) && !sm.isCellSelected(i, 2)) continue;
            rList.add(new Integer(i));
            this.mapModified = true;
        }
        int n = rList.size();
        for (i = 0; i < n; ++i) {
            this.tblMap.removeRow(((Integer)rList.get(i)).intValue());
            this.mapModified = true;
        }
    }

    protected void getMapFromQuery() {
        boolean modified = false;
        RDRowSet rs = this.executeQuery();
        if (rs != null) {
            String name;
            HashSet<String> columnSet = new HashSet<String>();
            columnSet.addAll(Arrays.asList(rs.getColumnNames()));
            for (int j = 0; j < this.tblMap.getRowCount(); ++j) {
                name = (String)this.tblMap.getRow(j).getCell(0).getValue();
                if (columnSet.contains(name)) continue;
                this.tblMap.removeRow(j);
                modified = true;
                --j;
            }
            int n = rs.getColumnCount();
            for (int i = 0; i < n; ++i) {
                String type;
                name = rs.getColumnName(i);
                if (!this.mergeAddRow(name, type = DataType.fromJdbcType((int)rs.getColumnType(i)).getName())) continue;
                modified = true;
            }
        }
        if (modified) {
            this.doUpdateFieldMap();
        }
    }

    protected boolean mergeAddRow(String name, String type) {
        String nbuf = name.toLowerCase();
        if (this.langFieldSet.contains(nbuf)) {
            name = name + "_" + this.getLang();
            nbuf = name.toLowerCase();
        }
        int m = this.tblMap.getRowCount();
        for (int j = 0; j < m; ++j) {
            String t;
            String n = (String)this.tblMap.getRow(j).getCell(0).getValue();
            if (!nbuf.equals(n.toLowerCase(Locale.ENGLISH))) continue;
            boolean modified = false;
            String label = (String)this.tblMap.getRow(j).getCell(1).getValue();
            if (label == null || label.length() == 0) {
                this.tblMap.getRow(j).getCell(1).setValue((Object)name);
                modified = true;
            }
            if ((t = (String)this.tblMap.getRow(j).getCell(2).getValue()).equals(type)) {
                this.tblMap.getRow(j).getCell(2).setValue((Object)type);
                modified = true;
            }
            return modified;
        }
        IRow row = this.tblMap.addRow();
        row.getCell(0).setValue((Object)name);
        row.getCell(1).setValue((Object)this.ctx.getFieldNameMap().getFieldLabel(this.getFieldNameWithoutLang(name)));
        row.getCell(2).setValue((Object)type);
        return true;
    }

    protected String getFieldNameWithoutLang(String n) {
        String nbuf = n.toLowerCase(Locale.ENGLISH);
        if (nbuf.endsWith("_l1") || nbuf.endsWith("_l2") || nbuf.endsWith("_l3")) {
            n = n.substring(0, n.length() - 3);
            return n;
        }
        return n;
    }

    protected boolean fieldMapModified() {
        return this.mapModified;
    }

    public void setEditable(boolean b) {
        this.editor.setEditable(b);
        this.tblMap.setEditable(b);
        this.btnMapNew.setVisible(b);
        this.btnMapDel.setVisible(b);
        this.btnGetMap.setVisible(b);
    }

    protected Component getPropertyPartView() {
        return EnvVarTreeHelper.createNormalEnvTreeComponent("\u73af\u5883\u53d8\u91cf", this.ctx.getUserEnv());
    }

    public void addLangField(String name) {
        String s = name.toLowerCase();
        this.langFieldSet.add(s);
    }

    private void clearLangField() {
        this.langFieldSet.clear();
    }

    protected abstract void doUpdateFieldMap();
}

