/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.fs.datasource;

import com.kingdee.bos.ctrl.bibench.platform.model.nodes.RDBaseNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.datasource.RDdsSqlNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.datasource.XDataSource;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.fs.datasource.DSAbstractInnerFrame;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.fs.datasource.DSSqlBuilder;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.MsgBox;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.script.scriptql.IQLInvokeListener;
import java.awt.Component;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdom2.IllegalNameException;

public class DSSQLInnerFrame
extends DSAbstractInnerFrame {
    private RDdsSqlNode sqlItem;

    public DSSQLInnerFrame(RDBaseNode item) {
        super(item);
        this.sqlItem = (RDdsSqlNode)item;
        this.initUI();
    }

    private void initUI() {
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.setEditable(true);
        XDataSource xc = this.sqlItem.getDataSourceConfig();
        this.editor.setText(xc.getSql());
        this.editor.setCaretPosition(0);
        this.setFieldMap(xc.getFields());
        this.editor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DSSQLInnerFrame.this.doUpdateSQL();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DSSQLInnerFrame.this.doUpdateSQL();
            }
        });
        this.tblMap.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                DSSQLInnerFrame.this.doUpdateFieldMap();
            }
        });
    }

    private void doUpdateSQL() {
        XDataSource xc = this.sqlItem.getDataSourceConfig();
        xc.setSql(this.editor.getText());
        this.sqlItem.fireContentChanged();
    }

    @Override
    protected void doUpdateFieldMap() {
        XDataSource xc = this.sqlItem.getDataSourceConfig();
        xc.removeFieldMaps();
        try {
            xc.addFields(this.getFieldMap());
        }
        catch (IllegalNameException ex) {
            MsgBox.error("\u5b57\u6bb5\u540d\u683c\u5f0f\u4e0d\u6b63\u786e", (Exception)((Object)ex), (Component)((Object)this));
        }
        this.sqlItem.fireContentChanged();
    }

    @Override
    protected void onNewRowMap() {
        super.onNewRowMap();
        this.doUpdateFieldMap();
    }

    @Override
    protected void onDelRowMap() {
        super.onDelRowMap();
        this.doUpdateFieldMap();
    }

    @Override
    public void save() {
        if (this.fieldMapModified()) {
            this.doUpdateFieldMap();
        }
        super.save();
    }

    @Override
    protected String getSql() {
        String sql = this.editor.getText().trim();
        try {
            return DSSqlBuilder.getVarSql(sql, new IQLInvokeListener(){

                public void beforeInvokeProperty(Object owner, String name) {
                }

                public void afterInvokeProperty(Object owner, String name, Object returnValue) {
                }

                public void beforeInvokeMethod(Object owner, String name, List params) {
                }

                public void afterInvokeMethod(Object owner, String name, List params, Object returnValue) {
                    if ("lang".equals(name)) {
                        DSSQLInnerFrame.this.addLangField((String)params.get(0));
                    }
                }
            }, this.ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgBox.error("\u6267\u884c", "ScriptQL\u7ffb\u8bd1\u4e0d\u901a\u8fc7!", (Component)((Object)this));
            return null;
        }
    }
}

