/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.fs.report;

import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Cube;
import com.kingdee.bos.ctrl.analysis.mdxw.panelet.MdxEditorStyleModel;
import com.kingdee.bos.ctrl.analysis.mdxw.panelet.SplitUtil;
import com.kingdee.bos.ctrl.analysis.util.editor.EditorStyleModel;
import com.kingdee.bos.ctrl.analysis.util.editor.StyledEditor;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.RDBaseNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.cubemodel.RDCubeModelNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.report.RDXReportNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.report.XReport;
import com.kingdee.bos.ctrl.bibench.platform.services.util.Util;
import com.kingdee.bos.ctrl.bibench.platform.ui.IPublishBIReportAction;
import com.kingdee.bos.ctrl.bibench.platform.ui.PaltformWorkBenchContext;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.dsprovider.RDCubeModelSelectDlg;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.dsprovider.RDTableForCubeModelProvider;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.FilterDesignListener;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.FilterDesignPanel;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.FilterDialog;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.FilterItemCollection;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.fs.RDBaseInternalFrame;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.RDReportViewDlg;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.title.TitlePanelDesignUI;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.x.MdxBuilder;
import com.kingdee.bos.ctrl.bibench.platform.ui.icon.IconResource;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.FaceUtil;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.MsgBox;
import com.kingdee.bos.ctrl.common.ui.editor.EditorRowHeader;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ReportInnerFrameX
extends RDBaseInternalFrame {
    private StyledEditor mdxEditor = new StyledEditor((EditorStyleModel)new MdxEditorStyleModel());
    private KDPromptBox pb = new KDPromptBox();
    private KDWorkButton btnPublish;
    private KDTextField txtTitle = new KDTextField();
    private FilterDesignPanel designer;
    private TitlePanelDesignUI uiScriptPanel = new TitlePanelDesignUI();
    private EditorRowHeader rh = new EditorRowHeader();
    private RDXReportNode rptItem;
    private RDCubeModelSelectDlg modelDlg = null;
    private RDReportViewDlg previewDlg = null;

    public ReportInnerFrameX(RDBaseNode item) {
        super(item);
        this.rptItem = (RDXReportNode)item;
        this.designer = new FilterDesignPanel(this.rptItem);
        this.initUI();
    }

    private void initUI() {
        this.topPanel.setLayout((LayoutManager)new FlowLayout(0, 5, 3));
        this.topPanel.add((Component)new KDLabel("\u62a5\u8868\u6807\u9898:"));
        this.txtTitle.setColumns(20);
        this.topPanel.add((Component)this.txtTitle);
        this.topPanel.add((Component)new KDLabel("\u6570\u636e\u6a21\u578b:"));
        this.pb.setPreferredSize(new Dimension(150, 22));
        this.topPanel.add((Component)this.pb);
        this.pb.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ReportInnerFrameX.this.onSelectModel();
            }
        });
        KDScrollPane sp = new KDScrollPane((Component)this.mdxEditor);
        sp.setRowHeaderView((Component)this.rh);
        this.rh.setFont(this.mdxEditor.getFont());
        KDContainer cc = FaceUtil.createContainer("", (Component)sp);
        this.rh.setBackground(cc.getBackground());
        this.rh.setForeground(Color.BLACK);
        KDTabbedPane tabbedPanel = new KDTabbedPane(1);
        tabbedPanel.add("MDX\u67e5\u8be2\u8bed\u53e5", (Component)cc);
        tabbedPanel.add("\u62a5\u8868\u6807\u9898\u8bbe\u8ba1", (Component)((Object)this.uiScriptPanel));
        KDSplitPane spV = new KDSplitPane(0);
        spV.add((Component)((Object)this.designer), (Object)"top");
        spV.add((Component)tabbedPanel, (Object)"bottom");
        this.add((Component)spV, "Center");
        new SplitUtil().layout(spV, 0.5f);
        spV.setDividerLocation(300);
        KDWorkButton btnCheckMdx = new KDWorkButton("\u68c0\u67e5\u8bed\u6cd5");
        btnCheckMdx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportInnerFrameX.this.checkMdx();
            }
        });
        cc.addButton((JButton)btnCheckMdx);
        this.designer.addFilterDesignListener(new FilterDesignListener(){

            @Override
            public void filterChanged() {
                ReportInnerFrameX.this.rptItem.fireContentChanged();
            }
        });
    }

    @Override
    public void setWorkBenchContext(PaltformWorkBenchContext workBenchContext) {
        super.setWorkBenchContext(workBenchContext);
        this.uiScriptPanel.setWorkBenchContext(workBenchContext);
    }

    @Override
    public void initToolBar(KDToolBar bar) {
        this.initToolBar_addSave(bar);
        this.initToolBar_addPreview(bar);
        this.initToolBar_addPublish(bar);
        this.initToolBar_addExit(bar);
    }

    protected void initToolBar_addPreview(KDToolBar bar) {
        KDWorkButton btnPreview = new KDWorkButton("\u62a5\u8868\u9884\u89c8");
        btnPreview.setIcon(IconResource.getIcon("tree_reportforms.gif"));
        btnPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportInnerFrameX.this.preview();
            }
        });
        bar.add((Component)btnPreview);
    }

    protected void initToolBar_addPublish(KDToolBar bar) {
        this.btnPublish = new KDWorkButton("\u53d1\u5e03");
        this.btnPublish.setIcon(IconResource.getIcon("tree_reportforms.gif"));
        this.btnPublish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportInnerFrameX.this.publish();
            }
        });
        bar.add((Component)this.btnPublish);
    }

    protected void publish() {
        IPublishBIReportAction pa = this.ctx.getConfig().getPublishBIReportAction();
        if (pa == null) {
            MsgBox.info("\u53d1\u5e03", "\u5c1a\u672a\u8bbe\u7f6e\u53d1\u5e03\u63a5\u53e3\u3002", (Component)((Object)this));
        } else if (this.rptItem.getDesignStatus() != 0) {
            if (MsgBox.confirm("\u53d1\u5e03", "\u53d1\u5e03\u524d\u5c06\u81ea\u52a8\u4fdd\u5b58\u62a5\u8868\uff0c\u7ee7\u7eed\u5417\uff1f", (Component)((Object)this))) {
                this.save();
                pa.publish(this.rptItem, this.ctx);
            }
        } else {
            pa.publish(this.rptItem, this.ctx);
        }
    }

    private void checkMdx() {
        try {
            if (this.mdxEditor.checkValidate()) {
                MsgBox.info("\u68c0\u67e5MDX\u8bed\u53e5", "\u8bed\u6cd5\u6b63\u786e\uff01", (Component)((Object)this));
            }
        }
        catch (Exception ex) {
            MsgBox.error("\u68c0\u67e5mdx\u8bed\u53e5\uff1a\u8bed\u6cd5\u9519\u8bef", ex, (Component)((Object)this));
        }
    }

    private void onSelectModel() {
        RDCubeModelNode sitem;
        if (this.modelDlg == null) {
            this.modelDlg = new RDCubeModelSelectDlg(this.item, (Frame)((Object)this.ctx.getFrame()));
        }
        if ((sitem = (RDCubeModelNode)this.modelDlg.showDialog()) != null) {
            this.pb.setUserObject((Object)sitem);
            this.pb.setText(sitem.getName());
            this.pb.setToolTipText(sitem.getName());
            try {
                XReport xc = (XReport)this.rptItem.getReportConfig();
                xc.setDsId(String.valueOf(sitem.getId()));
                this.rptItem.fireContentChanged();
                CubeModel cm = sitem.getCubeModelConfig().getCubeModel();
                CubeModel_Cube cube = cm.getCubes()[0];
                this.txtTitle.setText(cube.getAlias());
                this.mdxEditor.setText(MdxBuilder.createDefaultMdx(cm, true));
            }
            catch (Exception e) {
                e.printStackTrace();
                MsgBox.error("\u9009\u62e9\u6570\u636e\u6a21\u578b...", e, (Component)((Object)this));
            }
        }
    }

    private void doUpdateTitle() {
        XReport xc = (XReport)this.rptItem.getReportConfig();
        xc.setName(this.txtTitle.getText());
        this.rptItem.fireContentChanged();
    }

    private void doUpdateMdx() {
        XReport xc = (XReport)this.rptItem.getReportConfig();
        xc.setMdx(this.mdxEditor.getText());
        this.rptItem.fireContentChanged();
    }

    private void doUpdateUIScript() {
        XReport xc = (XReport)this.rptItem.getReportConfig();
        String uiScript = this.uiScriptPanel.getScript();
        xc.setUIScript(uiScript);
        this.rptItem.fireContentChanged();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        XReport xc = (XReport)this.rptItem.getReportConfig();
        this.txtTitle.setText(xc.getName());
        RDBaseNode dsNode = this.ctx.getTree().searchItemById(xc.getDsId());
        if (dsNode != null) {
            this.pb.setValue((Object)dsNode);
        }
        this.mdxEditor.setText(xc.getMdx());
        this.designer.setWorkBenchContext(this.ctx);
        this.designer.onLoad();
        this.designer.setFilters(FilterItemCollection.fromScript(xc.getFilterScript()));
        this.uiScriptPanel.setScript(xc.getUIScript());
        this.uiScriptPanel.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ReportInnerFrameX.this.doUpdateUIScript();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ReportInnerFrameX.this.doUpdateUIScript();
            }
        });
        this.txtTitle.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ReportInnerFrameX.this.doUpdateTitle();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ReportInnerFrameX.this.doUpdateTitle();
            }
        });
        this.mdxEditor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ReportInnerFrameX.this.rh.showMaxRowNumber(ReportInnerFrameX.this.mdxEditor.getText());
                ReportInnerFrameX.this.doUpdateMdx();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ReportInnerFrameX.this.rh.showMaxRowNumber(ReportInnerFrameX.this.mdxEditor.getText());
                ReportInnerFrameX.this.doUpdateMdx();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.btnPublish.setEnabled(this.ctx.getConfig().getPublishBIReportAction() != null);
    }

    protected void preview() {
        try {
            XReport xc = (XReport)this.rptItem.getReportConfig();
            if (Util.isEmpty(Util.trim(xc.getDsId()))) {
                this.pb.requestFocus();
                MsgBox.info("\u62a5\u8868\u9884\u89c8", "\u8bf7\u9009\u62e9\u6570\u636e\u6a21\u578b\u3002", (Component)((Object)this));
                return;
            }
            if (Util.isEmpty(Util.trim(xc.getMdx()))) {
                this.mdxEditor.requestFocus();
                MsgBox.info("\u62a5\u8868\u9884\u89c8", "\u8bf7\u8f93\u5165MDX\u8bed\u53e5\u3002", (Component)((Object)this));
                return;
            }
            FilterDialog fd = new FilterDialog(xc, this.ctx);
            FilterItemCollection fc = fd.showQueryDialog();
            if (fc != null) {
                RDCubeModelNode cmItem = (RDCubeModelNode)this.ctx.getTree().searchItemById(xc.getDsId());
                RDTableForCubeModelProvider provider = new RDTableForCubeModelProvider(cmItem);
                CubeModel cm = cmItem.getCubeModelConfig().getCubeModel();
                if (cm != null) {
                    if (this.previewDlg == null) {
                        this.previewDlg = new RDReportViewDlg((Frame)((Object)this.ctx.getFrame()), this.ctx);
                    }
                    this.previewDlg.setTitle(xc.getName());
                    this.previewDlg.showX(xc, cm, provider, xc.getMdx(), fc, fd);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgBox.error("\u62a5\u8868\u9884\u89c8", e, (Component)((Object)this));
        }
    }

    @Override
    public void save() {
        XReport xc = (XReport)this.rptItem.getReportConfig();
        String uiScript = this.uiScriptPanel.getScript();
        xc.setUIScript(uiScript);
        FilterItemCollection fc = this.designer.getFilters();
        if (fc.check((Component)((Object)this))) {
            String script = fc.toScript();
            xc.setFilterScript(script);
            this.rptItem.fireContentChanged();
            super.save();
        }
    }
}

