/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util;

import java.io.PrintWriter;
import java.io.StringWriter;

public class ExceptionUtil {
    public static String findMessage(Throwable t) {
        String msg = null;
        Throwable last = null;
        while (t != null && t != last && (msg = t.getMessage()) == null) {
            last = t;
            t = last.getCause();
        }
        return msg;
    }

    public static String makeTrace(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.getBuffer().toString();
    }

    public static String makeMessageStack(Throwable t) {
        StringBuffer sb = new StringBuffer();
        Throwable last = null;
        while (t != null && t != last) {
            if (t.getMessage() != null) {
                sb.append("\r\n>> ");
                sb.append(t.getMessage());
            }
            last = t;
            t = last.getCause();
        }
        if (sb.length() == 0) {
            sb.append("\r\n>> \u7a0b\u5e8f\u9519\u8bef\uff1a");
            if (last != null) {
                sb.append(last.getClass().getName());
            }
        }
        return sb.toString();
    }

    public static Throwable findCause(Throwable t, Class type) {
        Throwable last = null;
        while (t != null && t != last) {
            if (type == t.getClass()) {
                return t;
            }
            last = t;
            t = last.getCause();
        }
        return null;
    }
}

