/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.variant;

import com.kingdee.bos.ctrl.common.variant.ExprErr;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Util;
import com.kingdee.bos.ctrl.common.variant.VarBase;
import com.kingdee.bos.ctrl.common.variant.Variant;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

class VarLong
extends VarBase {
    VarLong() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        long leftval = (Long)left.getValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.add(leftval, (long)((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.add(leftval, (long)rightval, result);
                    break;
                }
                case 9: {
                    result.setObject(((BigInteger)right.getValue()).add(BigInteger.valueOf(leftval)), 9);
                    break;
                }
                case 10: {
                    result.setObject(((BigDecimal)right.getValue()).add(BigDecimal.valueOf(leftval)), 10);
                    break;
                }
                case 11: {
                    result.setObject(new BigDecimal((String)right.getValue()).add(BigDecimal.valueOf(leftval)), 10);
                    break;
                }
                case 12: {
                    Util.add(leftval, ((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.add(leftval, right.longValue(), result);
                    break;
                }
                case 15: {
                    left.add((Variant)right.getValue(), result);
                    break;
                }
                case 0: {
                    result.setVariant(left);
                    break;
                }
                default: {
                    ExprErr.goError(64L, "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97");
                }
            }
        }
    }

    @Override
    protected void subtract(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        long leftval = (Long)left.getValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.subtract(leftval, (long)((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.subtract(leftval, (long)rightval, result);
                    break;
                }
                case 9: {
                    result.setObject(BigInteger.valueOf(leftval).subtract((BigInteger)right.getValue()), 9);
                    break;
                }
                case 10: {
                    result.setObject(BigDecimal.valueOf(leftval).subtract((BigDecimal)right.getValue()), 10);
                    break;
                }
                case 11: {
                    result.setObject(BigDecimal.valueOf(leftval).subtract(new BigDecimal((String)right.getValue())), 10);
                    break;
                }
                case 12: {
                    Util.subtract(leftval, ((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.subtract(leftval, right.longValue(), result);
                    break;
                }
                case 15: {
                    left.subtract((Variant)right.getValue(), result);
                    break;
                }
                case 0: {
                    result.setVariant(left);
                    break;
                }
                default: {
                    ExprErr.goError(64L, "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97");
                }
            }
        }
    }

    @Override
    protected void multiply(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        long leftval = (Long)left.getValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.multiply(leftval, (long)((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.multiply(leftval, (long)rightval, result);
                    break;
                }
                case 9: {
                    result.setObject(BigInteger.valueOf(leftval).multiply((BigInteger)right.getValue()), 9);
                    break;
                }
                case 10: {
                    result.setObject(BigDecimal.valueOf(leftval).multiply((BigDecimal)right.getValue()), 10);
                    break;
                }
                case 11: {
                    result.setObject(BigDecimal.valueOf(leftval).multiply(new BigDecimal((String)right.getValue())), 10);
                    break;
                }
                case 12: {
                    Util.multiply(leftval, ((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.multiply(leftval, right.longValue(), result);
                    break;
                }
                case 15: {
                    left.multiply((Variant)right.getValue(), result);
                    break;
                }
                case 0: {
                    result.setVariant(left);
                    break;
                }
                default: {
                    ExprErr.goError(64L, "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97");
                }
            }
        }
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
    }

    @Override
    protected void mod(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        long leftval = (Long)left.getValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.mod(leftval, (long)((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.mod(leftval, (long)rightval, result);
                    break;
                }
                case 9: {
                    result.setObject(((BigInteger)right.getValue()).mod(BigInteger.valueOf(leftval)), 9);
                    break;
                }
                case 10: {
                    Util.mod((double)leftval, right.doubleValue(), result);
                    break;
                }
                case 11: {
                    Variant vright = new Variant();
                    if (right.isNumeric(vright)) {
                        this.mod(left, vright, result);
                        break;
                    }
                    ExprErr.goError(64L, "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97");
                    break;
                }
                case 12: {
                    Util.mod(leftval, ((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.mod(leftval, right.longValue(), result);
                    break;
                }
                case 15: {
                    left.mod((Variant)right.getValue(), result);
                    break;
                }
                default: {
                    ExprErr.goError(64L, "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97");
                }
            }
        }
    }

    @Override
    protected void and(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        long leftval = (Long)left.getValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.and(leftval, (long)((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.and(leftval, (long)rightval, result);
                    break;
                }
                case 9: {
                    result.setObject(BigInteger.valueOf(leftval).and((BigInteger)right.getValue()), 9);
                    break;
                }
                case 10: {
                    result.setObject(BigInteger.valueOf(leftval).and(((BigDecimal)right.getValue()).toBigInteger()), 9);
                    break;
                }
                case 11: {
                    result.setObject(BigInteger.valueOf(leftval).and(new BigInteger((String)right.getValue())), 9);
                    break;
                }
                case 12: {
                    Util.and(leftval, ((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.and(leftval, right.longValue(), result);
                    break;
                }
                case 15: {
                    left.and((Variant)right.getValue(), result);
                    break;
                }
                default: {
                    ExprErr.goError(64L, "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97");
                }
            }
        }
    }

    @Override
    protected void or(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        long leftval = (Long)left.getValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.or(leftval, (long)((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.or(leftval, (long)rightval, result);
                    break;
                }
                case 9: {
                    result.setObject(BigInteger.valueOf(leftval).or((BigInteger)right.getValue()), 9);
                    break;
                }
                case 10: {
                    result.setObject(BigInteger.valueOf(leftval).or(((BigDecimal)right.getValue()).toBigInteger()), 9);
                    break;
                }
                case 11: {
                    result.setObject(BigInteger.valueOf(leftval).or(new BigInteger((String)right.getValue())), 9);
                    break;
                }
                case 12: {
                    Util.or(leftval, ((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.or(leftval, right.longValue(), result);
                    break;
                }
                case 15: {
                    left.or((Variant)right.getValue(), result);
                    break;
                }
                default: {
                    ExprErr.goError(64L, "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97");
                }
            }
        }
    }

    @Override
    protected void xor(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        long leftval = (Long)left.getValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.xor(leftval, (long)((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.xor(leftval, (long)rightval, result);
                    break;
                }
                case 9: {
                    result.setObject(BigInteger.valueOf(leftval).xor((BigInteger)right.getValue()), 9);
                    break;
                }
                case 10: {
                    result.setObject(BigInteger.valueOf(leftval).xor(((BigDecimal)right.getValue()).toBigInteger()), 9);
                    break;
                }
                case 11: {
                    result.setObject(BigInteger.valueOf(leftval).xor(new BigInteger((String)right.getValue())), 9);
                    break;
                }
                case 12: {
                    Util.xor(leftval, ((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.xor(leftval, right.longValue(), result);
                    break;
                }
                case 15: {
                    left.xor((Variant)right.getValue(), result);
                    break;
                }
                default: {
                    ExprErr.goError(64L, "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97");
                }
            }
        }
    }
}

