/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.expr;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.expr.Macro;
import com.kingdee.bos.ctrl.kdf.expr.RelationKey;
import com.kingdee.bos.ctrl.kdf.expr.Variant;

public class RelationNode {
    private static long NEED_RECALCULATE = 1L;
    private static long CALCULATE_QUEUED = NEED_RECALCULATE << 1;
    private static long DELETED = CALCULATE_QUEUED << 1;
    private RelationKey key;
    private String formula;
    private Variant varValue;
    private long flags;

    public RelationNode(RelationKey key, String formula) {
        this.key = key;
        this.formula = StringUtil.isEmptyString(formula) ? "" : formula.trim();
        this.varValue = Variant.getNewEmptyVariant();
        this.flags = NEED_RECALCULATE;
    }

    public RelationKey getRelationKey() {
        return this.key;
    }

    protected void setRelationKey(RelationKey key) {
        this.key = key;
    }

    public String getFormula() {
        return this.formula;
    }

    public boolean setFormula(String formula) {
        String simpFormula = this.getSimpleFormula(formula);
        boolean changed = false;
        if (!StringUtil.isEmptyString(simpFormula)) {
            if (!StringUtil.equals(this.formula, simpFormula)) {
                changed = true;
            }
        } else if (!StringUtil.isEmptyString(this.formula)) {
            changed = true;
        }
        if (changed) {
            this.formula = simpFormula;
            this.setNeedCalculate(true);
            if (!this.key.getRelationsListener().formulaChanged(this.key, simpFormula)) {
                return false;
            }
        }
        return changed;
    }

    private String getSimpleFormula(String formula) {
        if (formula == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(formula);
        int pos = sb.indexOf("$VALUE");
        if (pos >= 0) {
            sb.replace(pos, pos + "$VALUE".length(), "");
            pos = sb.indexOf(";");
            if (pos >= 0) {
                sb.replace(pos, pos + 1, "");
            }
        }
        return sb.toString();
    }

    public Variant getData() {
        return this.varValue;
    }

    public void setData(Variant varValue) {
        this.varValue.setVariant(varValue);
    }

    public boolean isNeedCalculate() {
        return this.touchFlag(this.flags, NEED_RECALCULATE);
    }

    public void setNeedCalculate(boolean needCalculate) {
        this.flags = this.setFlag(this.flags, NEED_RECALCULATE, needCalculate);
    }

    public boolean isQueued() {
        return this.touchFlag(this.flags, CALCULATE_QUEUED);
    }

    public void setQueued(boolean calculateQueued) {
        this.flags = this.setFlag(this.flags, CALCULATE_QUEUED, calculateQueued);
    }

    public boolean isDeleted() {
        return this.touchFlag(this.flags, DELETED);
    }

    public void setDeleted(boolean delete) {
        this.flags = this.setFlag(this.flags, DELETED, delete);
    }

    public void firePreIntepretedEvent() {
        this.key.getRelationsListener().preIntepreted(this.key);
    }

    public void fireIntepretedCompleteEvent(boolean succeed, Macro m) {
        this.key.getRelationsListener().intepretedComplete(succeed, this.key, m);
        if (succeed) {
            this.varValue.setVariant(m.getVariableValue("$VALUE"));
        } else {
            this.varValue.setObject(m.getSyntaxError(), 17);
        }
    }

    private boolean touchFlag(long flags, long flag) {
        return (flags & flag) != 0L;
    }

    private long setFlag(long flags, long flag, boolean bSet) {
        flags = bSet ? (flags |= flag) : (flags &= flag ^ 0xFFFFFFFFFFFFFFFFL);
        return flags;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RelationNode) {
            RelationNode n = (RelationNode)obj;
            return this.key.equals(n.getRelationKey()) && StringUtil.equals(this.formula, n.getFormula());
        }
        return false;
    }
}

