/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.console;

import com.kingdee.bos.ctrl.common.ui.TreeView;
import com.kingdee.bos.ctrl.common.ui.console.AbstractConsoleAction;
import com.kingdee.bos.ctrl.common.ui.console.IConsoleExtEvent;
import com.kingdee.bos.ctrl.common.ui.console.IConsoleFrame;
import com.kingdee.bos.ctrl.common.ui.console.content.DefaultBranchContent;
import com.kingdee.bos.ctrl.common.ui.console.content.DefaultLeafContent;
import com.kingdee.bos.ctrl.common.ui.console.content.IBranchContent;
import com.kingdee.bos.ctrl.common.ui.console.content.IConsoleContent;
import com.kingdee.bos.ctrl.common.ui.console.content.ILeafContent;
import com.kingdee.bos.ctrl.common.ui.console.event.BranchEvent;
import com.kingdee.bos.ctrl.common.ui.console.event.BranchListener;
import com.kingdee.bos.ctrl.common.ui.console.event.ContentChangeEvent;
import com.kingdee.bos.ctrl.common.ui.console.event.ContentChangeListener;
import com.kingdee.bos.ctrl.common.ui.console.event.ContentInitEvent;
import com.kingdee.bos.ctrl.common.ui.console.event.ContentInitListener;
import com.kingdee.bos.ctrl.common.ui.console.menuelement.IMenuElement;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ConsolePane
extends KDPanel {
    private static final long serialVersionUID = 1429738847057326516L;
    private TreeView trv;
    private KDTree treConsole;
    private KDPanel panContent;
    private IBranchContent defaultBranchContent;
    private IConsoleContent systemContent;
    private KDSplitPane spl;
    private IConsoleFrame owner;
    private IConsoleExtEvent extEvent = new DefaultExtEvent();
    private boolean isSysMenuInstalled = false;

    public ConsolePane() {
        this.installComponent();
        this.installListener();
    }

    private void installComponent() {
        this.defaultBranchContent = this.createBranchContentInstance();
        this.initConsoleTree();
        this.trv = new TreeView(this.treConsole);
        this.panContent = new KDPanel((LayoutManager)new BorderLayout());
        this.spl = new KDSplitPane();
        this.spl.setLeftComponent((Component)((Object)this.trv));
        this.spl.setRightComponent((Component)this.panContent);
        this.setLayout(new BorderLayout());
        this.add((Component)this.spl, "Center");
    }

    public void setDividerLocation(int dl) {
        if (this.spl != null) {
            this.spl.setDividerLocation(dl);
        }
    }

    private void installListener() {
        this.treConsole.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ConsolePane.this.changeContent(e.getOldLeadSelectionPath(), e.getNewLeadSelectionPath());
            }
        });
        this.treConsole.addTreePopupMenu(new TreePopupMenuListener(){

            public boolean popMenu(TreePopupMenuEvent e) {
                return e.getClosestPath() != null && e.getClosestPath().equals(ConsolePane.this.treConsole.getSelectionPath()) && ConsolePane.this.treConsole.getPopupMenu().getComponentCount() > 0;
            }
        });
    }

    private void changeContent(TreePath oldPath, TreePath newPath) {
        IConsoleContent content;
        DefaultKingdeeTreeNode node;
        if (!this.isSysMenuInstalled) {
            this.installMenu(this.getOwner().getJMenuBar(), this.getSystemContent().getMenuBarList());
            this.installMenu((JComponent)this.getOwner().getToolBar(), this.getSystemContent().getToolBarList());
            this.installMenu(this.treConsole.getPopupMenu(), this.getSystemContent().getPopMenuList());
            this.isSysMenuInstalled = true;
        }
        this.panContent.removeAll();
        if (oldPath != null) {
            node = (DefaultKingdeeTreeNode)oldPath.getLastPathComponent();
            content = (IConsoleContent)node.getUserObject();
            this.removeMenu(this.getOwner().getJMenuBar(), content.getMenuBarList());
            this.removeMenu((JComponent)this.getOwner().getToolBar(), content.getToolBarList());
            this.removeMenu(this.treConsole.getPopupMenu(), content.getPopMenuList());
            this.fireContentChangeListener(new ContentChangeEvent(content, 0));
        }
        if (newPath == null) {
            return;
        }
        node = (DefaultKingdeeTreeNode)newPath.getLastPathComponent();
        content = (IConsoleContent)node.getUserObject();
        if (content instanceof IBranchContent) {
            ((IBranchContent)content).setBranchNode(node);
        }
        content.installCtrl((JPanel)this.panContent);
        this.installMenu(this.getOwner().getJMenuBar(), content.getMenuBarList());
        this.installMenu((JComponent)this.getOwner().getToolBar(), content.getToolBarList());
        this.installMenu(this.treConsole.getPopupMenu(), content.getPopMenuList());
        this.fireContentChangeListener(new ContentChangeEvent(content, 1));
        this.getOwner().validate();
        this.getOwner().repaint();
    }

    private void initConsoleTree() {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"root");
        root.setUserObject((Object)this.defaultBranchContent);
        this.treConsole = new KDTree((ITreeNode)root, false, true);
        this.treConsole.getSelectionModel().setSelectionMode(1);
        this.treConsole.setShowPopMenuDefaultItem(false);
        this.treConsole.setShowsRootHandles(true);
    }

    private void installMenu(JComponent sys, List cstm) {
        if (cstm == null || sys == null) {
            return;
        }
        for (int i = 0; i < cstm.size(); ++i) {
            IMenuElement item = (IMenuElement)cstm.get(i);
            int idx = item.getInsertIndex();
            if (idx == 0 || idx > sys.getComponentCount()) {
                sys.add((JComponent)((Object)item));
            } else {
                if (!(sys instanceof KDToolBar)) {
                    --idx;
                }
                sys.add((Component)((JComponent)((Object)item)), idx);
            }
            if (!(item.getAction() instanceof AbstractConsoleAction)) continue;
            ((AbstractConsoleAction)item.getAction()).verifyEnabled();
        }
    }

    private void removeMenu(JComponent sys, List cstm) {
        if (cstm == null || sys == null) {
            return;
        }
        for (int i = 0; i < cstm.size(); ++i) {
            sys.remove((JComponent)cstm.get(i));
        }
    }

    public void removeNode(DefaultKingdeeTreeNode node) {
        if (node == null) {
            return;
        }
        DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)node.getParent();
        this.treConsole.removeNodeFromParent((MutableTreeNode)node);
        if (parentNode != null && parentNode != this.treConsole.getModel().getRoot()) {
            this.treConsole.setSelectionNode(parentNode);
        }
    }

    private void addNode(DefaultKingdeeTreeNode parentNode, DefaultKingdeeTreeNode childNode) {
        DefaultKingdeeTreeNode parent = parentNode;
        if (parentNode == null) {
            parent = (DefaultKingdeeTreeNode)this.treConsole.getModel().getRoot();
        }
        if (!(parent.getUserObject() instanceof IBranchContent)) {
            throw new Error("parentNode.getUserObject() must be " + IBranchContent.class);
        }
        this.treConsole.addNodeInto((MutableTreeNode)childNode, (MutableTreeNode)parent);
    }

    private DefaultKingdeeTreeNode createTreeNode(IConsoleContent userObj, String text, ImageIcon icon) {
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)userObj);
        if (!StringUtil.isEmptyString((String)text)) {
            node.setText(text);
        }
        if (icon != null) {
            node.setCustomIcon((Icon)icon);
        }
        return node;
    }

    public void setRootNodeShow(boolean isShow) {
        this.treConsole.setRootVisible(isShow);
    }

    public DefaultKingdeeTreeNode setRootNode(IBranchContent branch, String text, ImageIcon icon) {
        if (branch == null) {
            branch = this.defaultBranchContent;
        }
        branch.setRootCtrl((JComponent)this.panContent);
        this.fireContentInitListener(new ContentInitEvent(branch));
        DefaultKingdeeTreeNode root = this.createTreeNode(branch, text, icon);
        this.treConsole.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root, true));
        return root;
    }

    public DefaultKingdeeTreeNode addBranch(DefaultKingdeeTreeNode parentNode, IBranchContent userObj, String text, ImageIcon icon) {
        IBranchContent content = userObj;
        if (userObj == null) {
            content = this.defaultBranchContent;
        }
        content.setRootCtrl((JComponent)this.panContent);
        this.fireContentInitListener(new ContentInitEvent(content));
        DefaultKingdeeTreeNode node = this.createTreeNode(content, text, icon);
        this.addNode(parentNode, node);
        return node;
    }

    public DefaultKingdeeTreeNode addLeaf(DefaultKingdeeTreeNode parentNode, ILeafContent userObj, String text, ImageIcon icon) {
        ILeafContent content = userObj;
        if (userObj == null) {
            content = this.createLeafContentInstance();
        }
        content.setRootCtrl((JComponent)this.panContent);
        this.fireContentInitListener(new ContentInitEvent(content));
        DefaultKingdeeTreeNode node = this.createTreeNode(content, text, icon);
        node.setAllowsChildren(false);
        this.addNode(parentNode, node);
        return node;
    }

    public void validateConsoleTree() {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treConsole.getModel().getRoot();
        if (this.treConsole.isRootVisible()) {
            this.treConsole.setSelectionNode(root);
            this.treConsole.expandPath(new TreePath(root.getPath()));
        } else {
            if (root.getChildCount() > 0) {
                this.treConsole.setSelectionNode((DefaultKingdeeTreeNode)root.getChildAt(0));
            }
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.treConsole.expandPath(new TreePath(((DefaultKingdeeTreeNode)root.getChildAt(i)).getPath()));
            }
        }
    }

    private ILeafContent createLeafContentInstance() {
        return new DefaultLeafContent("Welcome to Along's program!");
    }

    public IConsoleContent getSystemContent() {
        if (this.systemContent == null) {
            this.systemContent = this.createLeafContentInstance();
            this.systemContent.setRootCtrl((JComponent)((Object)this));
        }
        return this.systemContent;
    }

    public KDTree getConsoleTree() {
        return this.treConsole;
    }

    public void setTreeViewTitle(String title) {
        this.trv.setTitle(title);
    }

    public IBranchContent createBranchContentInstance() {
        DefaultBranchContent branchContent = new DefaultBranchContent();
        branchContent.addBranchListener(new BranchListener(){

            @Override
            public void doubleClickedItem(BranchEvent e) {
                ConsolePane.this.treConsole.setSelectionNode(e.getClickedNode());
            }
        });
        return branchContent;
    }

    public void setOwner(IConsoleFrame owner) {
        this.owner = owner;
    }

    public IConsoleFrame getOwner() {
        if (this.owner == null) {
            this.owner = this.createDefaultOwner();
        }
        return this.owner;
    }

    public void showFrame() {
        this.getOwner().show();
    }

    private IConsoleFrame createDefaultOwner() {
        DefaultConsoleFrame frame = new DefaultConsoleFrame();
        frame.setSize(800, 600);
        frame.setExtendedState(6);
        frame.setLocationRelativeTo(null);
        this.setCustomInsets(new Insets(8, 8, 8, 8));
        frame.getContentPane().add((Component)((Object)this));
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ConsolePane.this.extEvent.doExit()) {
                    System.exit(0);
                }
            }
        });
        return frame;
    }

    public void setExtEvent(IConsoleExtEvent ee) {
        this.extEvent = ee;
    }

    public void addContentChangeListener(ContentChangeListener l) {
        this.listenerList.add(ContentChangeListener.class, l);
    }

    public void removeContentChangeListener(ContentChangeListener l) {
        this.listenerList.remove(ContentChangeListener.class, l);
    }

    protected void fireContentChangeListener(ContentChangeEvent e) {
        if (e == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int len = listeners != null ? listeners.length : 0;
        for (int i = len - 2; i >= 0; i -= 2) {
            if (listeners[i] != ContentChangeListener.class) continue;
            if (e.getOprtType() == 1) {
                ((ContentChangeListener)listeners[i + 1]).contentAdd(e);
                continue;
            }
            if (e.getOprtType() != 0) continue;
            ((ContentChangeListener)listeners[i + 1]).contentRemove(e);
        }
    }

    public void addContentInitListener(ContentInitListener l) {
        this.listenerList.add(ContentInitListener.class, l);
    }

    public void removeContentInitListener(ContentInitListener l) {
        this.listenerList.remove(ContentInitListener.class, l);
    }

    protected void fireContentInitListener(ContentInitEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ContentInitListener.class) continue;
            ((ContentInitListener)listeners[i + 1]).init(evt);
        }
    }

    private class DefaultExtEvent
    implements IConsoleExtEvent {
        private DefaultExtEvent() {
        }

        @Override
        public boolean doExit() {
            return true;
        }
    }

    private class DefaultConsoleFrame
    extends KDFrame
    implements IConsoleFrame {
        private static final long serialVersionUID = -871819477231509418L;
        private KDToolBar toolbar;

        public DefaultConsoleFrame() {
            this.initMenuBar();
        }

        private void initMenuBar() {
            KDMenuBar mb = new KDMenuBar();
            mb.hideLogo();
            mb.setPreferredSize(new Dimension(100, 26));
            this.setJMenuBar((JMenuBar)mb);
        }

        @Override
        public KDToolBar getToolBar() {
            if (this.toolbar == null) {
                this.toolbar = new KDToolBar();
                this.addToolBar((JToolBar)this.toolbar);
            }
            return this.toolbar;
        }
    }
}

