/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.horizontaltree;

import com.kingdee.bos.ctrl.common.ui.horizontaltree.DefaultHorizontalTreeView;
import com.kingdee.bos.ctrl.common.ui.horizontaltree.HorizontalTreeModel;
import com.kingdee.bos.ctrl.common.ui.horizontaltree.IHorizontalTreeCustomView;
import com.kingdee.bos.ctrl.common.ui.horizontaltree.IHorizontalTreeNode;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class HorizontalTree {
    static String KEY_EDGES = "system.horizontaltree.render.edges";
    static String KEY_RECTANGLE = "system.horizontaltree.render.rectangle";
    private HorizontalTreeModel _model;
    private Ctrl _ctrl;
    private IHorizontalTreeCustomView _customView;
    private List _levelHeights;
    private boolean _isDirty;
    private boolean _isAdjustBarycenter = true;
    private boolean _isDynamicLayout = true;

    public JComponent getCtrl() {
        return this._ctrl;
    }

    public HorizontalTree(HorizontalTreeModel model) {
        this.setModel(model);
        this._ctrl = new Ctrl();
    }

    public void setModel(HorizontalTreeModel model) {
        this._model = model;
        this._isDirty = true;
    }

    public HorizontalTreeModel getModel() {
        return this._model;
    }

    public void setCustomView(IHorizontalTreeCustomView customView) {
        this._customView = customView;
        this._customView.setHorizontalTree(this);
        this._isDirty = true;
    }

    public IHorizontalTreeCustomView getCustomView() {
        if (this._customView == null) {
            this.setCustomView(new DefaultHorizontalTreeView());
        }
        return this._customView;
    }

    public void setAdjustBarycenter(boolean isAdjustBarycenter) {
        this._isAdjustBarycenter = isAdjustBarycenter;
    }

    public void setDynamicLayout(boolean isDynamicLayout) {
        this._isDynamicLayout = isDynamicLayout;
    }

    public Dimension confirmNodesPosition() {
        return this.confirmNodesPosition(0, 0);
    }

    public Dimension confirmNodesPosition(int offsetX, int offsetY) {
        this._isDirty = false;
        IHorizontalTreeNode root = this.getModel().getRoot();
        this._levelHeights = this.confirmRelativePosition(root);
        Rectangle rootRect = (Rectangle)root.getExtProperty(KEY_RECTANGLE);
        this._levelHeights.add(0, new Integer(rootRect.height));
        Edges edges = (Edges)root.getExtProperty(KEY_EDGES);
        if (this._isAdjustBarycenter) {
            this.adjustBarycenter(root, edges);
        }
        int minusPos = 0;
        int maxRight = 0;
        int minLeft = Integer.MAX_VALUE;
        for (int i = 0; i < edges.physicalDepth(); ++i) {
            Edge edge = edges.get(i);
            if (minusPos > edge.getLeft()) {
                minusPos = edge.getLeft();
            }
            if (maxRight < edge.getRight()) {
                maxRight = edge.getRight();
            }
            if (minLeft <= edge.getLeft()) continue;
            minLeft = edge.getLeft();
        }
        if (minusPos == 0 && minLeft != Integer.MAX_VALUE) {
            minusPos = minLeft;
        }
        minusPos = -minusPos;
        edges.move(minusPos);
        rootRect.x = edges.get(0).getLeft() + offsetX;
        rootRect.y = 0 + offsetY;
        int yEnd = this.updateChildrenPosition(root, minusPos + offsetX, rootRect.y, 0, this._levelHeights);
        return new Dimension(offsetX + (maxRight += minusPos) + this.getCustomView().getCousinGap(), yEnd);
    }

    private void adjustBarycenter(IHorizontalTreeNode root, Edges edges) {
        Edge edge;
        int middle = edges.get(0).getMiddle();
        int c = edges.physicalDepth();
        for (int i = 1; i < c && ((edge = edges.get(i)).getNegativeMovable() != 0 || edge.getPositiveMovable() != 0); ++i) {
            int leftMoment = middle - edge.getLeft();
            int rightMoment = edge.getRight() - middle;
            int wantMoveEdge = ((leftMoment = leftMoment < 0 ? 0 : leftMoment) - (rightMoment = rightMoment < 0 ? 0 : rightMoment)) / 2;
            if (wantMoveEdge == 0) continue;
            if (wantMoveEdge < -edge.getNegativeMovable()) {
                wantMoveEdge = -edge.getNegativeMovable();
            } else if (wantMoveEdge > edge.getPositiveMovable()) {
                wantMoveEdge = edge.getPositiveMovable();
            }
            for (int j = i; j < c; ++j) {
                Edge tempEdge = edges.get(j);
                tempEdge.move(wantMoveEdge);
                if (j != i) continue;
                tempEdge.setNegativeMovable(tempEdge.getNegativeMovable() + wantMoveEdge);
                tempEdge.setPositiveMovable(tempEdge.getPositiveMovable() - wantMoveEdge);
            }
            this.movingEdgeFromAppointDeep(root, wantMoveEdge, i, 0);
        }
    }

    private void movingEdgeFromAppointDeep(IHorizontalTreeNode node, int xMoving, int startFromLevel, int level) {
        if (level >= startFromLevel) {
            Edges edges = (Edges)node.getExtProperty(KEY_EDGES);
            edges.move(xMoving);
        }
        if (!node.isLeaf() && !this.isAsLeaf(node)) {
            ++level;
            int c = node.getChildCount() - 1;
            for (int i = 0; i <= c; ++i) {
                IHorizontalTreeNode child = node.getChild(i);
                this.movingEdgeFromAppointDeep(child, xMoving, startFromLevel, level);
            }
        }
    }

    private List confirmRelativePosition(IHorizontalTreeNode node) {
        ArrayList levelHeights = new ArrayList();
        Dimension dim = this.getCustomView().calculateNodeSize(node);
        int width = dim.width;
        int height = dim.height;
        node.setExtProperty(KEY_EDGES, null);
        node.setExtProperty(KEY_RECTANGLE, new Rectangle(0, 0, width, height));
        if (node.isLeaf() || this.isAsLeaf(node)) {
            node.setExtProperty(KEY_EDGES, new Edges(0, width));
        } else if (node.isWithBeanpodChildren()) {
            Edges edges = new Edges(0, width);
            int maxWidth = this.confirmBeanpod(node);
            edges.add(new Edge(0, maxWidth));
            edges.setUnlimited(true);
            node.setExtProperty(KEY_EDGES, edges);
        } else {
            int lineLeft = 0;
            int lineRight = 0;
            Edges mergedEdges = null;
            int maxSonHeight = 0;
            List<Integer> mergedDescendantLevelHeights = new ArrayList<Integer>();
            int c = node.getChildCount() - 1;
            for (int i = 0; i <= c; ++i) {
                IHorizontalTreeNode child = node.getChild(i);
                List descendantLevelHeights = this.confirmRelativePosition(child);
                mergedDescendantLevelHeights = this.mergeDescendantLevelHeights(mergedDescendantLevelHeights, descendantLevelHeights);
                int sonHeight = ((Rectangle)child.getExtProperty((Object)HorizontalTree.KEY_RECTANGLE)).height;
                if (maxSonHeight < sonHeight) {
                    maxSonHeight = sonHeight;
                }
                Edges edges = (Edges)child.getExtProperty(KEY_EDGES);
                if (mergedEdges == null) {
                    mergedEdges = new Edges(edges);
                } else {
                    int moving = edges.tryMergeTo(mergedEdges, this.getCustomView().getSiblingGap(), this.getCustomView().getCousinGap());
                    mergedEdges = Edges.merge(mergedEdges, edges);
                    if (moving != 0) {
                        this.updateChildrenEdges(child, moving);
                    }
                }
                if (i == 0) {
                    Edge edge = edges.get(0);
                    lineLeft = edge.getMiddle();
                }
                if (i != c) continue;
                Edge edge = edges.get(0);
                lineRight = edge.getMiddle();
            }
            mergedDescendantLevelHeights.add(0, new Integer(maxSonHeight));
            levelHeights = mergedDescendantLevelHeights;
            int halfLineLen = (lineRight - lineLeft) / 2;
            int middlePos = lineLeft + halfLineLen;
            int x = middlePos - width / 2;
            mergedEdges.insert(new Edge(x, x + width));
            int movable = (int)((double)halfLineLen * 0.8);
            mergedEdges.get(1).setNegativeMovable(movable);
            mergedEdges.get(1).setPositiveMovable(movable);
            node.setExtProperty(KEY_EDGES, mergedEdges);
        }
        return levelHeights;
    }

    private int confirmBeanpod(IHorizontalTreeNode vParent) {
        int childX = this.getCustomView().getBeanpodBusWidth();
        int maxWidth = 0;
        for (int i = 0; i < vParent.getChildCount(); ++i) {
            IHorizontalTreeNode vChild = vParent.getChild(i);
            Dimension dim = this.getCustomView().calculateNodeSize(vChild);
            int width = dim.width;
            int height = dim.height;
            vChild.setExtProperty(KEY_EDGES, new Edges(0, childX + width));
            vChild.setExtProperty(KEY_RECTANGLE, new Rectangle(0, 0, width, height));
            if (maxWidth >= width) continue;
            maxWidth = width;
        }
        return maxWidth + childX;
    }

    private List mergeDescendantLevelHeights(List l1, List l2) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int size = Math.max(l1.size(), l2.size());
        for (int i = 0; i < size; ++i) {
            int h1 = i < l1.size() ? (Integer)l1.get(i) : 0;
            int h2 = i < l2.size() ? (Integer)l2.get(i) : 0;
            result.add(new Integer(Math.max(h1, h2)));
        }
        return result;
    }

    private void updateChildrenEdges(IHorizontalTreeNode node, int moving) {
        this.updateChildrenPosition(node, moving, 0, -1, null);
    }

    private int updateChildrenPosition(IHorizontalTreeNode node, int moving, int y, int level, List levelHeights) {
        int yEnd = -1;
        if (!node.isLeaf() && !this.isAsLeaf(node)) {
            boolean isOnlyEdges;
            boolean bl = isOnlyEdges = levelHeights == null;
            if (!isOnlyEdges) {
                int levelHeight = (Integer)levelHeights.get(level);
                y = node.isWithBeanpodChildren() ? (y += levelHeight + this.getCustomView().getBeanpodSiblingGap() * 2) : (y += levelHeight + this.getCustomView().getLevelDistance());
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                IHorizontalTreeNode child = node.getChild(i);
                Edges edges = (Edges)child.getExtProperty(KEY_EDGES);
                edges.move(moving);
                if (node.isWithBeanpodChildren()) {
                    int currentYEnd;
                    if (isOnlyEdges || (currentYEnd = this.updateBeanpodChildrenPosition(node, edges.get(0).getLeft(), y)) <= yEnd) continue;
                    yEnd = currentYEnd;
                    continue;
                }
                Rectangle rect = null;
                if (!isOnlyEdges) {
                    rect = (Rectangle)child.getExtProperty(KEY_RECTANGLE);
                    Edge edge = edges.get(0);
                    rect.x = edge.getLeft();
                    rect.y = y;
                }
                int currentYEnd = this.updateChildrenPosition(child, moving, y, level + 1, levelHeights);
                if (isOnlyEdges) continue;
                if (currentYEnd < 0) {
                    currentYEnd = y + rect.height;
                }
                if (currentYEnd <= yEnd) continue;
                yEnd = currentYEnd;
            }
        }
        return yEnd;
    }

    private int updateBeanpodChildrenPosition(IHorizontalTreeNode vParent, int x, int y) {
        int childX = x + this.getCustomView().getBeanpodBusWidth();
        int childY = y;
        for (int i = 0; i < vParent.getChildCount(); ++i) {
            IHorizontalTreeNode vChild = vParent.getChild(i);
            Rectangle rect = (Rectangle)vChild.getExtProperty(KEY_RECTANGLE);
            rect.x = childX;
            rect.y = childY;
            int height = rect.height;
            childY += height + this.getCustomView().getBeanpodSiblingGap();
        }
        return childY;
    }

    public void addCtrl() {
        if (this._isDirty) {
            this.confirmNodesPosition();
        }
        this._ctrl.removeAll();
        IHorizontalTreeNode root = this.getModel().getRoot();
        this.addCtrlRecursion((Container)((Object)this._ctrl), root);
    }

    private void addCtrlRecursion(Container parentCtrl, IHorizontalTreeNode node) {
        Rectangle rect = (Rectangle)node.getExtProperty(KEY_RECTANGLE);
        int x = rect.x;
        int y = rect.y;
        int width = rect.width;
        int height = rect.height;
        this.getCustomView().addCtrl(parentCtrl, node, x, y, width, height);
        if (node.isAllowsExpand() && !node.isExpanded()) {
            return;
        }
        if (!node.isLeaf()) {
            int c = node.getChildCount() - 1;
            for (int i = 0; i <= c; ++i) {
                IHorizontalTreeNode child = node.getChild(i);
                this.addCtrlRecursion(parentCtrl, child);
            }
        }
    }

    private boolean isAsLeaf(IHorizontalTreeNode node) {
        return this._isDynamicLayout && node.isAllowsExpand() && !node.isExpanded();
    }

    private static class Edge {
        private int _left;
        private int _right;
        private int _negativeMovable;
        private int _positiveMovable;

        public Edge(int left, int right) {
            this._left = left;
            this._right = right;
        }

        public Edge(Edge edge) {
            this(edge.getLeft(), edge.getRight());
            this.setNegativeMovable(edge.getNegativeMovable());
            this.setPositiveMovable(edge.getPositiveMovable());
        }

        public int getLeft() {
            return this._left;
        }

        public int getRight() {
            return this._right;
        }

        public int getMiddle() {
            return this._left + (this._right - this._left) / 2;
        }

        public int getWidth() {
            return this._right - this._left;
        }

        public void move(int delta) {
            this._left += delta;
            this._right += delta;
        }

        public int getPositiveMovable() {
            return this._positiveMovable;
        }

        public void setPositiveMovable(int positiveMovable) {
            this._positiveMovable = positiveMovable;
        }

        public int getNegativeMovable() {
            return this._negativeMovable;
        }

        public void setNegativeMovable(int negativeMovable) {
            this._negativeMovable = negativeMovable;
        }

        public static Edge merge(Edge a, Edge b) {
            int left1 = Integer.MAX_VALUE;
            int right1 = Integer.MIN_VALUE;
            int nm1 = Integer.MAX_VALUE;
            int pm1 = Integer.MAX_VALUE;
            if (a != null) {
                left1 = a.getLeft();
                right1 = a.getRight();
                nm1 = a.getNegativeMovable();
                pm1 = a.getPositiveMovable();
            }
            int left2 = Integer.MAX_VALUE;
            int right2 = Integer.MIN_VALUE;
            int nm2 = Integer.MAX_VALUE;
            int pm2 = Integer.MAX_VALUE;
            if (b != null) {
                left2 = b.getLeft();
                right2 = b.getRight();
                nm2 = b.getNegativeMovable();
                pm2 = b.getPositiveMovable();
            }
            Edge result = new Edge(Math.min(left1, left2), Math.max(right1, right2));
            result.setNegativeMovable(Math.min(nm1, nm2));
            result.setPositiveMovable(Math.min(pm1, pm2));
            return result;
        }

        public int getSuperposition(Edge another) {
            return another.getLeft() - this._right;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("(");
            sb.append(this._left);
            sb.append(",");
            sb.append(this._right);
            sb.append("; \u2190");
            sb.append(this._negativeMovable);
            sb.append(",\u2192");
            sb.append(this._positiveMovable);
            sb.append(")");
            return sb.toString();
        }
    }

    private static class Edges {
        private List _listEdges = new ArrayList();
        private boolean _isUnlimited;

        private Edges() {
        }

        public Edges(int left, int right) {
            this.add(new Edge(left, right));
        }

        public Edges(Edges edges) {
            this.setUnlimited(edges.isUnlimited());
            for (int i = 0; i < edges.physicalDepth(); ++i) {
                this.add(new Edge(edges.get(i)));
            }
        }

        public static Edges merge(Edges x, Edges y) {
            Edges result = new Edges();
            result.setUnlimited(x.isUnlimited() || y.isUnlimited());
            int depth = Math.max(x.logicDepth(), y.logicDepth());
            for (int i = 0; i < depth; ++i) {
                Edge a;
                if (i >= x.physicalDepth() && i >= y.physicalDepth()) {
                    if (x.physicalDepth() != y.physicalDepth()) break;
                    if (x.isUnlimited() && !y.isUnlimited()) {
                        result.add(new Edge(x.get(i)));
                        break;
                    }
                    if (x.isUnlimited() || !y.isUnlimited()) break;
                    result.add(new Edge(y.get(i)));
                    break;
                }
                if (x.isUnlimited()) {
                    a = x.get(i);
                } else {
                    Edge edge = a = i >= x.physicalDepth() ? null : x.get(i);
                }
                Edge b = y.isUnlimited() ? y.get(i) : (i >= y.physicalDepth() ? null : y.get(i));
                Edge added = Edge.merge(a, b);
                result.add(added);
            }
            return result;
        }

        public int tryMergeTo(Edges x, int siblingGap, int sousinGap) {
            int tryLeft = x.get(0).getRight() + siblingGap;
            int tryMoving = tryLeft - this.get(0).getLeft();
            this.move(tryMoving);
            int minSuperposition = 0;
            for (int i = 1; i < x.logicDepth() && (i < this.physicalDepth() || this.isUnlimited() && i < x.physicalDepth()); ++i) {
                Edge b;
                Edge a = x.get(i);
                int superposition = a.getSuperposition(b = this.get(i)) - sousinGap;
                if (minSuperposition <= superposition) continue;
                minSuperposition = superposition;
            }
            if (minSuperposition < 0) {
                minSuperposition = -minSuperposition;
                this.move(minSuperposition);
            }
            return tryMoving + minSuperposition;
        }

        public void move(int delta) {
            for (int i = 0; i < this.physicalDepth(); ++i) {
                this.get(i).move(delta);
            }
        }

        public void add(Edge edge) {
            this._listEdges.add(edge);
        }

        public void insert(Edge edge) {
            this._listEdges.add(0, edge);
        }

        public Edge get(int idx) {
            if (this.isUnlimited() && idx >= this.physicalDepth()) {
                return (Edge)this._listEdges.get(this.physicalDepth() - 1);
            }
            return (Edge)this._listEdges.get(idx);
        }

        public int physicalDepth() {
            return this._listEdges.size();
        }

        public int logicDepth() {
            if (this.isUnlimited()) {
                return Integer.MAX_VALUE;
            }
            return this.physicalDepth();
        }

        public void setUnlimited(boolean isUnlimited) {
            this._isUnlimited = isUnlimited;
        }

        public boolean isUnlimited() {
            return this._isUnlimited;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("{");
            for (int i = 0; i < this._listEdges.size(); ++i) {
                sb.append(this.get(i).toString());
            }
            if (this.isUnlimited()) {
                sb.append("~");
            }
            sb.append("}");
            return sb.toString();
        }
    }

    private class Ctrl
    extends KDPanel {
        private static final long serialVersionUID = -8827802902779010972L;

        public Ctrl() {
            this.setLayout(null);
        }

        public void paint(Graphics g) {
            if (HorizontalTree.this._isDirty) {
                HorizontalTree.this.confirmNodesPosition();
            }
            super.paint(g);
            this.paintTree(g);
            this.paintSelection(g);
        }

        private void paintTree(Graphics g) {
            this.paintNodeRecursion(g, HorizontalTree.this._model.getRoot(), 0, HorizontalTree.this._levelHeights);
        }

        private void paintNodeRecursion(Graphics g, IHorizontalTreeNode node, int level, List levelHeights) {
            Rectangle rect = (Rectangle)node.getExtProperty(KEY_RECTANGLE);
            int x = rect.x;
            int y = rect.y;
            int width = rect.width;
            int height = rect.height;
            int middle = x + width / 2;
            if (level > 0) {
                HorizontalTree.this.getCustomView().drawPreceding(g, node, middle, y);
            }
            HorizontalTree.this.getCustomView().drawNode(g, node, x, y, width, height);
            if (node.isAllowsExpand() && !node.isExpanded()) {
                return;
            }
            if (node.isWithBeanpodChildren()) {
                int yParentAss = y + height;
                this.paintBeanpodChildren(g, node, x, yParentAss);
            } else if (!node.isLeaf()) {
                int nodeAssY = y + height;
                int yChild = y + (Integer)levelHeights.get(level) + HorizontalTree.this.getCustomView().getLevelDistance();
                int lineLeft = 0;
                int lineRight = 0;
                Edge lastEdge = null;
                int childHeight = (Integer)levelHeights.get(level + 1);
                int c = node.getChildCount();
                for (int i = 0; i <= c; ++i) {
                    Edge childEdge = null;
                    if (i < c) {
                        IHorizontalTreeNode child = node.getChild(i);
                        this.paintNodeRecursion(g, child, level + 1, levelHeights);
                        childEdge = ((Edges)child.getExtProperty(KEY_EDGES)).get(0);
                    }
                    int xRelation = lastEdge == null ? childEdge.getLeft() - HorizontalTree.this.getCustomView().getSiblingGap() : lastEdge.getRight();
                    int wRelation = childEdge == null ? HorizontalTree.this.getCustomView().getSiblingGap() : childEdge.getLeft() - xRelation;
                    HorizontalTree.this.getCustomView().drawRelation(g, node.getChildrenRelation(i), xRelation, yChild, wRelation, childHeight);
                    lastEdge = childEdge;
                    if (i == 0) {
                        lineLeft = childEdge.getMiddle();
                    }
                    if (i != c - 1) continue;
                    lineRight = childEdge.getMiddle();
                }
                HorizontalTree.this.getCustomView().drawFollowing(g, node, lineLeft, lineRight, middle, nodeAssY, yChild);
            }
        }

        private void paintBeanpodChildren(Graphics g, IHorizontalTreeNode vParent, int x, int yParentAss) {
            int childMidY = 0;
            int[] xBeans = new int[vParent.getChildCount()];
            int[] yBeans = new int[vParent.getChildCount()];
            for (int i = 0; i < vParent.getChildCount(); ++i) {
                IHorizontalTreeNode vChild = vParent.getChild(i);
                Rectangle rect = (Rectangle)vChild.getExtProperty(KEY_RECTANGLE);
                int childX = rect.x;
                int childY = rect.y;
                int childHeight = rect.height;
                int childWidth = rect.width;
                HorizontalTree.this.getCustomView().drawNode(g, vChild, childX, childY, childWidth, childHeight);
                childMidY = childY + childHeight / 2;
                xBeans[i] = childX;
                yBeans[i] = childMidY;
            }
            int busX = x + HorizontalTree.this.getCustomView().getBeanpodBusWidth() / 2;
            HorizontalTree.this.getCustomView().drawBeanpodBus(g, vParent, busX, yParentAss, xBeans, yBeans);
        }

        private void paintSelection(Graphics g) {
        }
    }
}

