/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Util {
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    public static final String EMPTYSTRING = "";
    private static final Locale[] locales = new Locale[]{Locale.getDefault(), Locale.US, Locale.CHINA, Locale.TAIWAN, Locale.ENGLISH, Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE, Locale.CHINESE, Locale.UK, Locale.CANADA, Locale.CANADA_FRENCH, Locale.JAPANESE, Locale.KOREA, Locale.KOREAN, Locale.FRANCE, Locale.FRENCH, Locale.GERMAN, Locale.GERMANY, Locale.ITALIAN, Locale.ITALY, Locale.JAPAN, Locale.PRC};
    private static final int[] styles = new int[]{3, 2, 1, 0};
    private static final int QUICKPARSE = 0;
    private static final int FULLAFTERQUICK = 2;
    private static final int LOCALESNUMINQUICKPARSE = 4;
    private static final String[] weekFields = new String[]{"EEE", "EEEE"};
    private static final String[] yearFields = new String[]{"yy", "yyyy", "yyyy"};
    private static final String[] monthFields = new String[]{"MM", "MMM", "MMMM"};
    private static final String timeInAmpmFields = "K:m:s";
    private static final String timeInDayFields = "H:m:s";
    private static final String ampmFields = "aa";
    private static final String dayFields = "dd";
    private static final String defaultPattern = "EEE yy MM dd HH:mm:ss";
    private static final int[][] mix = new int[][]{{0, 1, 2}, {0, 2, 1}, {1, 2, 0}, {2, 1, 0}, {1, 0, 2}, {2, 0, 1}};

    public static int booleanToInt(boolean val) {
        if (val) {
            return 1;
        }
        return 0;
    }

    public static char booleanToChar(boolean val) {
        if (val) {
            return 'T';
        }
        return 'F';
    }

    public static String booleanToString(boolean val) {
        if (val) {
            return "true";
        }
        return "false";
    }

    public static Number stringToNumber(String val) {
        NumberFormat nf = NumberFormat.getInstance();
        ParsePosition pos = new ParsePosition(0);
        Number ret = nf.parse(val, pos);
        if (pos.getIndex() == 0) {
            ret = null;
        }
        if (pos.getIndex() < val.length()) {
            ret = null;
        }
        return ret;
    }

    public static Boolean stringToBoolean(String val) {
        if (val.equalsIgnoreCase("true")) {
            return true;
        }
        if (val.equalsIgnoreCase("false")) {
            return false;
        }
        return null;
    }

    public static String stringReplace(String source, String substring, String replacement) {
        int sublen = substring.length();
        int srclen = source.length();
        if (sublen == 0 || srclen < sublen) {
            return source;
        }
        int index = source.indexOf(substring);
        if (index == -1) {
            return source;
        }
        return source.substring(0, index) + replacement + source.substring(index + sublen, srclen);
    }

    public static String stringReplaceAll(String source, String substring, String replacement) {
        int sublen = substring.length();
        int srclen = source.length();
        int rpllen = replacement.length();
        if (sublen == 0 || srclen < sublen) {
            return source;
        }
        StringBuffer sb = new StringBuffer(source);
        int index = sb.indexOf(substring);
        while (index != -1) {
            sb = sb.replace(index, index + sublen, replacement);
            index = sb.indexOf(substring, index + rpllen);
        }
        return sb.toString();
    }

    private static Date stringToDate(String src, int type) {
        Date ret = null;
        DateFormat df = null;
        int localesMax = 0;
        int localeStart = 0;
        if (type == 0) {
            localesMax = 4;
        } else if (type == 2) {
            localeStart = 4;
            localesMax = locales.length;
        } else {
            localesMax = locales.length;
        }
        block2: for (int i = localeStart; i < localesMax; ++i) {
            for (int j = 0; j < styles.length; ++j) {
                df = DateFormat.getDateInstance(styles[j], locales[i]);
                df.setLenient(false);
                try {
                    ret = df.parse(src);
                    break block2;
                }
                catch (Exception e) {
                    ret = null;
                    continue;
                }
            }
        }
        return ret;
    }

    private static Date stringToTime(String src, int type) {
        Date ret = null;
        DateFormat df = null;
        int localesMax = 0;
        int localeStart = 0;
        if (type == 0) {
            localesMax = 4;
        } else if (type == 2) {
            localeStart = 4;
            localesMax = locales.length;
        } else {
            localesMax = locales.length;
        }
        block2: for (int i = localeStart; i < localesMax; ++i) {
            for (int j = 0; j < styles.length; ++j) {
                df = DateFormat.getTimeInstance(styles[j], locales[i]);
                df.setLenient(false);
                try {
                    ret = df.parse(src);
                    break block2;
                }
                catch (Exception e) {
                    ret = null;
                    continue;
                }
            }
        }
        return ret;
    }

    private static Date stringToDateTime(String src, int type) {
        Date ret = null;
        DateFormat df = null;
        int localesMax = 0;
        int localeStart = 0;
        if (type == 0) {
            localesMax = 4;
        } else if (type == 2) {
            localeStart = 4;
            localesMax = locales.length;
        } else {
            localesMax = locales.length;
        }
        block2: for (int i = localeStart; i < localesMax; ++i) {
            for (int j = 0; j < styles.length; ++j) {
                for (int k = 0; k < styles.length; ++k) {
                    df = DateFormat.getDateTimeInstance(styles[j], styles[k], locales[i]);
                    df.setLenient(false);
                    try {
                        ret = df.parse(src);
                        break block2;
                    }
                    catch (Exception e) {
                        ret = null;
                        continue;
                    }
                }
            }
        }
        return ret;
    }

    private static String[] getDateWeekPatterns(int dateStyle, int weekStyle) {
        String[] patterns = new String[]{EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, EMPTYSTRING};
        String[] dates = new String[]{monthFields[dateStyle] + " " + dayFields, "dd " + monthFields[dateStyle]};
        for (int idates = 0; idates < 2; ++idates) {
            String[] fields = new String[]{weekFields[weekStyle], yearFields[dateStyle], dates[idates]};
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int n = idates * 6 + i;
                    patterns[n] = patterns[n] + fields[mix[i][j]];
                    if (j >= 2) continue;
                    int n2 = idates * 6 + i;
                    patterns[n2] = patterns[n2] + " ";
                }
            }
        }
        return patterns;
    }

    private static String[] getDatePatterns(int dateStyle) {
        String[] patterns = new String[]{EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, EMPTYSTRING};
        String[] dates = new String[]{monthFields[dateStyle] + " " + dayFields, "dd " + monthFields[dateStyle]};
        for (int idates = 0; idates < 2; ++idates) {
            String[] fields = new String[]{null, yearFields[dateStyle], dates[idates]};
            for (int i = 0; i < 2; ++i) {
                for (int j = 1; j < 3; ++j) {
                    int n = idates * 2 + i;
                    patterns[n] = patterns[n] + fields[mix[i][j]];
                    if (j >= 2) continue;
                    int n2 = idates * 2 + i;
                    patterns[n2] = patterns[n2] + " ";
                }
            }
        }
        return patterns;
    }

    protected static Date stringToDateByPattern(String src) {
        int dateStyle;
        String str = src.replace('.', ' ');
        str = str.replace('-', ' ');
        str = str.replace('/', ' ');
        str = str.replace(',', ' ');
        while (-1 != str.indexOf("  ")) {
            str = str.replaceAll("  ", " ");
        }
        boolean isIncludeTime = false;
        if (-1 != str.indexOf(58, 10)) {
            isIncludeTime = true;
        }
        Date ret = null;
        String[][] ps = new String[9][];
        for (dateStyle = 0; dateStyle < 3; ++dateStyle) {
            ps[dateStyle] = Util.getDatePatterns(dateStyle);
        }
        for (dateStyle = 0; dateStyle < 3; ++dateStyle) {
            for (int weeekStyle = 0; weeekStyle < 2; ++weeekStyle) {
                ps[dateStyle * 2 + weeekStyle + 3] = Util.getDateWeekPatterns(dateStyle, weeekStyle);
            }
        }
        ParsePosition pos = new ParsePosition(0);
        if (isIncludeTime) {
            int i;
            String[] timeFields = new String[]{"K:m:s aa", timeInDayFields, "aaK:m:s"};
            String[][] psTime = new String[27][];
            for (i = 0; i < 3; ++i) {
                int k;
                for (k = 0; k < 3; ++k) {
                    psTime[i * 9 + k] = new String[4];
                }
                for (k = 3; k < 9; ++k) {
                    psTime[i * 9 + k] = new String[12];
                }
            }
            for (int k = 0; k < timeFields.length; ++k) {
                for (int i2 = 0; i2 < ps.length; ++i2) {
                    for (int j = 0; j < ps[i2].length; ++j) {
                        psTime[9 * k + i2][j] = ps[i2][j] + " " + timeFields[k];
                    }
                }
            }
            for (i = 0; i < locales.length && (ret = Util.stringToDateByPattern(str, psTime, locales[i], pos)) == null; ++i) {
            }
        } else {
            for (int i = 0; i < locales.length && (ret = Util.stringToDateByPattern(str, ps, locales[i], pos)) == null; ++i) {
            }
        }
        return ret;
    }

    private static Date stringToDateByPattern(String src, String[][] patterns, Locale loc, ParsePosition pos) {
        Date ret = null;
        SimpleDateFormat sdf = new SimpleDateFormat(defaultPattern, loc);
        sdf.setLenient(false);
        ret = sdf.parse(src, pos);
        if (ret != null) {
            return ret;
        }
        int i = 0;
        int j = 0;
        block0: for (i = 0; i < patterns.length; ++i) {
            for (j = 0; j < patterns[i].length; ++j) {
                sdf.applyPattern(patterns[i][j]);
                ret = sdf.parse(src, pos);
                if (ret != null) break block0;
            }
        }
        return ret;
    }

    protected static Date stringToDateEx(String src) {
        DateFormatSymbols dfs = null;
        String[] weekdays = null;
        String str = src.toUpperCase();
        String token = null;
        block0: for (int i = 0; i < locales.length; ++i) {
            int k;
            dfs = new DateFormatSymbols(locales[i]);
            weekdays = dfs.getShortWeekdays();
            for (k = 1; k < weekdays.length; ++k) {
                token = weekdays[k].toUpperCase();
                if (-1 == str.indexOf(token)) continue;
                str = Util.stringReplace(str, token, EMPTYSTRING);
                str = str.trim();
                break block0;
            }
            weekdays = dfs.getWeekdays();
            for (k = 1; k < weekdays.length; ++k) {
                token = weekdays[k].toUpperCase();
                if (-1 == str.indexOf(token)) continue;
                str = Util.stringReplace(str, token, EMPTYSTRING);
                str = str.trim();
                break block0;
            }
        }
        Date ret = null;
        if (src.length() > 10) {
            ret = Util.stringToDateTime(src, 0);
            if (ret == null) {
                ret = Util.stringToDateTime(src, 2);
            }
            if (ret == null && (ret = Util.stringToDate(src, 0)) == null) {
                ret = Util.stringToTime(src, 0);
            }
            if (ret == null && (ret = Util.stringToDate(src, 2)) == null) {
                ret = Util.stringToTime(src, 2);
            }
        } else {
            ret = Util.stringToDate(src, 0);
            if (ret == null) {
                ret = Util.stringToDate(src, 2);
            }
            if (ret == null && (ret = Util.stringToTime(src, 0)) == null) {
                ret = Util.stringToTime(src, 2);
            }
            if (ret == null && (ret = Util.stringToDateTime(src, 0)) == null) {
                ret = Util.stringToDateTime(src, 2);
            }
        }
        return ret;
    }

    public static Date stringToDate(String src) {
        Date ret = null;
        if (src.length() > 10) {
            ret = Util.stringToDateTime(src, 0);
            if (ret == null) {
                ret = Util.stringToDateTime(src, 2);
            }
            if (ret == null && (ret = Util.stringToDate(src, 0)) == null) {
                ret = Util.stringToTime(src, 0);
            }
            if (ret == null && (ret = Util.stringToDate(src, 2)) == null) {
                ret = Util.stringToTime(src, 2);
            }
            if (ret == null) {
                ret = Util.stringToDateByPattern(src);
            }
        } else {
            ret = Util.stringToDate(src, 0);
            if (ret == null) {
                ret = Util.stringToDate(src, 2);
            }
            if (ret == null && (ret = Util.stringToTime(src, 0)) == null) {
                ret = Util.stringToTime(src, 2);
            }
            if (ret == null && (ret = Util.stringToDateTime(src, 0)) == null) {
                ret = Util.stringToDateTime(src, 2);
            }
            if (ret == null) {
                ret = Util.stringToDateByPattern(src);
            }
        }
        return ret;
    }
}

