/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.style;

import com.kingdee.bos.ctrl.kdf.util.render.r1print.KDFontMapperPlus;
import com.kingdee.bos.ctrl.kdf.util.style.Border;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFont;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import javax.swing.UIManager;

public class Style
extends ShareStyleAttributes {
    private KDFontShell _fs;
    private StrokeShell[] _aSS;
    private Paint _paint;
    public static KDFont DEFAULT_FONT;
    public static KDFontMapperPlus DEFAULT_FONTMAPPERPLUS;

    public Style(ShareStyleAttributes ssa) {
        super(ssa);
        if (!ssa.isFull()) {
            throw new IllegalArgumentException();
        }
        this._aSS = new StrokeShell[6];
    }

    public ShareStyleAttributes subtract(Style style) {
        if (this == style) {
            return null;
        }
        StyleAttributes sa = Styles.getSA(this);
        sa.clearAttributes(sa.sameBits(style, 0, sa.count()));
        return Styles.getSSA(sa);
    }

    public static void setDefaultFont(Font font) {
        DEFAULT_FONT = new KDFont(font.getAttributes());
    }

    public KDFont getKDFont() {
        if (DEFAULT_FONT != null) {
            return DEFAULT_FONT;
        }
        if (this._fs == null) {
            int flag = 0;
            if (this.isBold()) {
                ++flag;
            }
            if (this.isItalic()) {
                flag += 2;
            }
            String fontName = this.getFontName();
            HashMap aliases = DEFAULT_FONTMAPPERPLUS.getAliases();
            Object o = aliases.get(fontName);
            if (o != null) {
                fontName = o.toString();
            }
            this._fs = Styles.getFontShell(fontName, flag, this.getFontSize());
        }
        return this._fs.getFont();
    }

    private StrokeShell getStrokeShell(Styles.Position pos) {
        int index = pos.getIndex();
        StrokeShell ss = this._aSS[index];
        if (ss == null) {
            this._aSS[index] = ss = Styles.getStrokeShell(this.getBorderPenStyle(pos), this.getBorderLineStyle(pos));
        }
        return ss;
    }

    public Stroke getStroke(Styles.Position pos) {
        return this.getStrokeShell(pos).getStroke();
    }

    public Stroke getBaseStroke(Styles.Position pos) {
        return this.getStrokeShell(pos).getBaseStroke();
    }

    public Paint getFillPaint() {
        if (this._paint == null) {
            Pattern pattern = this.getPattern();
            if (pattern == Pattern.Solid) {
                this._paint = this.getBackground();
            } else if (pattern == Pattern.None) {
                this._paint = Styles.getNullColor();
            } else {
                Color clrPattern = this.getPatternColor();
                Color clrGround = this.getBackground();
                if (Styles.isNullColor(clrGround)) {
                    clrGround = UIManager.getColor("Panel.background");
                }
                byte[] r = new byte[]{(byte)clrGround.getRed(), (byte)clrPattern.getRed()};
                byte[] g = new byte[]{(byte)clrGround.getGreen(), (byte)clrPattern.getGreen()};
                byte[] b = new byte[]{(byte)clrGround.getBlue(), (byte)clrPattern.getBlue()};
                byte[] a = new byte[]{(byte)clrGround.getAlpha(), (byte)clrPattern.getAlpha()};
                IndexColorModel cm = new IndexColorModel(1, 2, r, g, b, a);
                BufferedImage img = new BufferedImage(8, 8, 12, cm);
                byte[] data = pattern.getPatternData();
                DataBufferByte db = new DataBufferByte(data, data.length);
                WritableRaster ras = Raster.createPackedRaster(db, 8, 8, 1, null);
                img.setData(ras);
                Rectangle rc = new Rectangle(0, 0, 8, 8);
                this._paint = new TexturePaint(img, rc);
            }
        }
        return this._paint;
    }

    public Border getBorder(Styles.Position pos) {
        return new Border(pos, this);
    }

    static {
        DEFAULT_FONTMAPPERPLUS = new KDFontMapperPlus();
    }

    static class KDFontShell {
        private String _name;
        private int _fontStyle;
        private int _size;
        private KDFont _font;

        public KDFontShell(String name, int fontStyle, int size) {
            this._name = name;
            this._fontStyle = fontStyle;
            this._size = size;
        }

        public KDFont getFont() {
            if (this._font == null) {
                this._font = new KDFont(this._name, this._fontStyle, this._size);
            }
            return this._font;
        }

        public int hashCode() {
            return this._name.hashCode() ^ this._fontStyle ^ this._size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof KDFontShell) {
                KDFontShell cmp = (KDFontShell)obj;
                return this._fontStyle == cmp._fontStyle && this._size == cmp._size && this._name.equals(cmp._name);
            }
            return false;
        }
    }

    static class StrokeShell {
        private PenStyle _ps;
        private LineStyle _ls;
        private Stroke _stroke;
        private Stroke _baseStroke;

        public StrokeShell(PenStyle ps, LineStyle ls) {
            this._ps = ps;
            this._ls = ls;
        }

        public int hashCode() {
            return this._ps.hashCode() ^ this._ls.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StrokeShell)) {
                return false;
            }
            StrokeShell ss = (StrokeShell)obj;
            return this._ps.equals(ss._ps) && this._ls.equals(ss._ls);
        }

        public Stroke getStroke() {
            if (this._stroke == null) {
                this._stroke = this._ps.getStroke(this._ls.getWidth());
            }
            return this._stroke;
        }

        public Stroke getBaseStroke() {
            if (this._baseStroke == null) {
                this._baseStroke = this._ps.getBaseStroke();
            }
            return this._baseStroke;
        }
    }
}

