/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.style.styledesigner;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.tabbedpane.LazyTabbedPane;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.AlignmentPane;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.BorderPane;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.DigitFormatPane;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.FontPane;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.FormatPane;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.InteriorPane;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.LinePane;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.PaddingPane;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.ProtectionPane;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.StyleDesigner;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.packing.ILazyStylePane;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.packing.IStylePane;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.packing.LazyStylePane;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;

public class LazyStyleDesigner
extends TypicalDialog {
    public static final String PANEL_ALIGNMENT = "alignment";
    public static final String PANEL_FONT = "font";
    public static final String PANEL_BORDER = "border";
    public static final String PANEL_INTERIOR = "interior";
    public static final String PANEL_FORMAT = "format";
    public static final String PANEL_DIGIT_FORMAT = "digitFormat";
    public static final String PANEL_PROTECTION = "protection";
    public static final String PANEL_LINE = "line";
    public static final String PANEL_PADDING = "padding";
    public static final String[] DEFAULT_ALL_PANELS = new String[]{"digitFormat", "alignment", "font", "border", "interior", "protection"};
    public static final String[] DEFAULT_ALL_PANELS_EXCEPT_PROTECTION = new String[]{"digitFormat", "alignment", "font", "border", "interior"};
    private HashMap _cache;
    private LazyTabbedPane _tabbedPane;
    private StyleAttributes _sa;
    private StyleAttributes _saForModify;
    private StylePanelInitializer stylePanelInitializer;
    private boolean _isChanged;

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        final KDFrame frame = new KDFrame();
        frame.setSize(400, 300);
        Container cp = frame.getContentPane();
        cp.setLayout(null);
        final KDTextField tf = new KDTextField();
        cp.add((Component)tf);
        KDButton btn = new KDButton("\u683c\u5f0f");
        cp.add((Component)btn);
        tf.setBounds(10, 10, 200, 20);
        btn.setBounds(10, 50, 100, 20);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleAttributes sa = Styles.getDefaultSA();
                sa.setNumberFormat(tf.getText());
                sa.getPadding();
                LazyStyleDesigner sd = new LazyStyleDesigner((Frame)frame);
                sd.setPanels(new String[]{LazyStyleDesigner.PANEL_FONT, LazyStyleDesigner.PANEL_BORDER, LazyStyleDesigner.PANEL_INTERIOR});
                sd.setSA(sa);
                if (sd.showDialog() && sd.isChanged()) {
                    tf.setText(sd.getSA().getNumberFormat());
                }
            }
        });
        frame.setVisible(true);
    }

    public LazyStyleDesigner() {
        this.initCache();
    }

    public LazyStyleDesigner(Dialog owner) {
        super(owner);
        this.initCache();
    }

    public LazyStyleDesigner(Frame owner) {
        super(owner);
        this.initCache();
    }

    private void initCache() {
        this._cache = new HashMap();
        this.initLazyPane(PANEL_ALIGNMENT, AlignmentPane.class, LazyStyleDesigner.getMLS("tabTitleAlignment", "\u5bf9\u9f50"));
        this.initLazyPane(PANEL_FONT, FontPane.class, LazyStyleDesigner.getMLS("tabTitleFont", "\u5b57\u4f53"));
        this.initLazyPane(PANEL_BORDER, BorderPane.class, LazyStyleDesigner.getMLS("tabTitleBorder", "\u8fb9\u6846"));
        this.initLazyPane(PANEL_INTERIOR, InteriorPane.class, LazyStyleDesigner.getMLS("tabTitleInterior", "\u80cc\u666f"));
        this.initLazyPane(PANEL_LINE, LinePane.class, LazyStyleDesigner.getMLS("tabTitleLine", "\u7ebf\u578b"));
        this.initLazyPane(PANEL_FORMAT, FormatPane.class, LazyStyleDesigner.getMLS("tabTitleFormat", "\u683c\u5f0f"));
        this.initLazyPane(PANEL_DIGIT_FORMAT, DigitFormatPane.class, LazyStyleDesigner.getMLS("tabTitleFormat", "\u683c\u5f0f"));
        this.initLazyPane(PANEL_PROTECTION, ProtectionPane.class, LazyStyleDesigner.getMLS("tabTitleProtection", "\u4fdd\u62a4"));
        this.initLazyPane(PANEL_PADDING, PaddingPane.class, LazyStyleDesigner.getMLS("tabTitlePadding", "\u56db\u8fb9\u8ddd"));
    }

    private void initLazyPane(String key, Class classname, String title) {
        LazyStylePane lazy = new LazyStylePane();
        lazy.setClassName(classname);
        lazy.setTitle(title);
        this._cache.put(key, lazy);
    }

    @Override
    protected void todoInit() {
        this._tabbedPane = new LazyTabbedPane();
        this.setSize(486, 405);
        this.setResizable(false);
    }

    @Override
    protected void todoAddControls(Container parent, Cell thisCell) {
        thisCell.style().setMargin(10, 10, 10, 10);
        parent.add((Component)((Object)this._tabbedPane), thisCell);
    }

    public void setPanels(String[] keys) {
        if (keys == null) {
            return;
        }
        this._tabbedPane.removeAll();
        for (int i = 0; i < keys.length; ++i) {
            ILazyStylePane lazy = (ILazyStylePane)this._cache.get(keys[i]);
            if (this._saForModify != null) {
                lazy.setSA(this._saForModify);
            }
            if (LazyStylePane.class.isAssignableFrom(lazy.getClass())) {
                ((LazyStylePane)lazy).setStylePanelInitializer(this.stylePanelInitializer);
            }
            KDPanel lazyPane = this._tabbedPane.addLazyPane(lazy);
            lazyPane.setUserObject((Object)keys[i]);
        }
    }

    private StyleAttributes defaultSA() {
        return Styles.getDefaultSA();
    }

    public boolean isChanged() {
        return this._isChanged;
    }

    public void setSA(StyleAttributes sa) {
        this._sa = sa == null ? this.defaultSA() : sa;
        this._saForModify = Styles.getSA(this._sa);
        int c = this._tabbedPane.getTabCount();
        for (int i = 0; i < c; ++i) {
            KDPanel lazyPacking = (KDPanel)this._tabbedPane.getComponentAt(i);
            String key = (String)lazyPacking.getUserObject();
            ILazyStylePane lazy = (ILazyStylePane)this._cache.get(key);
            lazy.setSA(this._saForModify);
        }
    }

    public void setTabbedSelected(String key) {
        int index = 0;
        int c = this._tabbedPane.getTabCount();
        for (int i = 0; i < c; ++i) {
            KDPanel lazyPacking = (KDPanel)this._tabbedPane.getComponentAt(i);
            String keyTemp = (String)lazyPacking.getUserObject();
            if (!keyTemp.equals(key)) continue;
            index = i;
        }
        this._tabbedPane.setSelectedIndex(index);
    }

    public StyleAttributes getSA() {
        return this._sa;
    }

    public KDPanel getPanel(String key) {
        ILazyStylePane lazy = (ILazyStylePane)this._cache.get(key);
        KDPanel pan = lazy.getPanel();
        return pan;
    }

    @Override
    protected boolean verify() {
        if (!this._sa.equals(this._saForModify)) {
            this._sa = Styles.getSA(this._saForModify);
            this._isChanged = true;
        }
        return true;
    }

    @Override
    public boolean showDialog() {
        this._isChanged = false;
        return super.showDialog();
    }

    static String getMLS(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, StyleDesigner.class, (String)defaultValue);
    }

    private BorderPane getBorderPane() {
        return (BorderPane)this.getPanel(PANEL_BORDER);
    }

    public void setInnerBorderSA(StyleAttributes sa) {
        this.getBorderPane().setInnerSA(sa);
    }

    public StyleAttributes getInnerBorderSA() {
        return this.getBorderPane().getInnerSA();
    }

    public boolean isInnerBorderChanged() {
        return this.getBorderPane().isInnerBorderChanged();
    }

    public boolean isInnerHEnabled() {
        return this.getBorderPane().isInnerHEnabled();
    }

    public void setInnerHEnabled(boolean b) {
        this.getBorderPane().setInnerHEnabled(b);
    }

    public boolean isInnerVEnabled() {
        return this.getBorderPane().isInnerVEnabled();
    }

    public void setInnerVEnabled(boolean b) {
        this.getBorderPane().setInnerVEnabled(b);
    }

    public void setInnerBorderConstant(Styles.Position h, Styles.Position v) {
        this.getBorderPane().setInnerBorderConstant(h, v);
    }

    public StylePanelInitializer getStylePanelInitializer() {
        return this.stylePanelInitializer;
    }

    public void setStylePanelInitializer(StylePanelInitializer stylePanelInitializer) {
        this.stylePanelInitializer = stylePanelInitializer;
    }

    public HashMap getCache() {
        return this._cache;
    }

    public void setCache(HashMap _cache) {
        this._cache = _cache;
    }

    public static interface StylePanelInitializer {
        public void init(IStylePane var1);
    }
}

