/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.engine;

import com.kingdee.bos.ctrl.data.engine.NotFoundVarException;
import com.kingdee.bos.ctrl.data.invoke.IEnvProvider;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BindVariants {
    private static final String PATTERN_PARAM_STR = "@[a-z|A-Z|_][\\w|_]*.[a-z|A-Z|_][\\w|_]*";
    private static final String PATTERN_ENV_STR = "@@[a-z|A-Z|_][\\w|_]*.[a-z|A-Z|_][\\w|_]*";
    public static final Pattern PARAM = Pattern.compile("@[a-z|A-Z|_][\\w|_]*.[a-z|A-Z|_][\\w|_]*", 32);
    public static final Pattern ENV = Pattern.compile("@@[a-z|A-Z|_][\\w|_]*.[a-z|A-Z|_][\\w|_]*", 32);
    private static final String PATTERN_SIMPLE_PARAM_STR = "@\\w+";
    private static final String PATTERN_SIMPLE_ENV_STR = "@@\\w+";
    public static final Pattern SIMPLE_PARAM = Pattern.compile("@\\w+", 32);
    public static final Pattern SIMPLE_ENV = Pattern.compile("@@\\w+", 32);

    public static final String replaceVariants(String expr, Map params, boolean simpleStyle) throws NotFoundVarException {
        return BindVariants.replaceVariants(expr, params, null, simpleStyle, true);
    }

    public static final String replaceVariants(String expr, Map params, IEnvProvider envProvider, boolean simpleStyle, boolean param) throws NotFoundVarException {
        Matcher mch = null;
        mch = simpleStyle ? SIMPLE_PARAM.matcher(expr) : PARAM.matcher(expr);
        StringBuffer sb1 = new StringBuffer();
        int j = 0;
        while (mch.find()) {
            int i = mch.start();
            sb1.append(expr.substring(j, i));
            j = mch.end();
            String token = expr.substring(i, j);
            int index = token.lastIndexOf(64);
            String realName = token.substring(index + 1);
            String solveResult = BindVariants.getVar(params, envProvider, realName, param);
            if (solveResult == null) {
                throw new NotFoundVarException(realName, param);
            }
            sb1.append(solveResult);
        }
        sb1.append(expr.substring(j));
        return sb1.toString();
    }

    public static final String replaceVariants2(String expr, Map params, boolean simpleStyle) {
        return BindVariants.replaceVariants2(expr, params, null, simpleStyle, true);
    }

    public static final String replaceVariants2(String expr, Map params, IEnvProvider envProvider, boolean simpleStyle, boolean param) {
        Matcher mch = null;
        mch = simpleStyle ? SIMPLE_PARAM.matcher(expr) : PARAM.matcher(expr);
        StringBuffer sb1 = new StringBuffer();
        int j = 0;
        while (mch.find()) {
            int i = mch.start();
            sb1.append(expr.substring(j, i));
            j = mch.end();
            String token = expr.substring(i, j);
            int index = token.lastIndexOf(64);
            String realName = token.substring(index + 1);
            String solveResult = BindVariants.getVar(params, envProvider, realName, param);
            if (solveResult == null) {
                solveResult = "";
            }
            sb1.append(solveResult);
        }
        sb1.append(expr.substring(j));
        return sb1.toString();
    }

    private static final String getVar(Map params, IEnvProvider envProvider, String name, boolean param) {
        Object objVal = null;
        if (param) {
            if (params == null) {
                return null;
            }
            objVal = params.get(name);
        } else {
            if (envProvider == null) {
                return null;
            }
            objVal = envProvider.get(name);
        }
        return objVal == null ? null : objVal.toString();
    }
}

