/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.engine.resultset;

import com.kingdee.bos.ctrl.common.util.ArrayUtil;
import com.kingdee.bos.ctrl.data.engine.resultset.BasicResultSetMetaData;
import com.kingdee.bos.ctrl.data.engine.resultset.IPersistent;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SimpleResultSetMetaData
extends BasicResultSetMetaData
implements ResultSetMetaData,
IPersistent {
    protected String[] labels;
    protected String[] names;
    protected int[] types;

    public SimpleResultSetMetaData(ResultSetMetaData rsmd) throws SQLException {
        this.copy(rsmd);
    }

    public SimpleResultSetMetaData() {
        int count = 0;
        this.labels = new String[count];
        this.names = new String[count];
        this.types = new int[count];
    }

    public void copy(ResultSetMetaData rsmd) throws SQLException {
        int count = rsmd.getColumnCount();
        this.labels = new String[count];
        this.names = new String[count];
        this.types = new int[count];
        for (int i = 0; i < count; ++i) {
            this.labels[i] = rsmd.getColumnLabel(i + 1);
            this.names[i] = rsmd.getColumnName(i + 1);
            this.types[i] = rsmd.getColumnType(i + 1);
        }
    }

    public void setColumnLabel(int column, String label) {
        this.labels[column - 1] = label;
    }

    @Override
    public int getColumnCount() {
        return this.types.length;
    }

    @Override
    public String getColumnLabel(int column) {
        return this.labels[column - 1];
    }

    public void setColumnName(int column, String name) {
        this.names[column - 1] = name;
    }

    @Override
    public String getColumnName(int column) {
        return this.names[column - 1];
    }

    @Override
    public int getColumnType(int column) {
        return this.types[column - 1];
    }

    public void deleteColumn(int colIdx) {
        this.labels = (String[])ArrayUtil.removeElement((Object[])this.labels, (int)(--colIdx));
        this.names = (String[])ArrayUtil.removeElement((Object[])this.names, (int)colIdx);
        this.types = ArrayUtil.removeElement((int[])this.types, (int)colIdx);
    }

    public void addColumn(int colIdx, String colName, int colType) {
        this.labels = (String[])ArrayUtil.insertElement((Object[])this.labels, (int)(--colIdx), (Object)colName);
        this.names = (String[])ArrayUtil.insertElement((Object[])this.names, (int)colIdx, (Object)colName);
        this.types = ArrayUtil.insertElement((int[])this.types, (int)colIdx, (int)colType);
    }
}

