/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.framework.bos;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class IdsDataAccess {
    private static final Logger log = LogUtil.getPackageLogger(IdsDataAccess.class);
    public static final int PAGED_ID_COUNT = 10000;
    private static final int ID_MODE_SWITCH = 200;
    private boolean isFirst = true;
    private boolean idMode = true;
    private List idList = null;
    private IDataProvider dataProvider;

    public IdsDataAccess(IDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    private List fetchIDList() throws BOSException {
        List pagedIds;
        log.info((Object)"Fetch id list ...");
        Uuid sessionID = this.dataProvider.openQuery();
        List allIds = null;
        do {
            pagedIds = this.dataProvider.getQueryKeys(sessionID, 10000);
            if (allIds == null) {
                allIds = pagedIds;
                continue;
            }
            allIds.addAll(pagedIds);
        } while (pagedIds.size() >= 10000);
        this.dataProvider.releaseQueryCache(sessionID);
        log.info((Object)("Facthed id count: " + allIds.size()));
        return allIds;
    }

    protected IRowSet getPage(int start, int length) throws BOSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getPage(start=" + start + ", length=" + length + ")"));
        }
        return this.dataProvider.executeQuery(start, length);
    }

    protected IRowSet getPageWithId(int start, int length) throws BOSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getPageWithID(start=" + start + ", length=" + length + ")"));
        }
        if (this.idList == null) {
            return null;
        }
        int idCount = this.idList.size();
        if (start >= idCount) {
            return null;
        }
        int z = start + length;
        if (z > idCount) {
            z = idCount;
        }
        ArrayList pageIds = new ArrayList(length);
        for (int i = start; i < z; ++i) {
            pageIds.add(this.idList.get(i));
        }
        log.info((Object)("Execute query with ids, count: " + pageIds.size()));
        return this.dataProvider.executeQuery(pageIds);
    }

    public int getRowCount() throws BOSException {
        return this.idList != null ? this.idList.size() : this.dataProvider.getRowCount();
    }

    public IRowSet getRowSet() throws BOSException {
        return this.dataProvider.executeQuery();
    }

    private synchronized List syncIDList() {
        if (this.idList == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.idList;
    }

    public IRowSet getRowSet(int start, int length) throws BOSException {
        if (this.isFirst) {
            this.isFirst = false;
            IRowSet rowSet = this.getPage(start, length);
            this.idMode = rowSet.size() < length ? start + rowSet.size() > 200 : true;
            if (this.idMode) {
                this.background_fetchIDList();
            }
            return rowSet;
        }
        if (this.idMode) {
            if (this.idList != null) {
                return this.getPageWithId(start, length);
            }
            if (this.syncIDList() != null) {
                return this.getPageWithId(start, length);
            }
            this.idMode = false;
        }
        return this.getPage(start, length);
    }

    private void background_fetchIDList() {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    IdsDataAccess.this.idList = IdsDataAccess.this.fetchIDList();
                }
                catch (Exception ex) {
                    log.error((Object)"Fial to fetch id list", (Throwable)ex);
                }
                finally {
                    IdsDataAccess.this.notifyAll();
                }
            }
        };
        t.start();
    }
}

