/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.invoke;

import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.data.engine.script.IScriptExecutor;
import com.kingdee.bos.ctrl.data.engine.script.beanshell.BeanShellExecutor;
import com.kingdee.bos.ctrl.data.engine.script.java.JavaClassExecutor;
import com.kingdee.bos.ctrl.data.engine.script.java.JavaFileExecutor;
import com.kingdee.bos.ctrl.data.invoke.DataContext;
import com.kingdee.bos.ctrl.data.invoke.IDataExecutor;
import com.kingdee.bos.ctrl.data.invoke.IEnvProvider;
import com.kingdee.bos.ctrl.data.modal.CommonQuery;
import com.kingdee.bos.ctrl.data.modal.DataDef;
import com.kingdee.bos.ctrl.data.modal.IDataDef;
import com.kingdee.bos.ctrl.data.modal.Import;
import com.kingdee.bos.ctrl.data.modal.ProcessScript;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.types.ScriptType;
import com.kingdee.bos.ctrl.data.process.ProcessUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class DataCatcher {
    private static final Logger log = LogUtil.getLogger(DataCatcher.class);
    private IDataExecutor externalExecutor;

    public DataCatcher(IDataExecutor dataExecutor) {
        this.externalExecutor = dataExecutor;
    }

    public IDataExecutor getDataExecutor() {
        return this.externalExecutor;
    }

    public Object call(IDataDef dataObj, HashMap args, IEnvProvider envProvider) throws Exception {
        long t0 = System.currentTimeMillis();
        if (dataObj == null) {
            throw new IllegalArgumentException("object is null!");
        }
        ProcessScript ps = dataObj.getProcessScript();
        DataContext ctx = new DataContext(dataObj, args, envProvider, this.externalExecutor);
        if (dataObj instanceof CommonQuery) {
            IQuery rv = ((CommonQuery)dataObj).getQuery();
            ctx.setDataResult(rv);
        } else {
            ctx.setDataResult(null);
        }
        if (ps != null && !ps.isAutoMakeCalling() || dataObj instanceof CommonQuery) {
            boolean done = true;
            if (ps != null) {
                String script = ps.getScript();
                if (script != null) {
                    IScriptExecutor executor = null;
                    if (ps.getType() == ScriptType.BEANSHELL) {
                        executor = new BeanShellExecutor();
                    } else if (ps.getType() == ScriptType.JAVACLASS) {
                        executor = new JavaClassExecutor();
                    } else if (ps.getType() == ScriptType.JAVACODE) {
                        executor = new JavaFileExecutor();
                    }
                    if (executor != null) {
                        executor.init(ctx);
                        executor.executeScript(script.trim());
                    } else {
                        done = false;
                    }
                } else {
                    done = false;
                }
            }
            if (!done) {
                throw new UnsupportedOperationException("Unsupport this type of script:" + ps.getType().getName());
            }
        } else {
            this.executeDataDefProcessModels((DataDef)dataObj, ctx);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("call token: " + (System.currentTimeMillis() - t0)));
        }
        return ctx.getDataResult();
    }

    private void executeDataDefProcessModels(DataDef dataDef, DataContext ctx) throws Exception {
        List models = ProcessUtil.xml2Models(dataDef.getDesignInfoes());
        Class<?> modelsExecutorCls = Class.forName("com.kingdee.bos.ctrl.data.wizard.process.ModelsExecutor");
        try {
            Method m = modelsExecutorCls.getMethod("executeModels", DataContext.class, List.class);
            m.invoke(null, ctx, models);
        }
        catch (Exception ex) {
            if (ex instanceof InvocationTargetException) {
                throw new Exception(((InvocationTargetException)ex).getTargetException());
            }
            throw ex;
        }
    }

    public Object executeImport(String name, HashMap params, DataContext ctx) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("executeImport: '" + name + "'"));
        }
        long t0 = System.currentTimeMillis();
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put("executeMode", "RESULT_SET");
        Import importObj = ctx.getDataObject().getImports().get(name);
        if (importObj == null) {
            throw new Exception("Couldn't find import object: '" + name + "' in imports list!");
        }
        FullPath fp = FullPath.parse((String)importObj.getExpr());
        Object rv = ctx.getDataExecutor().execute(null, fp, params, null);
        if (log.isDebugEnabled()) {
            log.debug((Object)("executeImport token:" + (System.currentTimeMillis() - t0)));
        }
        return rv;
    }
}

