/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.meta.bmd;

import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.data.meta.bmd.BmdMetaEnv;
import com.kingdee.bos.ctrl.data.meta.bmd.BmdMetaPackage;
import com.kingdee.bos.ctrl.data.meta.bmd.BmdMetaType;
import com.kingdee.bos.ctrl.data.meta.io.Bmd2Meta;
import com.kingdee.bos.metadata.management.SolutionInfo;
import java.io.File;

public class BmdMetaLibrary
extends MetaLibrary {
    private BmdMetaEnv env;

    public BmdMetaLibrary(BmdMetaEnv env) {
        this.env = env;
        this.loadSolutionInfo();
    }

    private void loadSolutionInfo() {
        File f = new File(this.env.makeFilePath(""));
        String[] names = f.list();
        if (names == null) {
            throw new RuntimeException("Invalid solution path:" + f.getAbsolutePath());
        }
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            int iExt = FullPath.indexOfCategory((String)name);
            if (iExt == -1 || !BmdMetaType.SOLUTION.getName().equals(name.substring(iExt + 1))) continue;
            Object bosObj = this.env.loadMetaData(BmdMetaType.SOLUTION.getBOSType(), this.env.makeFilePath(name));
            if (bosObj != null) {
                Bmd2Meta.parseSolution(this, (SolutionInfo)bosObj);
            }
            return;
        }
    }

    protected void init() {
        this.rootPackage = new BmdMetaPackage(this.env);
    }
}

