/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.modal.query.io;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.io.Xml2Def;
import com.kingdee.bos.ctrl.data.modal.io.Xml2Ext;
import com.kingdee.bos.ctrl.data.modal.query.BasicQuery;
import com.kingdee.bos.ctrl.data.modal.query.Column;
import com.kingdee.bos.ctrl.data.modal.query.Condition;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.query.ITable;
import com.kingdee.bos.ctrl.data.modal.query.Join;
import com.kingdee.bos.ctrl.data.modal.query.JoinType;
import com.kingdee.bos.ctrl.data.modal.query.Order;
import com.kingdee.bos.ctrl.data.modal.query.QueryType;
import com.kingdee.bos.ctrl.data.modal.query.Table;
import com.kingdee.bos.ctrl.data.modal.query.framework.ksql.KsqlQuery;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Element;

public class Xml2Query {
    public static final IQuery toObject(Element e) {
        IQuery obj = null;
        QueryType qt = QueryType.fromName(e.getAttributeValue("type"));
        obj = BasicQuery.createQuery(qt);
        if (obj != null) {
            Element child;
            Xml2Def.parseDefObj((IDefObj)obj, (Element)e);
            String s = e.getAttributeValue("distinct");
            if (s != null) {
                obj.setDistinct(Boolean.valueOf(s));
            }
            if ((child = e.getChild("Tables")) != null && obj.getTables() != null) {
                obj.getTables().addAll(Xml2Query.parseTables(child));
            }
            if ((child = e.getChild("Joins")) != null && obj.getJoins() != null) {
                obj.getJoins().addAll(Xml2Query.parseJoins(child));
            }
            if ((child = e.getChild("Columns")) != null) {
                obj.getColumns().addAll(Xml2Query.parseColumns(child));
            }
            if ((child = e.getChild("Orders")) != null && obj.getOrders() != null) {
                obj.getOrders().addAll(Xml2Query.parseOrders(child));
            }
            if ((child = e.getChild("Filter")) != null) {
                obj.setFilter(Xml2Query.parseCondition(child));
            }
            if ((child = e.getChild("Content")) != null) {
                obj.setContent(Xml2Query.parseContent(child));
            }
        }
        return obj;
    }

    public static void parseQueryExt(IQuery qry, Element xmlQry, Xml2Ext xml2ext) {
        Element eleFilter;
        List lstJoins;
        Element eleJoins;
        Iterator objItr;
        Iterator xmlItr;
        List lstTables;
        if (!qry.getQueryType().getCapital().equalsIgnoreCase("sql")) {
            return;
        }
        Element eleTables = xmlQry.getChild("Tables");
        if (eleTables != null && (lstTables = eleTables.getChildren()) != null) {
            xmlItr = lstTables.iterator();
            objItr = qry.getTables().iterator();
            while (objItr.hasNext()) {
                ITable tbl = (ITable)objItr.next();
                Element tblXmlNode = (Element)xmlItr.next();
                tbl.setExtObj(xml2ext.parseExtObj(tblXmlNode));
                if (!(tbl instanceof IQuery)) continue;
                Xml2Query.parseQueryExt((IQuery)((Object)tbl), tblXmlNode, xml2ext);
            }
        }
        if ((eleJoins = xmlQry.getChild("Joins")) != null && (lstJoins = eleJoins.getChildren("Join")) != null) {
            xmlItr = lstJoins.iterator();
            objItr = qry.getJoins().iterator();
            while (objItr.hasNext()) {
                ((Join)((Object)objItr.next())).getCondition().setExtObj(xml2ext.parseExtObj((Element)((Element)xmlItr.next()).getChildren().get(0)));
            }
        }
        if ((eleFilter = xmlQry.getChild("Filter")) != null) {
            qry.getFilter().setExtObj(xml2ext.parseExtObj(eleFilter));
        }
    }

    public static ArrayList parseColumns(Element xmlCols) {
        ArrayList<Column> cols = new ArrayList<Column>();
        List lst = xmlCols.getChildren("Column");
        int len = lst.size();
        for (int i = 0; i < len; ++i) {
            cols.add(Xml2Query.parseColumn((Element)lst.get(i)));
        }
        return cols;
    }

    public static ArrayList parseTables(Element xmlTbls) {
        ArrayList<ITable> tbls = new ArrayList<ITable>();
        List lst = xmlTbls.getChildren();
        int len = lst.size();
        for (int i = 0; i < len; ++i) {
            tbls.add(Xml2Query.parseTable((Element)lst.get(i)));
        }
        return tbls;
    }

    public static ArrayList parseJoins(Element xmlQry) {
        if (xmlQry == null) {
            return null;
        }
        ArrayList<Join> joins = new ArrayList<Join>();
        List lst = xmlQry.getChildren("Join");
        int len = lst.size();
        for (int i = 0; i < len; ++i) {
            joins.add(Xml2Query.parseJoin((Element)lst.get(i)));
        }
        return joins;
    }

    public static ArrayList parseOrders(Element xmlOrds) {
        if (xmlOrds == null) {
            return null;
        }
        ArrayList<Order> ords = new ArrayList<Order>();
        List lst = xmlOrds.getChildren("Order");
        int len = lst.size();
        for (int i = 0; i < len; ++i) {
            ords.add(Xml2Query.parseOrder((Element)lst.get(i)));
        }
        return ords;
    }

    public static Column parseColumn(Element xmlCol) {
        Column col = new Column();
        Xml2Def.parseDefObj((IDefObj)col, (Element)xmlCol);
        col.setDataType(DataType.fromName((String)xmlCol.getAttributeValue("dataType")));
        col.setExpr(xmlCol.getAttributeValue("expr"));
        return col;
    }

    public static ITable parseTable(Element xmlTbl) {
        if ("Table".equals(xmlTbl.getName())) {
            Table tbl = new Table();
            Xml2Def.parseDefObj((IDefObj)tbl, (Element)xmlTbl);
            tbl.setExpr(xmlTbl.getAttributeValue("expr"));
            return tbl;
        }
        if ("Query".equals(xmlTbl.getName())) {
            KsqlQuery subQuery = (KsqlQuery)Xml2Query.toObject(xmlTbl);
            return subQuery;
        }
        return null;
    }

    public static Join parseJoin(Element xmlJoin) {
        Join join = new Join();
        join.setLeftTable(xmlJoin.getAttributeValue("leftTable"));
        join.setRightTable(xmlJoin.getAttributeValue("rightTable"));
        join.setJoinType(JoinType.fromName(xmlJoin.getAttributeValue("joinType")));
        Condition cnd = Xml2Query.parseCondition((Element)xmlJoin.getChildren().get(0));
        join.setCondition(cnd);
        return join;
    }

    public static Order parseOrder(Element xmlOrd) {
        Order ord = new Order();
        Xml2Def.parseDefObj((IDefObj)ord, (Element)xmlOrd);
        ord.setExpr(xmlOrd.getAttributeValue("expr"));
        ord.setAscending(!"desc".equals(xmlOrd.getAttributeValue("orderType")));
        return ord;
    }

    public static Condition parseCondition(Element xml) {
        if (xml == null) {
            return null;
        }
        Condition cnd = new Condition();
        cnd.setExpr(xml.getText());
        return cnd;
    }

    public static String parseContent(Element xml) {
        if (xml == null) {
            return null;
        }
        return xml.getText();
    }
}

