/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.cache;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.cache.DBCacheEntry;
import com.kingdee.bos.ctrl.etl.exception.ETLEOFException;
import com.kingdee.bos.ctrl.etl.exception.ETLFileException;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.io.FilenameUtils;

public class DBCache {
    private static DBCache dbCache;
    private Hashtable cache;
    private boolean usecache;

    public void setActive() {
        this.setActive(true);
    }

    public void setInactive() {
        this.setActive(false);
    }

    public void setActive(boolean act) {
        this.usecache = act;
    }

    public boolean isActive() {
        return this.usecache;
    }

    public void put(DBCacheEntry entry, Row fields) {
        if (!this.usecache) {
            return;
        }
        Row copy = new Row(fields);
        this.cache.put(entry, copy);
    }

    public Row get(DBCacheEntry entry) {
        if (!this.usecache) {
            return null;
        }
        Row fields = (Row)this.cache.get(entry);
        if (fields != null) {
            fields = new Row(fields);
        }
        return fields;
    }

    public int size() {
        return this.cache.size();
    }

    public void clear(String dbname) {
        if (dbname == null) {
            this.cache = new Hashtable();
            this.setActive();
        } else {
            Enumeration keys = this.cache.keys();
            while (keys.hasMoreElements()) {
                DBCacheEntry entry = (DBCacheEntry)keys.nextElement();
                if (!entry.dbname.equalsIgnoreCase(dbname)) continue;
                this.cache.remove(entry);
            }
        }
    }

    public String getFilename() {
        return Const.getETLDirectory() + Const.FILE_SEPARATOR + "db.cache";
    }

    private DBCache() throws ETLFileException {
        try {
            LogWriter log = LogWriter.getInstance();
            this.clear(null);
            String filename = this.getFilename();
            File file = new File(FilenameUtils.normalize((String)filename));
            if (file.canRead()) {
                log.logBasic("DBCache", "Loading database cache from file: [" + filename + "]");
                FileInputStream fis = new FileInputStream(file);
                DataInputStream dis = new DataInputStream(fis);
                int counter = 0;
                try {
                    while (true) {
                        DBCacheEntry entry = new DBCacheEntry(dis);
                        Row row = new Row(dis);
                        this.cache.put(entry, row);
                        ++counter;
                    }
                }
                catch (ETLEOFException eof) {
                    log.logDetailed("DBCache", "We read " + counter + " cached rows from the database cache!");
                }
            } else {
                log.logDetailed("DBCache", "The database cache doesn't exist yet.");
            }
        }
        catch (Exception e) {
            throw new ETLFileException("Couldn't read the database cache", e);
        }
    }

    public void saveCache(LogWriter log) throws ETLFileException {
        FileOutputStream fos = null;
        DataOutputStream dos = null;
        try {
            int counter;
            String filename = this.getFilename();
            File file = new File(FilenameUtils.normalize((String)filename));
            if (!file.exists() || file.canWrite()) {
                fos = new FileOutputStream(file);
                dos = new DataOutputStream(fos);
                counter = 0;
                boolean ok = true;
                Enumeration keys = this.cache.keys();
                while (ok && keys.hasMoreElements()) {
                    DBCacheEntry entry = (DBCacheEntry)keys.nextElement();
                    entry.write(dos);
                    Row row = this.get(entry);
                    if (row != null) {
                        row.write(dos);
                        ++counter;
                        continue;
                    }
                    throw new ETLFileException("The database cache contains an empty row. We can't save this!");
                }
            } else {
                throw new ETLFileException("We can't write to the cache file: " + filename);
            }
            log.logDetailed("DBCache", "We wrote " + counter + " cached rows to the database cache!");
        }
        catch (Exception e) {
            try {
                throw new ETLFileException("Couldn't write to the database cache", e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{dos, fos});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{dos, fos});
    }

    public static final DBCache getInstance() {
        if (dbCache != null) {
            return dbCache;
        }
        try {
            dbCache = new DBCache();
        }
        catch (ETLFileException kfe) {
            throw new RuntimeException("Unable to create the database cache: " + kfe.getMessage());
        }
        return dbCache;
    }
}

