/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.database;

import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Properties;

abstract class BaseDatabaseMeta
implements Cloneable {
    private String name;
    private int accessType;
    private String hostname;
    private String databaseName;
    private int databasePortNumber;
    private String username;
    private String password;
    private String servername;
    private String dataTablespace;
    private String indexTablespace;
    private boolean changed = false;
    private Properties attributes = new Properties();
    private long id;

    public BaseDatabaseMeta(String name, String access, String host, String db, int port, String user, String pass) {
        this();
        this.name = name;
        this.accessType = DatabaseMeta.getAccessType(access);
        this.hostname = host;
        this.databaseName = db;
        this.databasePortNumber = port;
        this.username = user;
        this.password = pass;
        this.servername = null;
    }

    public BaseDatabaseMeta() {
    }

    public int getAccessType() {
        return this.accessType;
    }

    public void setAccessType(int accessType) {
        this.accessType = accessType;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public int getDatabasePortNumber() {
        return this.databasePortNumber;
    }

    public void setDatabasePortNumber(int databasePortNumber) {
        this.databasePortNumber = databasePortNumber;
    }

    abstract int getDatabaseType();

    abstract String getDatabaseTypeDesc();

    abstract String getDatabaseTypeDescLong();

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServername() {
        return this.servername;
    }

    public void setServername(String servername) {
        this.servername = servername;
    }

    public String getDataTablespace() {
        return this.dataTablespace;
    }

    public void setDataTablespace(String dataTablespace) {
        this.dataTablespace = dataTablespace;
    }

    public String getIndexTablespace() {
        return this.indexTablespace;
    }

    public void setIndexTablespace(String indexTablespace) {
        this.indexTablespace = indexTablespace;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Properties getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Properties attributes) {
        this.attributes = attributes;
    }

    public Object clone() {
        BaseDatabaseMeta retval = null;
        try {
            retval = (BaseDatabaseMeta)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return retval;
    }

    public int getDefaultDatabasePort() {
        return -1;
    }

    public boolean supportsSetCharacterStream() {
        return true;
    }

    public boolean supportsAutoInc() {
        return true;
    }

    public String getLimitClause(int nrRows) {
        return "";
    }

    public int getNotFoundTK(boolean use_autoinc) {
        return 0;
    }

    public String getSQLNextSequenceValue(String sequenceName) {
        return "";
    }

    public String getSQLCurrentSequenceValue(String sequenceName) {
        return "";
    }

    public String getSQLSequenceExists(String sequenceName) {
        return "";
    }

    public boolean isFetchSizeSupported() {
        return true;
    }

    public boolean needsPlaceHolder() {
        return false;
    }

    public boolean supportsSchemas() {
        return true;
    }

    public boolean supportsEmptyTransactions() {
        return true;
    }

    public String getFunctionSum() {
        return "SUM";
    }

    public String getFunctionAverage() {
        return "AVG";
    }

    public String getFunctionMinimum() {
        return "MIN";
    }

    public String getFunctionMaximum() {
        return "MAX";
    }

    public String getFunctionCount() {
        return "COUNT";
    }

    public String getSchemaTableCombination(String schema_name, String table_part) {
        return schema_name + "." + table_part;
    }

    public int getMaxTextFieldLength() {
        return 9999999;
    }

    public boolean supportsTransactions() {
        return true;
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsBitmapIndex() {
        return true;
    }

    public boolean supportsSetLong() {
        return true;
    }

    public String getDropColumnStatement(String tablename, Value v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " DROP " + v.getName() + Const.CR;
    }

    public String[] getReservedWords() {
        return new String[0];
    }

    public boolean quoteReservedWords() {
        return true;
    }

    public String getStartQuote() {
        return "\"";
    }

    public String getEndQuote() {
        return "\"";
    }

    public boolean supportsRepository() {
        return true;
    }

    public String[] getTableTypes() {
        return new String[]{"TABLE"};
    }

    public String[] getViewTypes() {
        return new String[]{"VIEW"};
    }

    public String[] getSynonymTypes() {
        return new String[]{"SYNONYM"};
    }

    public boolean useSchemaNameForTableList() {
        return false;
    }

    public boolean supportsViews() {
        return true;
    }

    public boolean supportsSynonyms() {
        return false;
    }

    public String getSQLListOfProcedures() {
        return null;
    }

    public String getTruncateTableStatement(String tableName) {
        return "TRUNCATE TABLE " + tableName;
    }

    public String getSQLQueryFields(String tableName) {
        return "SELECT * FROM " + tableName;
    }

    public boolean supportsFloatRoundingOnUpdate() {
        return true;
    }

    public String getSQLLockTables(String[] tableNames) {
        return null;
    }

    public String getSQLUnlockTables(String[] tableNames) {
        return null;
    }

    public boolean supportsTimeStampToDateConversion() {
        return true;
    }

    public boolean supportsBatchUpdates() {
        return true;
    }

    public boolean supportsBooleanDataType() {
        return false;
    }
}

