/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.database;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.database.DatabaseInterface;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.Encr;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.util.XMLInterface;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Node;

public class DatabaseMeta
implements Cloneable,
XMLInterface {
    private DatabaseInterface databaseInterface;
    private static DatabaseInterface[] allDatabaseInterfaces;
    private Connection ctxConnection = null;
    public static final int TYPE_DATABASE_NONE = 0;
    public static final int TYPE_DATABASE_MSSQL = 2;
    public static final int TYPE_DATABASE_ORACLE = 4;
    public static final int TYPE_DATABASE_DB2 = 8;
    public static final int TYPE_DATABASE_AS400 = 16;
    public static final int TYPE_DATABASE_CACHE = 32;
    public static final int TYPE_DATABASE_CONTEXT = 64;
    public static final int TYPE_ACCESS_NATIVE = 0;
    public static final int TYPE_ACCESS_ODBC = 1;
    public static final int TYPE_ACCESS_OCI = 2;
    public static final String[] access_type_desc;
    public static final String[] db_access_desc_long;
    public static final int CLOB_LENGTH = 9999999;

    public DatabaseMeta(String name, String type, String access, String host, String db, int port, String user, String pass) {
        this.setValues(name, type, access, host, db, port, user, pass);
    }

    public DatabaseMeta(Connection ctxConnection) {
        this.ctxConnection = ctxConnection;
        this.setValues("", "CONTEXT", "", "", "", 0, "", "");
    }

    public DatabaseMeta() {
    }

    public Connection connect() throws ETLDatabaseException {
        Connection con = null;
        con = this.getName().equalsIgnoreCase("") ? this.getContextConnection() : this.connect(this.getDriverClass());
        return con;
    }

    private Connection connect(String classname) throws ETLDatabaseException {
        Connection con = null;
        try {
            Class.forName(classname);
        }
        catch (NoClassDefFoundError e) {
            throw new ETLDatabaseException("Exception while loading class", e);
        }
        catch (ClassNotFoundException e) {
            throw new ETLDatabaseException("Exception while loading class", e);
        }
        catch (Exception e) {
            throw new ETLDatabaseException("Exception while loading class", e);
        }
        try {
            con = DriverManager.getConnection(this.getURL(), this.getUsername(), this.getPassword());
        }
        catch (SQLException e) {
            throw new ETLDatabaseException("Error connecting to database: (using class " + classname + ")", e);
        }
        catch (Throwable e) {
            throw new ETLDatabaseException("Error connecting to database: (using class " + classname + ")", e);
        }
        return con;
    }

    public void close(Connection con) throws SQLException {
        if (!this.getName().equalsIgnoreCase("")) {
            con.close();
        }
    }

    public DatabaseInterface getDatabaseInterface() {
        return this.databaseInterface;
    }

    public void setDatabaseInterface(DatabaseInterface databaseInterface) {
        this.databaseInterface = databaseInterface;
    }

    private static final DatabaseInterface getDatabaseInterface(String databaseType) throws ETLDatabaseException {
        return (DatabaseInterface)DatabaseMeta.findDatabaseInterface(databaseType).clone();
    }

    private static final DatabaseInterface findDatabaseInterface(String databaseTypeDesc) throws ETLDatabaseException {
        DatabaseInterface[] di = DatabaseMeta.getDatabaseInterfaces();
        for (int i = 0; i < di.length; ++i) {
            if (!di[i].getDatabaseTypeDesc().equalsIgnoreCase(databaseTypeDesc) && !di[i].getDatabaseTypeDescLong().equalsIgnoreCase(databaseTypeDesc)) continue;
            return di[i];
        }
        throw new ETLDatabaseException("database type [" + databaseTypeDesc + "] couldn't be found!");
    }

    public DatabaseMeta(Repository rep, long id_database) throws ETLException {
        this();
        if (id_database == 0L) {
            this.ctxConnection = rep.getCtxConnection();
            this.setValues("", "CONTEXT", "", "", "", 0, "", "");
            return;
        }
        try {
            Row r = rep.getDatabase(id_database);
            if (r != null) {
                long id_database_type = r.getInteger("ID_DBType", 0L);
                String dbTypeDesc = rep.getDatabaseTypeCode(id_database_type);
                if (dbTypeDesc == null) {
                    throw new ETLException("No database type was specified [id_database_type=" + id_database_type + "]");
                }
                this.databaseInterface = DatabaseMeta.getDatabaseInterface(dbTypeDesc);
                this.setAttributes(new Properties());
                this.setID(id_database);
                this.setName(r.getString("NAME", ""));
                long id_database_contype = r.getInteger("ID_DBConnectType", 0L);
                this.setAccessType(DatabaseMeta.getAccessType(rep.getDatabaseConTypeCode(id_database_contype)));
                this.setHostname(r.getString("HostName", ""));
                this.setDBName(r.getString("DababaseName", ""));
                this.setDBPort((int)r.getInteger("Port", -1L));
                this.setUsername(r.getString("Username", ""));
                this.setPassword(r.getString("Password", ""));
                if (this.getPassword() != null && this.getPassword().startsWith("Encrypted ")) {
                    this.setPassword(Encr.decryptPassword(this.getPassword().substring(10)));
                } else {
                    this.setPassword(Encr.decryptPassword(this.getPassword()));
                }
            }
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Error loading database connection from repository (id_database=" + id_database + ")", dbe);
        }
    }

    public void saveRep(Repository rep) throws ETLException {
        try {
            if (this.getID() <= 0L) {
                this.setID(rep.getDatabaseID(this.getName()));
            }
            if (this.getID() <= 0L) {
                this.setID(rep.insertDatabase(this.getName(), DatabaseMeta.getDBTypeDesc(this.getDatabaseType()), DatabaseMeta.getAccessTypeDesc(this.getAccessType()), this.getHostname(), this.getDatabaseName(), this.getDatabasePortNumber(), this.getUsername(), this.getPassword()));
            } else {
                rep.updateDatabase(this.getID(), this.getName(), DatabaseMeta.getDBTypeDesc(this.getDatabaseType()), DatabaseMeta.getAccessTypeDesc(this.getAccessType()), this.getHostname(), this.getDatabaseName(), this.getDatabasePortNumber(), this.getUsername(), this.getPassword());
            }
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Error saving database connection or one of its attributes to the repository.", dbe);
        }
    }

    public long getID() {
        return this.databaseInterface.getId();
    }

    public void setID(long id) {
        this.databaseInterface.setId(id);
    }

    public Object clone() {
        DatabaseMeta di = new DatabaseMeta(this.getName(), this.getDatabaseTypeDesc(), this.getAccessTypeDesc(), this.getHostname(), this.getDatabaseName(), this.getDatabasePortNumber(), this.getUsername(), this.getPassword());
        di.setDataTablespace(this.getDataTablespace());
        di.setIndexTablespace(this.getIndexTablespace());
        return di;
    }

    public void setValues(String name, String type, String access, String host, String db, int port, String user, String pass) {
        try {
            this.databaseInterface = DatabaseMeta.getDatabaseInterface(type);
        }
        catch (ETLDatabaseException kde) {
            throw new RuntimeException("Database type not found!", kde);
        }
        this.setName(name);
        this.setAccessType(DatabaseMeta.getAccessType(access));
        this.setHostname(host);
        this.setDBName(db);
        this.setDBPort(port);
        this.setUsername(user);
        this.setPassword(pass);
        this.setChanged(false);
    }

    public void setDatabaseType(String type) {
        DatabaseInterface oldInterface = this.databaseInterface;
        try {
            this.databaseInterface = DatabaseMeta.getDatabaseInterface(type);
        }
        catch (ETLDatabaseException kde) {
            throw new RuntimeException("Database type [" + type + "] not found!", kde);
        }
        this.setName(oldInterface.getName());
        this.setAccessType(oldInterface.getAccessType());
        this.setHostname(oldInterface.getHostname());
        this.setDBName(oldInterface.getDatabaseName());
        this.setDBPort(oldInterface.getDatabasePortNumber());
        this.setUsername(oldInterface.getUsername());
        this.setPassword(oldInterface.getPassword());
        this.setDataTablespace(oldInterface.getDataTablespace());
        this.setIndexTablespace(oldInterface.getIndexTablespace());
        this.setChanged(oldInterface.isChanged());
    }

    public void setValues(DatabaseMeta info) {
        this.databaseInterface = (DatabaseInterface)info.databaseInterface.clone();
    }

    public void setName(String name) {
        this.databaseInterface.setName(name);
    }

    public String getName() {
        return this.databaseInterface.getName();
    }

    public int getDatabaseType() {
        return this.databaseInterface.getDatabaseType();
    }

    public int getAccessType() {
        return this.databaseInterface.getAccessType();
    }

    public void setAccessType(int access_type) {
        this.databaseInterface.setAccessType(access_type);
    }

    public String getDatabaseTypeDesc() {
        return this.databaseInterface.getDatabaseTypeDesc();
    }

    public String getAccessTypeDesc() {
        return access_type_desc[this.getAccessType()];
    }

    public String getHostname() {
        return this.databaseInterface.getHostname();
    }

    public void setHostname(String hostname) {
        this.databaseInterface.setHostname(hostname);
    }

    public int getDatabasePortNumber() {
        return this.databaseInterface.getDatabasePortNumber();
    }

    public void setDBPort(int db_port) {
        this.databaseInterface.setDatabasePortNumber(db_port);
    }

    public String getDatabaseName() {
        return this.databaseInterface.getDatabaseName();
    }

    public void setDBName(String databaseName) {
        this.databaseInterface.setDatabaseName(databaseName);
    }

    public String getUsername() {
        return this.databaseInterface.getUsername();
    }

    public void setUsername(String username) {
        this.databaseInterface.setUsername(username);
    }

    public String getPassword() {
        return this.databaseInterface.getPassword();
    }

    public void setPassword(String password) {
        this.databaseInterface.setPassword(password);
    }

    public String getDataTablespace() {
        return this.databaseInterface.getDataTablespace();
    }

    public void setDataTablespace(String data_tablespace) {
        this.databaseInterface.setDataTablespace(data_tablespace);
    }

    public String getIndexTablespace() {
        return this.databaseInterface.getIndexTablespace();
    }

    public void setIndexTablespace(String index_tablespace) {
        this.databaseInterface.setIndexTablespace(index_tablespace);
    }

    public void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean ch) {
        this.databaseInterface.setChanged(ch);
    }

    public boolean hasChanged() {
        return this.databaseInterface.isChanged();
    }

    public String toString() {
        return this.getName();
    }

    public Properties getAttributes() {
        return this.databaseInterface.getAttributes();
    }

    public void setAttributes(Properties attributes) {
        this.databaseInterface.setAttributes(attributes);
    }

    public DatabaseMeta(String xml) throws ETLXMLException {
        this(XMLHandler.getSubNode(XMLHandler.loadXMLString(xml), "connection"));
    }

    public DatabaseMeta(Node con) throws ETLXMLException {
        this();
        try {
            Node attrsnode;
            String type = XMLHandler.getTagValue(con, "type");
            try {
                this.databaseInterface = DatabaseMeta.getDatabaseInterface(type);
            }
            catch (ETLDatabaseException kde) {
                throw new ETLXMLException("Unable to create new database interface", kde);
            }
            this.setName(XMLHandler.getTagValue(con, "name"));
            this.setHostname(XMLHandler.getTagValue(con, "server"));
            String acc = XMLHandler.getTagValue(con, "access");
            this.setAccessType(DatabaseMeta.getAccessType(acc));
            this.setDBName(XMLHandler.getTagValue(con, "database"));
            this.setDBPort(Const.toInt(XMLHandler.getTagValue(con, "port"), -1));
            this.setUsername(XMLHandler.getTagValue(con, "username"));
            this.setPassword(XMLHandler.getTagValue(con, "password"));
            this.setDataTablespace(XMLHandler.getTagValue(con, "data_tablespace"));
            this.setIndexTablespace(XMLHandler.getTagValue(con, "index_tablespace"));
            if (this.getPassword() != null && this.getPassword().startsWith("Encrypted ")) {
                this.setPassword(Encr.decryptPassword(this.getPassword().substring(10)));
            }
            if ((attrsnode = XMLHandler.getSubNode(con, "attributes")) != null) {
                int nr = XMLHandler.countNodes(attrsnode, "attribute");
                for (int i = 0; i < nr; ++i) {
                    Node attrnode = XMLHandler.getSubNodeByNr(attrsnode, "attribute", i);
                    String code = XMLHandler.getTagValue(attrnode, "code");
                    String attribute = XMLHandler.getTagValue(attrnode, "attribute");
                    if (code == null || attribute == null) continue;
                    this.getAttributes().put(code, attribute);
                }
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load database connection info from XML node", e);
        }
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + "  <connection>" + Const.CR;
        retval = retval + "    " + XMLHandler.addTagValue("name", this.getName());
        retval = retval + "    " + XMLHandler.addTagValue("server", this.getHostname());
        retval = retval + "    " + XMLHandler.addTagValue("type", this.getDatabaseTypeDesc());
        retval = retval + "    " + XMLHandler.addTagValue("access", this.getAccessTypeDesc());
        retval = retval + "    " + XMLHandler.addTagValue("database", this.getDatabaseName());
        retval = retval + "    " + XMLHandler.addTagValue("port", this.getDatabasePortNumber());
        retval = retval + "    " + XMLHandler.addTagValue("username", this.getUsername());
        retval = retval + "    " + XMLHandler.addTagValue("password", "Encrypted " + Encr.encryptPassword(this.getPassword()));
        retval = retval + "    " + XMLHandler.addTagValue("data_tablespace", this.getDataTablespace());
        retval = retval + "    " + XMLHandler.addTagValue("index_tablespace", this.getIndexTablespace());
        retval = retval + "    <attributes>" + Const.CR;
        ArrayList<Object> list = new ArrayList<Object>(this.getAttributes().keySet());
        Collections.sort(list);
        for (String string : list) {
            String attribute = this.getAttributes().getProperty(string);
            retval = retval + "      <attribute>" + XMLHandler.addTagValue("code", string, false) + XMLHandler.addTagValue("attribute", attribute, false) + "</attribute>" + Const.CR;
        }
        retval = retval + "    </attributes>" + Const.CR;
        retval = retval + "  </connection>" + Const.CR;
        return retval;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        return this.getName().equals(((DatabaseMeta)obj).getName());
    }

    public String getURL() {
        return this.databaseInterface.getURL();
    }

    public boolean supportsAutoinc() {
        return this.databaseInterface.supportsAutoInc();
    }

    public boolean supportsSequences() {
        return this.databaseInterface.supportsSequences();
    }

    public String getSQLSequenceExists(String sequenceName) {
        return this.databaseInterface.getSQLSequenceExists(sequenceName);
    }

    public boolean supportsBitmapIndex() {
        return this.databaseInterface.supportsBitmapIndex();
    }

    public boolean supportsSetLong() {
        return this.databaseInterface.supportsSetLong();
    }

    public boolean supportsSchemas() {
        return this.databaseInterface.supportsSchemas();
    }

    public boolean supportsEmptyTransactions() {
        return this.databaseInterface.supportsEmptyTransactions();
    }

    public boolean supportsSetCharacterStream() {
        return this.databaseInterface.supportsSetCharacterStream();
    }

    public int getMaxTextFieldLength() {
        return this.databaseInterface.getMaxTextFieldLength();
    }

    public static final int getDatabaseType(String dbTypeDesc) {
        try {
            DatabaseInterface di = DatabaseMeta.getDatabaseInterface(dbTypeDesc);
            return di.getDatabaseType();
        }
        catch (ETLDatabaseException kde) {
            return 0;
        }
    }

    public static final String getDBTypeDesc(int dbtype) {
        DatabaseInterface[] di = DatabaseMeta.getDatabaseInterfaces();
        for (int i = 0; i < di.length; ++i) {
            if (di[i].getDatabaseType() != dbtype) continue;
            return di[i].getDatabaseTypeDesc();
        }
        return null;
    }

    public static final int getAccessType(String dbaccess) {
        int i;
        if (dbaccess == null) {
            return 0;
        }
        for (i = 0; i < access_type_desc.length; ++i) {
            if (!access_type_desc[i].equalsIgnoreCase(dbaccess)) continue;
            return i;
        }
        for (i = 0; i < db_access_desc_long.length; ++i) {
            if (!db_access_desc_long[i].equalsIgnoreCase(dbaccess)) continue;
            return i;
        }
        return 0;
    }

    public static final String getAccessTypeDesc(int dbaccess) {
        if (dbaccess < 0) {
            return null;
        }
        if (dbaccess > access_type_desc.length) {
            return null;
        }
        return access_type_desc[dbaccess];
    }

    public static final String getAccessTypeDescLong(int dbaccess) {
        if (dbaccess < 0) {
            return null;
        }
        if (dbaccess > db_access_desc_long.length) {
            return null;
        }
        return db_access_desc_long[dbaccess];
    }

    public static final String[] getDBTypeDescLongList() {
        DatabaseInterface[] di = DatabaseMeta.getDatabaseInterfaces();
        String[] retval = new String[di.length];
        for (int i = 0; i < di.length; ++i) {
            retval[i] = di[i].getDatabaseTypeDescLong();
        }
        return retval;
    }

    public static final String[] getDBTypeDescList() {
        DatabaseInterface[] di = DatabaseMeta.getDatabaseInterfaces();
        String[] retval = new String[di.length];
        for (int i = 0; i < di.length; ++i) {
            retval[i] = di[i].getDatabaseTypeDesc();
        }
        return retval;
    }

    public static final DatabaseInterface[] getDatabaseInterfaces() {
        if (allDatabaseInterfaces != null) {
            return allDatabaseInterfaces;
        }
        Class[] ic = DatabaseInterface.implementingClasses;
        allDatabaseInterfaces = new DatabaseInterface[ic.length];
        for (int i = 0; i < ic.length; ++i) {
            try {
                Class.forName(ic[i].getName());
                DatabaseMeta.allDatabaseInterfaces[i] = (DatabaseInterface)ic[i].newInstance();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating class for : " + ic[i].getName(), e);
            }
        }
        return allDatabaseInterfaces;
    }

    public static final int[] getAccessTypeList(String dbTypeDesc) {
        try {
            DatabaseInterface di = DatabaseMeta.findDatabaseInterface(dbTypeDesc);
            return di.getAccessTypeList();
        }
        catch (ETLDatabaseException kde) {
            return null;
        }
    }

    public static final int getPortForDBType(String strtype, String straccess) {
        try {
            DatabaseInterface di = DatabaseMeta.getDatabaseInterface(strtype);
            di.setAccessType(DatabaseMeta.getAccessType(straccess));
            return di.getDefaultDatabasePort();
        }
        catch (ETLDatabaseException kde) {
            return -1;
        }
    }

    public int getDefaultDatabasePort() {
        return this.databaseInterface.getDefaultDatabasePort();
    }

    public int getNotFoundTK(boolean use_autoinc) {
        return this.databaseInterface.getNotFoundTK(use_autoinc);
    }

    public String getDriverClass() {
        return this.databaseInterface.getDriverClass();
    }

    public String stripCR(String sbsql) {
        return this.stripCR(new StringBuffer(sbsql));
    }

    public String stripCR(StringBuffer sbsql) {
        if (this.getDatabaseType() == 8 || this.getDatabaseType() == 32) {
            for (int i = sbsql.length() - 1; i >= 0; --i) {
                if (sbsql.charAt(i) != '\n' && sbsql.charAt(i) != '\r') continue;
                sbsql.setCharAt(i, ' ');
            }
        }
        return sbsql.toString();
    }

    public String getSeqNextvalSQL(String sequenceName) {
        return this.databaseInterface.getSQLNextSequenceValue(sequenceName);
    }

    public String getSQLCurrentSequenceValue(String sequenceName) {
        return this.databaseInterface.getSQLCurrentSequenceValue(sequenceName);
    }

    public boolean isFetchSizeSupported() {
        return this.databaseInterface.isFetchSizeSupported();
    }

    public boolean needsPlaceHolder() {
        return this.databaseInterface.needsPlaceHolder();
    }

    public String getFunctionSum() {
        return this.databaseInterface.getFunctionSum();
    }

    public String getFunctionAverage() {
        return this.databaseInterface.getFunctionAverage();
    }

    public String getFunctionMaximum() {
        return this.databaseInterface.getFunctionMaximum();
    }

    public String getFunctionMinimum() {
        return this.databaseInterface.getFunctionMinimum();
    }

    public String getFunctionCount() {
        return this.databaseInterface.getFunctionCount();
    }

    public String[] checkParameters() {
        ArrayList<String> remarks = new ArrayList<String>();
        if (this.getDatabaseType() == 0) {
            remarks.add("No database type was choosen");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            remarks.add("Please give this database connection a name");
        }
        return remarks.toArray(new String[remarks.size()]);
    }

    public String getSchemaTableCombination(String schema_name, String table_part) {
        return this.databaseInterface.getSchemaTableCombination(schema_name, table_part);
    }

    public boolean isClob(Value v) {
        boolean retval = true;
        if (v != null && v.getLength() >= 9999999) {
            return true;
        }
        retval = false;
        return retval;
    }

    public String getFieldDefinition(Value v, String tk, String pk, boolean use_autoinc) {
        return this.getFieldDefinition(v, tk, pk, use_autoinc, true, true);
    }

    public String getFieldDefinition(Value v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        return this.databaseInterface.getFieldDefinition(v, tk, pk, use_autoinc, add_fieldname, add_cr);
    }

    public String getLimitClause(int nrRows) {
        return this.databaseInterface.getLimitClause(nrRows);
    }

    public String getSQLQueryFields(String tableName) {
        return this.databaseInterface.getSQLQueryFields(tableName);
    }

    public String getAddColumnStatement(String tablename, Value v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        String retval = this.databaseInterface.getAddColumnStatement(tablename, v, tk, use_autoinc, pk, semicolon);
        retval = retval + Const.CR;
        if (semicolon) {
            retval = retval + ";" + Const.CR;
        }
        return retval;
    }

    public String getDropColumnStatement(String tablename, Value v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        String retval = this.databaseInterface.getDropColumnStatement(tablename, v, tk, use_autoinc, pk, semicolon);
        retval = retval + Const.CR;
        if (semicolon) {
            retval = retval + ";" + Const.CR;
        }
        return retval;
    }

    public String getModifyColumnStatement(String tablename, Value v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        String retval = this.databaseInterface.getModifyColumnStatement(tablename, v, tk, use_autoinc, pk, semicolon);
        retval = retval + Const.CR;
        if (semicolon) {
            retval = retval + ";" + Const.CR;
        }
        return retval;
    }

    public String[] getReservedWords() {
        return this.databaseInterface.getReservedWords();
    }

    public boolean quoteReservedWords() {
        return this.databaseInterface.quoteReservedWords();
    }

    public String getStartQuote() {
        return this.databaseInterface.getStartQuote();
    }

    public String getEndQuote() {
        return this.databaseInterface.getEndQuote();
    }

    public String quoteField(String field) {
        if (this.isReservedWord(field) && this.quoteReservedWords()) {
            return this.getStartQuote() + field + this.getEndQuote();
        }
        return field;
    }

    public boolean isReservedWord(String word) {
        String[] reserved = this.getReservedWords();
        return Const.indexOfString(word, reserved) >= 0;
    }

    public boolean replaceReservedWords(Row fields) {
        boolean hasReservedWords = false;
        for (int i = 0; i < fields.size(); ++i) {
            Value v = fields.getValue(i);
            if (!this.isReservedWord(v.getName())) continue;
            hasReservedWords = true;
            v.setName(this.quoteField(v.getName()));
        }
        return hasReservedWords;
    }

    public int getNrReservedWords(Row fields) {
        int nrReservedWords = 0;
        for (int i = 0; i < fields.size(); ++i) {
            Value v = fields.getValue(i);
            if (!this.isReservedWord(v.getName())) continue;
            ++nrReservedWords;
        }
        return nrReservedWords;
    }

    public String[] getTableTypes() {
        return this.databaseInterface.getTableTypes();
    }

    public String[] getViewTypes() {
        return this.databaseInterface.getViewTypes();
    }

    public String[] getSynonymTypes() {
        return this.databaseInterface.getSynonymTypes();
    }

    public boolean useSchemaNameForTableList() {
        return this.databaseInterface.useSchemaNameForTableList();
    }

    public boolean supportsViews() {
        return this.databaseInterface.supportsViews();
    }

    public boolean supportsSynonyms() {
        return this.databaseInterface.supportsSynonyms();
    }

    public String getSQLListOfProcedures() {
        return this.databaseInterface.getSQLListOfProcedures();
    }

    public String getTruncateTableStatement(String tableName) {
        return this.databaseInterface.getTruncateTableStatement(tableName);
    }

    public boolean supportsFloatRoundingOnUpdate() {
        return this.databaseInterface.supportsFloatRoundingOnUpdate();
    }

    public String getSQLLockTables(String[] tableNames) {
        return this.databaseInterface.getSQLLockTables(tableNames);
    }

    public String getSQLUnlockTables(String[] tableNames) {
        return this.databaseInterface.getSQLUnlockTables(tableNames);
    }

    public List getFeatureSummary() {
        ArrayList<Row> list = new ArrayList<Row>();
        Row r = null;
        String par = "Parameter";
        String val = "Value";
        Value testValue = new Value("FIELD", 2);
        testValue.setLength(30);
        if (this.databaseInterface != null) {
            int i;
            r = new Row();
            r.addValue(new Value("Parameter", "Database type"));
            r.addValue(new Value("Value", this.getDatabaseTypeDesc()));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "Access type"));
            r.addValue(new Value("Value", this.getAccessTypeDesc()));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "Database name"));
            r.addValue(new Value("Value", this.getDatabaseName()));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "Server hostname"));
            r.addValue(new Value("Value", this.getHostname()));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "Service port"));
            r.addValue(new Value("Value", (long)this.getDatabasePortNumber()));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "Username"));
            r.addValue(new Value("Value", this.getUsername()));
            list.add(r);
            Enumeration<Object> keys = this.getAttributes().keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = this.getAttributes().getProperty(key);
                r = new Row();
                r.addValue(new Value("Parameter", "Extra attribute [" + key + "]"));
                r.addValue(new Value("Value", value));
                list.add(r);
            }
            r = new Row();
            r.addValue(new Value("Parameter", "Driver class"));
            r.addValue(new Value("Value", this.getDriverClass()));
            list.add(r);
            String pwd = this.getPassword();
            this.setPassword("password");
            r = new Row();
            r.addValue(new Value("Parameter", "URL"));
            r.addValue(new Value("Value", this.getURL()));
            list.add(r);
            this.setPassword(pwd);
            r = new Row();
            r.addValue(new Value("Parameter", "SQL: next sequence value"));
            r.addValue(new Value("Value", this.getSeqNextvalSQL("SEQUENCE")));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "supported: set fetch size"));
            r.addValue(new Value("Value", this.isFetchSizeSupported()));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "auto increment field needs placeholder"));
            r.addValue(new Value("Value", this.needsPlaceHolder()));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "SUM aggregate function"));
            r.addValue(new Value("Value", this.getFunctionSum()));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "AVG aggregate function"));
            r.addValue(new Value("Value", this.getFunctionAverage()));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "MIN aggregate function"));
            r.addValue(new Value("Value", this.getFunctionMinimum()));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "MAX aggregate function"));
            r.addValue(new Value("Value", this.getFunctionMaximum()));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "COUNT aggregate function"));
            r.addValue(new Value("Value", this.getFunctionCount()));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "Schema / Table combination"));
            r.addValue(new Value("Value", this.getSchemaTableCombination("SCHEMA", "TABLE")));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "LIMIT clause for 100 rows"));
            r.addValue(new Value("Value", this.getLimitClause(100)));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "Add column statement"));
            r.addValue(new Value("Value", this.getAddColumnStatement("TABLE", testValue, null, false, null, false)));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "Drop column statement"));
            r.addValue(new Value("Value", this.getDropColumnStatement("TABLE", testValue, null, false, null, false)));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "Modify column statement"));
            r.addValue(new Value("Value", this.getModifyColumnStatement("TABLE", testValue, null, false, null, false)));
            list.add(r);
            String reserved = "";
            if (this.getReservedWords() != null) {
                for (int i2 = 0; i2 < this.getReservedWords().length; ++i2) {
                    reserved = reserved + (i2 > 0 ? ", " : "") + this.getReservedWords()[i2];
                }
            }
            r = new Row();
            r.addValue(new Value("Parameter", "List of reserved words"));
            r.addValue(new Value("Value", reserved));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "Quote reserved words?"));
            r.addValue(new Value("Value", this.quoteReservedWords()));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "Start quote for reserved words"));
            r.addValue(new Value("Value", this.getStartQuote()));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "End quote for reserved words"));
            r.addValue(new Value("Value", this.getEndQuote()));
            list.add(r);
            String types = "";
            String[] slist = this.getTableTypes();
            if (slist != null) {
                for (i = 0; i < slist.length; ++i) {
                    types = types + (i > 0 ? ", " : "") + slist[i];
                }
            }
            r = new Row();
            r.addValue(new Value("Parameter", "List of JDBC table types"));
            r.addValue(new Value("Value", types));
            list.add(r);
            types = "";
            slist = this.getViewTypes();
            if (slist != null) {
                for (i = 0; i < slist.length; ++i) {
                    types = types + (i > 0 ? ", " : "") + slist[i];
                }
            }
            r = new Row();
            r.addValue(new Value("Parameter", "List of JDBC view types"));
            r.addValue(new Value("Value", types));
            list.add(r);
            types = "";
            slist = this.getSynonymTypes();
            if (slist != null) {
                for (i = 0; i < slist.length; ++i) {
                    types = types + (i > 0 ? ", " : "") + slist[i];
                }
            }
            r = new Row();
            r.addValue(new Value("Parameter", "List of JDBC synonym types"));
            r.addValue(new Value("Value", types));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "use schema name to get table list?"));
            r.addValue(new Value("Value", this.useSchemaNameForTableList()));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "supports views?"));
            r.addValue(new Value("Value", this.supportsViews()));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "supports synonyms?"));
            r.addValue(new Value("Value", this.supportsSynonyms()));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "SQL: list of procedures"));
            r.addValue(new Value("Value", this.getSQLListOfProcedures()));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "SQL: truncate table"));
            r.addValue(new Value("Value", this.getTruncateTableStatement("TABLE")));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "supports floating point rounding on update/insert"));
            r.addValue(new Value("Value", this.supportsFloatRoundingOnUpdate()));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "supports timestamp-date conversion"));
            r.addValue(new Value("Value", this.supportsTimeStampToDateConversion()));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "supports batch updates"));
            r.addValue(new Value("Value", this.supportsBatchUpdates()));
            list.add(r);
            r = new Row();
            r.addValue(new Value("Parameter", "supports boolean data type"));
            r.addValue(new Value("Value", this.supportsBooleanDataType()));
            list.add(r);
        }
        return list;
    }

    public boolean supportsTimeStampToDateConversion() {
        return this.databaseInterface.supportsTimeStampToDateConversion();
    }

    public boolean supportsBatchUpdates() {
        return this.databaseInterface.supportsBatchUpdates();
    }

    public boolean supportsBooleanDataType() {
        return this.databaseInterface.supportsBooleanDataType();
    }

    public Connection getContextConnection() {
        return this.ctxConnection;
    }

    static {
        access_type_desc = new String[]{"Native", "ODBC", "OCI"};
        db_access_desc_long = new String[]{"Native (JDBC)", "ODBC", "OCI"};
    }
}

