/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.job;

import com.kingdee.bos.ctrl.etl.base.Result;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLJobException;
import com.kingdee.bos.ctrl.etl.job.JobEntryResult;
import com.kingdee.bos.ctrl.etl.job.JobHopMeta;
import com.kingdee.bos.ctrl.etl.job.JobLog;
import com.kingdee.bos.ctrl.etl.job.JobMeta;
import com.kingdee.bos.ctrl.etl.job.entry.JobEntryCopy;
import com.kingdee.bos.ctrl.etl.job.entry.JobEntryInterface;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.schedule.Scheduleable;
import com.kingdee.bos.ctrl.etl.transformation.StepLoader;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import java.util.ArrayList;
import java.util.Date;

public class Job
extends Thread
implements Scheduleable {
    private LogWriter log;
    private JobMeta jobinfo;
    private Repository rep;
    private ArrayList jobEntryResults;
    private Date startDate;
    private Date endDate;
    private Date currentDate;
    private Date logDate;
    private Date depDate;
    private Date startTime;
    private Date endTime;
    private boolean active;
    private boolean stopped;

    public Job(LogWriter lw, String name, String file, String[] args) {
        this.log = lw;
        this.jobinfo = new JobMeta(this.log);
        this.jobinfo.setName(name);
        this.jobinfo.setFilename(file);
        this.jobinfo.arguments = args;
        this.active = false;
        this.stopped = false;
    }

    public Job(LogWriter lw, StepLoader steploader, Repository rep, JobMeta ti) {
        this.log = lw;
        this.rep = rep;
        this.jobinfo = ti;
        this.active = false;
        this.stopped = false;
    }

    public void open(Repository rep, String fname, String jobname, String dirname) throws ETLException {
        this.rep = rep;
        this.jobinfo = rep != null ? new JobMeta(this.log, rep, jobname, rep.getDirectoryTree().findDirectory(dirname)) : new JobMeta(this.log, fname, null);
    }

    public long getJobid() {
        if (this.jobinfo == null) {
            return -1L;
        }
        return this.jobinfo.getID();
    }

    public String getJobname() {
        if (this.jobinfo == null) {
            return null;
        }
        return this.jobinfo.getName();
    }

    public String getJobDesc() {
        if (this.jobinfo == null) {
            return null;
        }
        return this.jobinfo.getDescription();
    }

    public String getModifiedUser() {
        if (this.jobinfo == null) {
            return null;
        }
        return this.jobinfo.getModifiedUser();
    }

    public String getModifiedDate() {
        if (this.jobinfo == null) {
            return null;
        }
        return this.jobinfo.getModifiedDate();
    }

    public JobLog getJoblog() {
        if (this.jobinfo == null) {
            return null;
        }
        return this.jobinfo.getJoblog();
    }

    public void setRepository(Repository rep) {
        this.rep = rep;
    }

    @Override
    public void run() {
        try {
            this.execute();
            this.endProcessing("end");
        }
        catch (ETLJobException eTLJobException) {
            // empty catch block
        }
    }

    public Result execute() throws ETLJobException {
        if (this.jobEntryResults != null) {
            this.jobEntryResults.clear();
        } else {
            this.jobEntryResults = new ArrayList();
        }
        this.active = true;
        Result res = this.execute(1, null, null, null, "start");
        JobEntryResult jer = new JobEntryResult(res);
        jer.setComment("Job execution ended");
        this.jobEntryResults.add(jer);
        this.active = false;
        return res;
    }

    public Result execute(int nr, Result result) throws ETLJobException {
        Result res = this.execute(nr, result, null, null, "start of job entry");
        return res;
    }

    private Result execute(int nr, Result prev_result, JobEntryCopy startpoint, JobEntryCopy previous, String comment) throws ETLJobException {
        Result res = null;
        JobEntryResult jer = new JobEntryResult();
        jer.setJobName(this.getJobinfo().getName());
        if (this.stopped) {
            res = new Result(nr);
            res.stopped = true;
            return res;
        }
        this.log.startStringCapture();
        this.log.setString("START" + Const.CR);
        this.log.logDetailed(this.toString(), "exec(" + nr + ", " + (prev_result != null ? prev_result.getNrErrors() : 0L) + ", " + (startpoint != null ? startpoint.toString() : "null") + ")");
        if (startpoint == null) {
            this.beginProcessing();
            startpoint = this.jobinfo.findJobEntry("START", 0);
            if (startpoint == null) {
                this.log.logError(this.toString(), "Couldn't find starting point in this job.");
                return prev_result;
            }
            jer.setComment("Start of job");
        }
        jer.setThisJobEntry(startpoint);
        jer.setPrevJobEntry(previous);
        jer.setComment(comment);
        JobEntryInterface jei = startpoint.getEntry();
        Result result = jei.execute(prev_result, nr, this.rep, this);
        prev_result = (Result)result.clone();
        jer.setResult((Result)result.clone());
        this.jobEntryResults.add(jer.clone());
        int nrNext = this.jobinfo.findNrNextChefGraphEntries(startpoint);
        for (int i = 0; i < nrNext && !this.isStopped(); ++i) {
            JobEntryCopy nextEntry = this.jobinfo.findNextChefGraphEntry(startpoint, i);
            JobHopMeta hi = this.jobinfo.findJobHop(startpoint, nextEntry);
            String nextComment = null;
            nextComment = hi.isUnconditional() ? "Followed unconditional link" : (result.getResult() ? "Followed link after succes!" : "Followed link after failure!");
            if (!hi.isUnconditional() && (!startpoint.evaluates() || hi.getEvaluation() ^ result.getResult())) continue;
            this.log.logBasic(this.jobinfo.toString(), "Starting entry [" + nextEntry.getName() + "]");
            res = this.execute(nr + 1, result, nextEntry, startpoint, nextComment);
            this.log.logBasic(this.jobinfo.toString(), "Finished jobentry [" + nextEntry.getName() + "] (result=" + res.getResult() + ")");
        }
        if (res == null) {
            res = prev_result;
        }
        return res;
    }

    public void waitUntilFinished() {
    }

    public int getErrors() {
        int errors = 0;
        return errors;
    }

    public boolean beginProcessing() {
        this.currentDate = new Date();
        this.logDate = new Date();
        this.startDate = Const.MIN_DATE;
        this.endDate = this.currentDate;
        this.startTime = this.currentDate;
        return true;
    }

    public boolean endProcessing(String status) throws ETLJobException {
        this.endTime = this.logDate = new Date();
        if (this.jobinfo.getJoblog() != null) {
            String log_string = this.log.getString();
            log_string = log_string + Const.CR + "END";
            this.log.setString("");
            this.log.endStringCapture();
            try {
                boolean isSuccess = this.getLastJobEntryResult().getResult().getResult();
                this.jobinfo.getJoblog().insertJobLog(this.startTime, this.endTime, this.logDate, isSuccess, log_string);
            }
            catch (ETLDatabaseException dbe) {
                throw new ETLJobException("Unable to end processing by writing log record to table " + this.jobinfo.logAuditTable + " & " + this.jobinfo.logErrorTable, dbe);
            }
        }
        return true;
    }

    public boolean isActive() {
        return this.active;
    }

    public void stopAll() {
        this.stopped = true;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public Date getDepDate() {
        return this.depDate;
    }

    public Date getLogDate() {
        return this.logDate;
    }

    public JobMeta getJobinfo() {
        return this.jobinfo;
    }

    public LogWriter getLog() {
        return this.log;
    }

    public Repository getRep() {
        return this.rep;
    }

    public void setJobEntryResults(ArrayList jobEntryResults) {
        this.jobEntryResults = jobEntryResults;
    }

    public ArrayList getJobEntryResults() {
        return this.jobEntryResults;
    }

    public JobEntryResult getLastJobEntryResult() {
        if (this.jobEntryResults.size() > 0) {
            return (JobEntryResult)this.jobEntryResults.get(this.jobEntryResults.size() - 1);
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    public long getID() {
        if (this.jobinfo != null) {
            return this.jobinfo.getID();
        }
        return -1L;
    }
}

