/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.job.entry.sql;

import com.kingdee.bos.ctrl.etl.base.Result;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.job.Job;
import com.kingdee.bos.ctrl.etl.job.entry.JobEntryBase;
import com.kingdee.bos.ctrl.etl.job.entry.JobEntryInterface;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import java.sql.Connection;
import java.util.List;
import org.w3c.dom.Node;

public class JobEntrySQL
extends JobEntryBase
implements JobEntryInterface {
    private String sql;
    private DatabaseMeta connection;

    public JobEntrySQL(String n) {
        super(n, "");
        this.sql = null;
        this.connection = null;
        this.setID(-1L);
        this.setType(5);
    }

    public JobEntrySQL() {
        this("");
    }

    public JobEntrySQL(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + super.getXML();
        retval = retval + "      " + XMLHandler.addTagValue("sql", this.sql);
        retval = retval + "      " + XMLHandler.addTagValue("connection", this.connection == null ? null : this.connection.getName());
        return retval;
    }

    @Override
    public void loadXML(Node entrynode, List databases, Connection ctxConnection) throws ETLXMLException {
        try {
            super.loadXML(entrynode, databases, ctxConnection);
            this.sql = XMLHandler.getTagValue(entrynode, "sql");
            String dbname = XMLHandler.getTagValue(entrynode, "connection");
            this.connection = Const.findDatabase(databases, dbname);
        }
        catch (ETLException e) {
            throw new ETLXMLException("Unable to load SQL job entry from XML node", e);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List databases) throws ETLException {
        try {
            super.loadRep(rep, id_jobentry, databases);
            this.sql = rep.getJobEntryAttributeString(id_jobentry, "sql");
            long id_db = rep.getJobEntryAttributeInteger(id_jobentry, "id_database");
            if (id_db >= 0L) {
                this.connection = Const.findDatabase(databases, id_db);
            }
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("unable to load job entry of type SQL to the repository with id_jobentry=" + id_jobentry, dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws ETLException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "id_database", this.connection != null ? (double)this.connection.getID() : -1.0);
            rep.saveJobEntryAttribute(id_job, this.getID(), "sql", this.sql);
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to save job entry of type SQL to the repository for id_job=" + id_job, dbe);
        }
    }

    public void setSQL(String sql) {
        this.sql = sql;
    }

    public String getSQL() {
        return this.sql;
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Result prev_result, int nr, Repository rep, Job parentJob) {
        LogWriter log = LogWriter.getInstance();
        Result result = new Result(nr);
        if (this.connection != null) {
            Database db = new Database(this.connection);
            try {
                db.connect();
                db.execStatements(this.sql);
            }
            catch (ETLDatabaseException je) {
                result.setNrErrors(1L);
                log.logError(this.toString(), "An error occurred executing this job entry : " + je.getMessage());
            }
            finally {
                db.disconnect();
            }
        } else {
            result.setNrErrors(1L);
            log.logError(this.toString(), "No database connection is defined.");
        }
        if (result.getNrErrors() == 0L) {
            result.setResult(true);
        } else {
            result.setResult(false);
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return true;
    }
}

