/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.repository;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.repository.ProfileMeta;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.util.Encr;
import com.kingdee.bos.ctrl.etl.value.Value;

public class UserInfo {
    private long id;
    private String login;
    private String password;
    private String name;
    private String description;
    private boolean enabled;
    private ProfileMeta profile;

    public UserInfo(String login, String password, String name, String description, boolean enabled, ProfileMeta profile) {
        this.login = login;
        this.password = password;
        this.name = name;
        this.description = description;
        this.enabled = enabled;
        this.profile = profile;
    }

    public UserInfo() {
        this.login = null;
        this.password = null;
        this.name = null;
        this.description = null;
        this.enabled = true;
        this.profile = null;
    }

    public UserInfo(Repository rep, String login) throws ETLException {
        block3: {
            try {
                this.setID(rep.getUserID(login));
                if (this.getID() <= 0L) break block3;
                Row r = rep.getUser(this.getID());
                if (r != null) {
                    this.login = r.searchValue("Login").getString();
                    this.password = r.searchValue("Password").getString();
                    this.name = r.searchValue("Name").getString();
                    this.description = r.searchValue("Description").getString();
                    this.enabled = r.searchValue("Enabled").getBoolean();
                    long id_profile = r.searchValue("ID_Profile").getInteger();
                    this.password = this.password != null && this.password.startsWith("Encrypted ") ? Encr.decryptPassword(this.password.substring(10)) : Encr.decryptPassword(this.password);
                    this.profile = new ProfileMeta(rep, id_profile);
                    break block3;
                }
                this.setID(-1L);
                throw new ETLDatabaseException("User [" + login + "] couldn't be found!");
            }
            catch (ETLDatabaseException dbe) {
                rep.log.logError(this.toString(), "Unable to load user with login [" + login + "] from the repository: " + dbe.getMessage());
                throw new ETLException("Unable to load user with login [" + login + "] from the repository", dbe);
            }
        }
    }

    public UserInfo(Repository rep, String login, String passwd) throws ETLException {
        this(rep, login);
        if (this.getID() < 0L || !passwd.equals(this.getPassword())) {
            throw new ETLException("Incorrect password or login!");
        }
    }

    public void saveRep(Repository rep) throws ETLException {
        try {
            if (this.getID() <= 0L) {
                this.setID(rep.getUserID(this.login));
            }
            if (this.getID() <= 0L) {
                this.setID(rep.getNextUserID());
                rep.insertTableRow("T_ETL_User", this.fillTableRow());
            } else {
                rep.updateTableRow("T_ETL_User", "ID_USER", this.fillTableRow());
            }
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Error saving User in repository", dbe);
        }
    }

    public Row fillTableRow() {
        Row r = new Row();
        r.addValue(new Value("ID_User", this.getID()));
        r.addValue(new Value("Login", this.login));
        r.addValue(new Value("Password", Encr.encryptPassword(this.password)));
        r.addValue(new Value("Name", this.name));
        r.addValue(new Value("Description", this.description));
        r.addValue(new Value("Enabled", this.enabled));
        r.addValue(new Value("ID_Profile", this.profile.getID()));
        return r;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getLogin() {
        return this.login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setEnabled() {
        this.setEnabled(true);
    }

    public void setDisabled() {
        this.setEnabled(false);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setProfile(ProfileMeta profile) {
        this.profile = profile;
    }

    public ProfileMeta getProfile() {
        return this.profile;
    }

    public long getID() {
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
    }

    public boolean isReadonly() {
        if (this.profile == null) {
            return true;
        }
        return this.profile.isReadonly();
    }

    public boolean isAdministrator() {
        if (this.profile == null) {
            return false;
        }
        return this.profile.isAdministrator();
    }

    public boolean useTransformations() {
        if (this.profile == null) {
            return false;
        }
        return this.profile.useTransformations();
    }

    public boolean useJobs() {
        if (this.profile == null) {
            return false;
        }
        return this.profile.useJobs();
    }

    public boolean useSchemas() {
        if (this.profile == null) {
            return false;
        }
        return this.profile.useSchemas();
    }
}

